/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.SelectManyRendererBase;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectManyCheckboxRenderer
extends SelectManyRendererBase {
    private static final Log LOG = LogFactory.getLog(SelectManyCheckboxRenderer.class);

    public void encodeEndTobago(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UISelectMany component = (UISelectMany)uiComponent;
        List items = ComponentUtil.getItemsToRender((UISelectMany)component);
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        Object[] values = component.getSelectedValues();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("values = '" + values + "'"));
        }
        String id = component.getClientId(facesContext);
        writer.startElement("table", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("summary", (Object)"", null);
        for (SelectItem item : items) {
            writer.startElement("tr", null);
            writer.startElement("td", null);
            String itemId = id + ':' + ':' + item.getValue().toString();
            writer.startElement("input", (UIComponent)component);
            writer.writeAttribute("type", (Object)"checkbox", null);
            writer.writeComponentClass();
            writer.writeAttribute("checked", RenderUtil.contains((Object[])values, (Object)item.getValue()));
            writer.writeNameAttribute(id);
            writer.writeIdAttribute(itemId);
            String formattedValue = SelectManyCheckboxRenderer.getFormattedValue((FacesContext)facesContext, (UIComponent)component, (Object)item.getValue());
            writer.writeAttribute("value", (Object)formattedValue, null);
            writer.writeAttribute("disabled", ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"disabled"));
            writer.endElement("input");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("item.getLabel() = " + item.getLabel()));
            }
            if (item.getLabel() != null) {
                writer.endElement("td");
                writer.startElement("td", null);
                writer.startElement("label", null);
                writer.writeClassAttribute("tobago-label-default");
                writer.writeAttribute("for", (Object)itemId, null);
                writer.writeText((Object)item.getLabel(), null);
                writer.endElement("label");
            }
            writer.endElement("td");
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        List items = ComponentUtil.getItemsToRender((UISelectMany)((UISelectMany)component));
        return items.size() * super.getFixedHeight(facesContext, component);
    }
}

