/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.SelectManyRendererBase;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectManyListboxRenderer
extends SelectManyRendererBase {
    private static final Log LOG = LogFactory.getLog(SelectManyListboxRenderer.class);

    public boolean getRendersChildren() {
        return true;
    }

    public int getComponentExtraWidth(FacesContext facesContext, UIComponent component) {
        int space = 0;
        return space;
    }

    public int getLabelWidth(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "labelWidth");
    }

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        int fixedHeight = -1;
        String height = (String)component.getAttributes().get("height");
        if (height != null) {
            try {
                fixedHeight = Integer.parseInt(height.replaceAll("\\D", ""));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Can't parse " + height + " to int"));
            }
        }
        if (fixedHeight == -1) {
            fixedHeight = super.getFixedHeight(facesContext, component);
        }
        return fixedHeight;
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UISelectMany component = (UISelectMany)uiComponent;
        List items = ComponentUtil.getSelectItems((UIComponent)component);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("items.size() = '" + items.size() + "'"));
        }
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        writer.startElement("select", (UIComponent)component);
        String clientId = component.getClientId(facesContext);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute("disabled", ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"disabled"));
        writer.writeAttribute("style", null, "style");
        writer.writeComponentClass();
        writer.writeAttribute("multiple", (Object)"multiple", null);
        writer.writeAttribute("title", null, "tip");
        Object[] values = component.getSelectedValues();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("values = '" + values + "'"));
        }
        for (SelectItem item : items) {
            writer.startElement("option", null);
            String formattedValue = SelectManyListboxRenderer.getFormattedValue((FacesContext)facesContext, (UIComponent)component, (Object)item.getValue());
            writer.writeAttribute("value", (Object)formattedValue, null);
            if (RenderUtil.contains((Object[])values, (Object)item.getValue())) {
                writer.writeAttribute("selected", (Object)"selected", null);
            }
            writer.writeText((Object)item.getLabel(), null);
            writer.endElement("option");
        }
        writer.endElement("select");
    }
}

