/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.renderkit.SelectOneRendererBase;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectOneListboxRenderer
extends SelectOneRendererBase {
    private static final Log LOG = LogFactory.getLog(SelectOneListboxRenderer.class);

    public boolean getRendersChildren() {
        return true;
    }

    public int getComponentExtraWidth(FacesContext facesContext, UIComponent component) {
        int space = 0;
        return space;
    }

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        int fixedHeight = -1;
        String height = (String)component.getAttributes().get("height");
        if (height != null) {
            try {
                fixedHeight = Integer.parseInt(height.replaceAll("\\D", ""));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Can't parse " + height + " to int"));
            }
        }
        if (fixedHeight == -1) {
            fixedHeight = super.getFixedHeight(facesContext, component);
        }
        return fixedHeight;
    }

    protected void renderMain(FacesContext facesContext, UIComponent input, TobagoResponseWriter writer) throws IOException {
        UISelectOne component = (UISelectOne)input;
        List items = ComponentUtil.getSelectItems((UIComponent)component);
        writer.startElement("select", (UIComponent)component);
        String clientId = component.getClientId(facesContext);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute("disabled", ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"disabled"));
        writer.writeAttribute("style", null, "style");
        writer.writeComponentClass();
        writer.writeAttribute("title", null, "tip");
        writer.writeAttribute("size", (Object)2, null);
        if (!ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"required")) {
            writer.writeAttribute("onchange", (Object)"Tobago.selectOneListboxChange(this)", null);
            writer.writeAttribute("onclick", (Object)"Tobago.selectOneListboxClick(this)", null);
        }
        Object value = component.getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("value = '" + value + "'"));
        }
        for (SelectItem item : items) {
            writer.startElement("option", null);
            Object itemValue = item.getValue();
            String formattedValue = SelectOneListboxRenderer.getFormattedValue((FacesContext)facesContext, (UIComponent)component, (Object)itemValue);
            writer.writeAttribute("value", (Object)formattedValue, null);
            if (itemValue.equals(value)) {
                writer.writeAttribute("selected", (Object)"selected", null);
            }
            writer.writeText((Object)item.getLabel(), null);
            writer.endElement("option");
        }
        writer.endElement("select");
    }
}

