/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.renderkit.SelectOneRendererBase;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectOneRadioRenderer
extends SelectOneRendererBase {
    private static final Log LOG = LogFactory.getLog(SelectOneRadioRenderer.class);

    protected void renderMain(FacesContext facesContext, UIComponent input, TobagoResponseWriter writer) throws IOException {
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UISelectOne component = (UISelectOne)uiComponent;
        String clientId = component.getClientId(facesContext);
        ComponentUtil.findPage((UIComponent)component).getOnloadScripts().add("Tobago.selectOneRadioInit('" + clientId + "')");
        if (LOG.isDebugEnabled()) {
            for (Object o : component.getChildren()) {
                LOG.debug((Object)("ITEMS " + o));
                if (!(o instanceof UISelectItems)) continue;
                UISelectItems uiitems = (UISelectItems)o;
                Object v = uiitems.getValue();
                LOG.debug((Object)("VALUE " + v));
                if (v == null) continue;
                LOG.debug((Object)("VALUE " + v.getClass().getName()));
            }
        }
        List items = ComponentUtil.getItemsToRender((UISelectOne)component);
        boolean inline = ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"inline");
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        if (!inline) {
            writer.startElement("table", (UIComponent)component);
            writer.writeAttribute("border", (Object)"0", null);
            writer.writeAttribute("cellspacing", (Object)"0", null);
            writer.writeAttribute("cellpadding", (Object)"0", null);
            writer.writeAttribute("summary", (Object)"", null);
            writer.writeAttribute("title", null, "tip");
        }
        Object value = component.getValue();
        for (SelectItem item : items) {
            if (!inline) {
                writer.startElement("tr", null);
                writer.startElement("td", null);
            }
            String id = clientId + ':' + ':' + item.getValue().toString();
            writer.startElement("input", (UIComponent)component);
            writer.writeAttribute("type", (Object)"radio", null);
            writer.writeComponentClass();
            if (item.getValue().equals(value)) {
                writer.writeAttribute("checked", (Object)"checked", null);
            }
            writer.writeNameAttribute(clientId);
            writer.writeIdAttribute(id);
            String formattedValue = SelectOneRadioRenderer.getFormattedValue((FacesContext)facesContext, (UIComponent)component, (Object)item.getValue());
            writer.writeAttribute("value", (Object)formattedValue, null);
            writer.writeAttribute("disabled", ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"disabled"));
            writer.writeAttribute("title", null, "tip");
            if (!ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"required")) {
                writer.writeAttribute("onclick", (Object)("Tobago.selectOneRadioClick(this, '" + clientId + "')"), null);
            }
            writer.endElement("input");
            if (item.getLabel() != null) {
                if (!inline) {
                    writer.endElement("td");
                    writer.startElement("td", null);
                }
                writer.startElement("label", null);
                writer.writeClassAttribute("tobago-label-default");
                writer.writeAttribute("for", (Object)id, null);
                writer.writeText((Object)item.getLabel(), null);
                writer.endElement("label");
            }
            if (inline) continue;
            writer.endElement("td");
            writer.endElement("tr");
        }
        if (!inline) {
            writer.endElement("table");
        }
    }

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        List items = ComponentUtil.getItemsToRender((UISelectOne)((UISelectOne)component));
        return items.size() * super.getFixedHeight(facesContext, component);
    }
}

