/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIColumn;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxRenderer;
import org.apache.myfaces.tobago.ajax.api.AjaxUtils;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIColumnSelector;
import org.apache.myfaces.tobago.component.UIData;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.ResourceManager;
import org.apache.myfaces.tobago.context.ResourceManagerFactory;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.event.PageAction;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.SheetRendererWorkaround;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag.ButtonRenderer;
import org.apache.myfaces.tobago.util.StringUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetRenderer
extends RendererBase
implements SheetRendererWorkaround,
AjaxRenderer {
    private static final Log LOG = LogFactory.getLog(SheetRenderer.class);
    public static final String WIDTHS_POSTFIX = "::widths";
    public static final String SELECTED_POSTFIX = "::selected";
    private static final Integer HEIGHT_0 = 0;

    public void encodeEndTobago(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIData data = (UIData)uiComponent;
        HtmlRendererUtil.createHeaderAndBodyStyles((FacesContext)facesContext, (UIComponent)data);
        String sheetId = data.getClientId(facesContext);
        String sheetStyle = (String)data.getAttributes().get("style");
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeIdAttribute(sheetId + "_outer_div");
        writer.writeClassAttribute("tobago-sheet-outer-div");
        writer.writeAttribute("style", (Object)sheetStyle, null);
        this.renderSheet(facesContext, data);
        writer.endElement("div");
        ResourceManager resourceManager = ResourceManagerFactory.getResourceManager((FacesContext)facesContext);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        String contextPath = facesContext.getExternalContext().getRequestContextPath();
        String unchecked = contextPath + resourceManager.getImage(viewRoot, "image/sheetUnchecked.gif");
        String checked = contextPath + resourceManager.getImage(viewRoot, "image/sheetChecked.gif");
        boolean ajaxEnabled = TobagoConfig.getInstance((FacesContext)facesContext).isAjaxEnabled();
        String[] styles = new String[]{"style/tobago-sheet.css"};
        String[] scripts = new String[]{"script/tobago-sheet.js"};
        String[] cmds = new String[]{"new Tobago.Sheet(\"" + sheetId + "\", " + ajaxEnabled + ", \"" + checked + "\", \"" + unchecked + "\");"};
        ComponentUtil.addStyles((UIComponent)data, (String[])styles);
        ComponentUtil.addScripts((UIComponent)data, (String[])scripts);
        if (!ajaxEnabled) {
            ComponentUtil.addOnloadCommands((UIComponent)data, (String[])cmds);
        } else {
            HtmlRendererUtil.writeStyleLoader((FacesContext)facesContext, (String[])styles);
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])scripts, (String[])cmds);
        }
    }

    private void renderSheet(FacesContext facesContext, UIData data) throws IOException {
        String sheetBodyStyle;
        String space;
        int sheetHeight;
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        ResourceManager resourceManager = ResourceManagerFactory.getResourceManager((FacesContext)facesContext);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        String contextPath = facesContext.getExternalContext().getRequestContextPath();
        String sheetId = data.getClientId(facesContext);
        String image1x1 = contextPath + resourceManager.getImage(viewRoot, "image/1x1.gif");
        String ascending = contextPath + resourceManager.getImage(viewRoot, "image/ascending.gif");
        String descending = contextPath + resourceManager.getImage(viewRoot, "image/descending.gif");
        String selectorDisabled = contextPath + resourceManager.getImage(viewRoot, "image/sheetUncheckedDisabled.gif");
        String unchecked = contextPath + resourceManager.getImage(viewRoot, "image/sheetUnchecked.gif");
        Map attributes = data.getAttributes();
        String sheetStyle = (String)attributes.get("style");
        String headerStyle = (String)attributes.get("style_header");
        String sheetHeightString = HtmlRendererUtil.getStyleAttributeValue((String)sheetStyle, (String)"height");
        if (sheetHeightString != null) {
            sheetHeight = Integer.parseInt(sheetHeightString.replaceAll("\\D", ""));
        } else {
            LOG.error((Object)"no height in parent container, setting to 100");
            sheetHeight = 100;
        }
        String bodyStyle = (String)attributes.get("style_body");
        int footerHeight = (Integer)attributes.get("footerHeight");
        Application application = facesContext.getApplication();
        SheetState state = data.getSheetState(facesContext);
        List columnWidths = data.getWidthList();
        String selectedRows = StringUtil.toString(this.getSelectedRows(data, state));
        List columnList = data.getRendererdColumns();
        writer.startElement("input", null);
        writer.writeIdAttribute(sheetId + WIDTHS_POSTFIX);
        writer.writeNameAttribute(sheetId + WIDTHS_POSTFIX);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)"", null);
        writer.endElement("input");
        writer.startElement("input", null);
        writer.writeIdAttribute(sheetId + SELECTED_POSTFIX);
        writer.writeNameAttribute(sheetId + SELECTED_POSTFIX);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)selectedRows, null);
        writer.endElement("input");
        boolean showHeader = data.isShowHeader();
        if (showHeader) {
            writer.startElement("div", null);
            writer.writeIdAttribute(sheetId + "_header_div");
            writer.writeClassAttribute("tobago-sheet-header-div");
            writer.writeAttribute("style", (Object)headerStyle, null);
            int columnCount = 0;
            int sortMarkerWidth = this.getAscendingMarkerWidth(facesContext, (UIComponent)data);
            for (UIColumn column : columnList) {
                this.renderColumnHeader(facesContext, writer, data, columnCount, column, ascending, descending, image1x1, sortMarkerWidth);
                ++columnCount;
            }
            writer.startElement("div", null);
            writer.writeIdAttribute(sheetId + "_header_box_filler");
            writer.writeClassAttribute("tobago-sheet-header-box");
            writer.writeAttribute("style", (Object)"width: 0px", null);
            writer.startElement("div", null);
            writer.writeClassAttribute("tobago-sheet-header");
            writer.write("&nbsp;");
            writer.endElement("div");
            writer.endElement("div");
            writer.endElement("div");
        }
        if ((space = HtmlRendererUtil.getStyleAttributeValue((String)(bodyStyle = HtmlRendererUtil.replaceStyleAttribute((String)bodyStyle, (String)"height", (String)(sheetHeight - footerHeight + "px"))), (String)"width")) != null) {
            int intSpace = Integer.parseInt(space.replaceAll("\\D", ""));
            intSpace -= this.getContentBorder(facesContext, data);
            if (this.needVerticalScrollbar(facesContext, data)) {
                intSpace -= this.getScrollbarWidth(facesContext, (UIComponent)data);
            }
            sheetBodyStyle = HtmlRendererUtil.replaceStyleAttribute((String)bodyStyle, (String)"width", (String)(intSpace + "px"));
        } else {
            sheetBodyStyle = bodyStyle;
        }
        sheetBodyStyle = HtmlRendererUtil.removeStyleAttribute((String)sheetBodyStyle, (String)"height");
        if (!showHeader) {
            bodyStyle = bodyStyle + " padding-top: 0px;";
        }
        writer.startElement("div", null);
        writer.writeIdAttribute(sheetId + "_data_div");
        writer.writeClassAttribute("tobago-sheet-body-div ");
        writer.writeAttribute("style", (Object)bodyStyle, null);
        writer.startElement("table", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("summary", (Object)"", null);
        writer.writeClassAttribute("tobago-sheet-body-table");
        writer.writeAttribute("style", (Object)sheetBodyStyle, null);
        if (columnWidths != null) {
            writer.startElement("colgroup", null);
            for (Integer columnWidth : columnWidths) {
                writer.startElement("col", null);
                writer.writeAttribute("width", (Object)columnWidth, null);
                writer.endElement("col");
            }
            writer.endElement("colgroup");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("first = " + data.getFirst() + "   rows = " + data.getRows()));
        }
        String var = data.getVar();
        boolean odd = false;
        int visibleIndex = -1;
        int last = data.getFirst() + data.getRows();
        for (int rowIndex = data.getFirst(); rowIndex < last; ++rowIndex) {
            String rowClass;
            ++visibleIndex;
            data.setRowIndex(rowIndex);
            if (!data.isRowAvailable()) break;
            odd = !odd;
            String string = rowClass = odd ? "tobago-sheet-content-odd " : "tobago-sheet-content-even ";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("var       " + var));
                LOG.debug((Object)("list      " + data.getValue()));
            }
            writer.startElement("tr", null);
            writer.writeClassAttribute(rowClass);
            writer.writeIdAttribute(sheetId + "_data_tr_" + rowIndex);
            writer.writeText((Object)"", null);
            int columnIndex = -1;
            for (UIColumn column : data.getRendererdColumns()) {
                String style = "width: " + columnWidths.get(++columnIndex) + "px;";
                String tdStyle = "";
                String align = (String)column.getAttributes().get("align");
                if (align != null) {
                    tdStyle = "text-align: " + align;
                }
                String cellClass = (String)column.getAttributes().get("styleClass");
                String tdClass = "tobago-sheet-cell-td " + (cellClass != null ? cellClass : "");
                writer.startElement("td", (UIComponent)column);
                writer.writeClassAttribute(tdClass);
                writer.writeAttribute("style", (Object)tdStyle, null);
                writer.startElement("div", null);
                writer.writeIdAttribute(sheetId + "_data_row_" + visibleIndex + "_column" + columnIndex);
                writer.writeClassAttribute("tobago-sheet-cell-outer");
                writer.writeAttribute("style", (Object)style, null);
                writer.startElement("div", null);
                writer.writeClassAttribute("tobago-sheet-cell-inner");
                writer.writeText((Object)"", null);
                if (column instanceof UIColumnSelector) {
                    boolean disabled = ComponentUtil.getBooleanAttribute((UIComponent)column, (String)"disabled");
                    writer.startElement("img", null);
                    if (disabled) {
                        writer.writeAttribute("src", (Object)selectorDisabled, null);
                    } else {
                        writer.writeAttribute("src", (Object)unchecked, null);
                    }
                    writer.writeIdAttribute(sheetId + "_data_row_selector_" + rowIndex);
                    writer.writeClassAttribute("tobago-sheet-column-selector");
                    writer.endElement("img");
                } else {
                    for (UIComponent grandkid : data.getRenderedChildrenOf(column)) {
                        grandkid.getAttributes().put("layoutHeight", HEIGHT_0);
                        RenderUtil.encode((FacesContext)facesContext, (UIComponent)grandkid);
                    }
                }
                writer.endElement("div");
                writer.endElement("div");
                writer.endElement("td");
            }
            writer.startElement("td", null);
            writer.writeClassAttribute("tobago-sheet-cell-td");
            writer.startElement("div", null);
            writer.writeIdAttribute(sheetId + "_data_row_" + visibleIndex + "_column_filler");
            writer.writeClassAttribute("tobago-sheet-cell-outer");
            writer.writeAttribute("style", (Object)"width: 0px;", null);
            writer.write("&nbsp;");
            writer.endElement("div");
            writer.endElement("td");
            writer.endElement("tr");
        }
        data.setRowIndex(-1);
        writer.endElement("table");
        writer.endElement("div");
        String showRowRange = this.getPagingAttribute(data, "showRowRange");
        String showPageRange = this.getPagingAttribute(data, "showPageRange");
        String showDirectLinks = this.getPagingAttribute(data, "showDirectLinks");
        if (this.isValidPagingValue(showRowRange) || this.isValidPagingValue(showPageRange) || this.isValidPagingValue(showDirectLinks)) {
            String className;
            String pagerCommandId;
            String pagingOnClick;
            UICommand pagerCommand;
            String footerStyle = HtmlRendererUtil.replaceStyleAttribute((String)bodyStyle, (String)"height", (String)(footerHeight + "px")) + " top: " + (sheetHeight - footerHeight) + "px;";
            writer.startElement("div", (UIComponent)data);
            writer.writeClassAttribute("tobago-sheet-footer");
            writer.writeAttribute("style", (Object)footerStyle, null);
            if (this.isValidPagingValue(showRowRange)) {
                pagerCommand = (UICommand)data.getFacet("pagerRow");
                if (pagerCommand == null) {
                    pagerCommand = SheetRenderer.createPagingCommand(application, PageAction.TO_ROW, false);
                    data.getFacets().put("pagerRow", pagerCommand);
                }
                pagingOnClick = ButtonRenderer.createOnClick(facesContext, (UIComponent)pagerCommand);
                pagingOnClick = pagingOnClick.replaceAll("'", "\"");
                pagerCommandId = pagerCommand.getClientId(facesContext);
                className = "tobago-sheet-paging-rows-span tobago-sheet-paging-span-" + showRowRange;
                writer.startElement("span", null);
                writer.writeAttribute("onclick", (Object)("tobagoSheetEditPagingRow(this, '" + pagerCommandId + "', '" + pagingOnClick + "')"), null);
                writer.writeClassAttribute(className);
                writer.writeAttribute("title", (Object)ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetPagingInfoRowPagingTip"), null);
                writer.write(this.createSheetPagingInfo(data, facesContext, pagerCommandId, true));
                writer.endElement("span");
            }
            if (this.isValidPagingValue(showDirectLinks)) {
                String className2 = "tobago-sheet-paging-links-span tobago-sheet-paging-span-" + showDirectLinks;
                writer.startElement("span", null);
                writer.writeClassAttribute(className2);
                writer.writeIdAttribute(sheetId + "::" + "pagingLinks");
                this.writeDirectPagingLinks(writer, facesContext, application, data);
                writer.endElement("span");
            }
            if (this.isValidPagingValue(showPageRange)) {
                pagerCommand = (UICommand)data.getFacet("pagerPage");
                if (pagerCommand == null) {
                    pagerCommand = SheetRenderer.createPagingCommand(application, PageAction.TO_PAGE, false);
                    data.getFacets().put("pagerPage", pagerCommand);
                }
                pagingOnClick = ButtonRenderer.createOnClick(facesContext, (UIComponent)pagerCommand);
                pagingOnClick = pagingOnClick.replaceAll("'", "\"");
                pagerCommandId = pagerCommand.getClientId(facesContext);
                className = "tobago-sheet-paging-pages-span tobago-sheet-paging-span-" + showPageRange;
                writer.startElement("span", null);
                writer.writeClassAttribute(className);
                writer.writeIdAttribute(sheetId + "::" + "pagingPages");
                writer.writeText((Object)"", null);
                boolean atBeginning = data.isAtBeginning();
                SheetRenderer.link(facesContext, application, atBeginning, PageAction.FIRST, data);
                SheetRenderer.link(facesContext, application, atBeginning, PageAction.PREV, data);
                writer.startElement("span", null);
                writer.writeClassAttribute("tobago-sheet-paging-pages-text");
                writer.writeAttribute("onclick", (Object)("tobagoSheetEditPagingRow(this, '" + pagerCommandId + "', '" + pagingOnClick + "')"), null);
                writer.writeAttribute("title", (Object)ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetPagingInfoPagePagingTip"), null);
                writer.write(this.createSheetPagingInfo(data, facesContext, pagerCommandId, false));
                writer.endElement("span");
                boolean atEnd = data.isAtEnd();
                SheetRenderer.link(facesContext, application, atEnd, PageAction.NEXT, data);
                SheetRenderer.link(facesContext, application, atEnd || !data.hasRowCount(), PageAction.LAST, data);
            }
            writer.endElement("span");
            writer.endElement("div");
        }
    }

    private String createSheetPagingInfo(UIData data, FacesContext facesContext, String pagerCommandId, boolean row) {
        String sheetPagingInfo;
        if (data.getRowCount() > 0) {
            int last;
            int first;
            Locale locale = facesContext.getViewRoot().getLocale();
            if (row) {
                first = data.getFirst() + 1;
                last = data.getLast();
            } else {
                first = data.getPage();
                last = data.getPages();
            }
            String key = first != last ? ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)("sheetPagingInfo" + (row ? "Rows" : "Pages"))) : ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)("sheetPagingInfoSingle" + (row ? "Row" : "Page")));
            MessageFormat detail = new MessageFormat(key, locale);
            Object[] args = new Object[]{first, last, data.getRowCount(), pagerCommandId + "::" + "text"};
            sheetPagingInfo = detail.format(args);
        } else {
            sheetPagingInfo = ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)("sheetPagingInfoEmpty" + (row ? "Row" : "Page")));
        }
        return sheetPagingInfo;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        String widths;
        super.decode(facesContext, component);
        String key = component.getClientId(facesContext) + WIDTHS_POSTFIX;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(key) && (widths = (String)requestParameterMap.get(key)).trim().length() > 0) {
            component.getAttributes().put("widthListString", widths);
        }
        if (requestParameterMap.containsKey(key = component.getClientId(facesContext) + SELECTED_POSTFIX)) {
            List selectedRows;
            String selected = (String)requestParameterMap.get(key);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("selected = " + selected));
            }
            try {
                selectedRows = StringUtil.parseIntegerList((String)selected);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)selected, (Throwable)e);
                selectedRows = Collections.emptyList();
            }
            component.getAttributes().put("selectedListString", selectedRows);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        this.storeFooterHeight(facesContext, component);
        super.encodeEnd(facesContext, component);
    }

    public boolean needVerticalScrollbar(FacesContext facesContext, UIData data) {
        String style;
        String heightString;
        Object forceScroolbar = data.getAttributes().get("forceVerticalScrollbar");
        if (forceScroolbar != null) {
            if ("true".equals(forceScroolbar)) {
                return true;
            }
            if ("false".equals(forceScroolbar)) {
                return false;
            }
            if (!"auto".equals(forceScroolbar)) {
                LOG.warn((Object)("Illegal value for attibute 'forceVerticalScrollbar' : \"" + forceScroolbar + "\""));
            }
        }
        if ((heightString = HtmlRendererUtil.getStyleAttributeValue((String)(style = (String)data.getAttributes().get("style")), (String)"height")) != null) {
            int height;
            int first = data.getFirst();
            int rows = Math.min(data.getRowCount(), first + data.getRows()) - first;
            int heightNeeded = this.getHeaderHeight(facesContext, (UIComponent)data) + this.getFooterHeight(facesContext, (UIComponent)data) + rows * (this.getFixedHeight(facesContext, null) + this.getRowPadding(facesContext, (UIComponent)data));
            return heightNeeded > (height = Integer.parseInt(heightString.replaceAll("\\D", "")));
        }
        return false;
    }

    private int getRowPadding(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "rowPadding");
    }

    public int getScrollbarWidth(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "scrollbarWidth");
    }

    private void storeFooterHeight(FacesContext facesContext, UIComponent component) {
        component.getAttributes().put("footerHeight", this.getFooterHeight(facesContext, component));
    }

    private int getFooterHeight(FacesContext facesContext, UIComponent component) {
        int footerHeight = this.isValidPagingAttribute((UIData)component, "showRowRange") || this.isValidPagingAttribute((UIData)component, "showPageRange") || this.isValidPagingAttribute((UIData)component, "showDirectLinks") ? this.getConfiguredValue(facesContext, component, "footerHeight") : 0;
        return footerHeight;
    }

    private boolean isValidPagingAttribute(UIData component, String name) {
        return this.isValidPagingValue(this.getPagingAttribute(component, name));
    }

    private String getPagingAttribute(UIData component, String name) {
        String value = ComponentUtil.getStringAttribute((UIComponent)component, (String)name);
        if (this.isValidPagingValue(value)) {
            return value;
        }
        if (!"none".equals(value)) {
            LOG.warn((Object)("illegal value in sheet' paging attribute : \"" + value + "\""));
        }
        return "none";
    }

    private boolean isValidPagingValue(String value) {
        return "left".equals(value) || "center".equals(value) || "right".equals(value);
    }

    private int getAscendingMarkerWidth(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "ascendingMarkerWidth");
    }

    public boolean getRendersChildren() {
        return true;
    }

    private List<Integer> getSelectedRows(UIData data, SheetState state) {
        List selected = (List)data.getAttributes().get("selectedListString");
        if (selected == null && state != null) {
            selected = state.getSelectedRows();
        }
        if (selected == null) {
            selected = Collections.emptyList();
        }
        return selected;
    }

    private static void link(FacesContext facesContext, Application application, boolean disabled, PageAction command, UIData data) throws IOException {
        UICommand link = SheetRenderer.createPagingCommand(application, command, disabled);
        data.getFacets().put(command.getToken(), link);
        String tip = ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)("sheet" + command.getToken()));
        String image = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)("image/sheet" + command.getToken() + (disabled ? "Disabled" : "") + ".gif"));
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        writer.startElement("img", null);
        writer.writeIdAttribute(data.getClientId(facesContext) + "::" + "pagingPages" + "::" + command.getToken());
        writer.writeClassAttribute("tobago-sheet-footer-pager-button" + (disabled ? " tobago-sheet-footer-pager-button-disabled" : ""));
        writer.writeAttribute("src", (Object)image, null);
        writer.writeAttribute("title", (Object)tip, null);
        if (!disabled) {
            String onClick = ButtonRenderer.createOnClick(facesContext, (UIComponent)link);
            writer.writeAttribute("onclick", (Object)onClick, null);
        }
        writer.endElement("img");
    }

    private void renderColumnHeader(FacesContext facesContext, TobagoResponseWriter writer, UIData component, int columnCount, UIColumn column, String ascending, String descending, String image1x1, int sortMarkerWidth) throws IOException {
        String resizerClass;
        String sheetId = component.getClientId(facesContext);
        Application application = facesContext.getApplication();
        List columnWidths = (List)component.getAttributes().get("widthList");
        String divWidth = "width: " + columnWidths.get(columnCount) + "px;";
        writer.startElement("div", null);
        writer.writeIdAttribute(sheetId + "_header_box_" + columnCount);
        writer.writeClassAttribute("tobago-sheet-header-box");
        writer.writeAttribute("style", (Object)divWidth, null);
        String sorterImage = null;
        String sorterClass = "";
        String sortTitle = "";
        boolean sortable = ComponentUtil.getBooleanAttribute((UIComponent)column, (String)"sortable");
        if (sortable && !(column instanceof UIColumnSelector)) {
            UICommand sortCommand = (UICommand)column.getFacet("sorter");
            if (sortCommand == null) {
                String columnId = column.getClientId(facesContext);
                String sorterId = columnId.substring(columnId.lastIndexOf(":") + 1) + "_" + "sorter";
                sortCommand = (UICommand)application.createComponent("javax.faces.Command");
                sortCommand.setRendererType("Link");
                sortCommand.setId(sorterId);
                column.getFacets().put("sorter", sortCommand);
            }
            String onclick = "Tobago.submitAction('" + sortCommand.getClientId(facesContext) + "')";
            writer.writeAttribute("onclick", (Object)onclick, null);
            writer.writeAttribute("title", (Object)ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetTipSorting"), null);
            SheetState sheetState = component.getSheetState(facesContext);
            if (column.getId().equals(sheetState.getSortedColumnId())) {
                if (sheetState.isAscending()) {
                    sorterImage = ascending;
                    sortTitle = ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetAscending");
                } else {
                    sorterImage = descending;
                    sortTitle = ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetDescending");
                }
            }
            sorterClass = " tobago-sheet-header-sortable";
        }
        String align = (String)column.getAttributes().get("align");
        writer.startElement("div", null);
        writer.writeIdAttribute(sheetId + "_header_outer_" + columnCount);
        writer.writeClassAttribute("tobago-sheet-header" + sorterClass);
        if (align != null) {
            writer.writeAttribute("style", (Object)("text-align: " + align + ";"), null);
        }
        if (column instanceof UIColumnSelector) {
            resizerClass = "tobago-sheet-header-resize";
            this.renderColumnSelectorHeader(facesContext, writer, component, column);
        } else {
            resizerClass = "tobago-sheet-header-resize tobago-sheet-header-resize-cursor";
            this.renderColumnHeaderLabel(facesContext, (ResponseWriter)writer, column, sortMarkerWidth, align, image1x1);
        }
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeIdAttribute(sheetId + "_header_resizer_" + columnCount);
        writer.writeClassAttribute(resizerClass);
        writer.write("&nbsp;");
        writer.endElement("div");
        if (sorterImage != null) {
            writer.startElement("div", null);
            writer.writeClassAttribute("tobago-sheet-header-sort-div");
            writer.writeAttribute("title", (Object)sortTitle, null);
            writer.startElement("img", null);
            writer.writeAttribute("src", (Object)sorterImage, null);
            writer.writeAttribute("alt", (Object)"", null);
            writer.writeAttribute("title", (Object)sortTitle, null);
            writer.endElement("img");
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    private void renderColumnSelectorHeader(FacesContext facesContext, TobagoResponseWriter writer, UIData component, UIColumn column) throws IOException {
        UIPanel menu = (UIPanel)column.getFacet("menupopup");
        if (menu == null) {
            Application application = facesContext.getApplication();
            menu = (UIPanel)application.createComponent("org.apache.myfaces.tobago.Menu");
            menu.setId("selectorMenu");
            column.getFacets().put("menupopup", menu);
            menu.setRendererType("MenuBar");
            menu.getAttributes().put("menuPopup", Boolean.TRUE);
            menu.getAttributes().put("menuPopupType", "SheetSelector");
            menu.getAttributes().put("image", "image/sheetSelectorMenu.gif");
            String sheetId = column.getParent().getClientId(facesContext);
            String action = "Tobago.Sheets.selectAll('" + sheetId + "')";
            String label = ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetMenuSelect");
            UICommand menuItem = this.createMenuItem(application, label, action);
            menuItem.setId("menuSelectAll");
            menu.getChildren().add(menuItem);
            action = "Tobago.Sheets.unSelectAll('" + sheetId + "')";
            label = ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetMenuUnselect");
            menuItem = this.createMenuItem(application, label, action);
            menuItem.setId("menuUnselectAll");
            menu.getChildren().add(menuItem);
            action = "Tobago.Sheets.toggleAllSelections('" + sheetId + "')";
            label = ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetMenuToggleselect");
            menuItem = this.createMenuItem(application, label, action);
            menuItem.setId("menuToggleSelections");
            menu.getChildren().add(menuItem);
        }
        writer.startElement("div", null);
        writer.writeIdAttribute(column.getClientId(facesContext));
        writer.writeClassAttribute("tobago-sheet-selector-menu");
        writer.endElement("div");
        RenderUtil.encode((FacesContext)facesContext, (UIComponent)menu);
    }

    private UICommand createMenuItem(Application application, String label, String action) {
        UICommand menuItem = (UICommand)application.createComponent("org.apache.myfaces.tobago.MenuCommand");
        menuItem.setRendererType("MenuCommand");
        menuItem.getAttributes().put("onclick", action);
        menuItem.getAttributes().put("label", label);
        return menuItem;
    }

    private void renderColumnHeaderLabel(FacesContext facesContext, ResponseWriter writer, UIColumn column, int sortMarkerWidth, String align, String image1x1) throws IOException {
        String label = (String)column.getAttributes().get("label");
        if (label != null) {
            writer.writeText((Object)label, null);
            SheetState sheetState = ((UIData)column.getParent()).getSheetState(facesContext);
            if (column.getId().equals(sheetState.getSortedColumnId()) && "right".equals(align)) {
                writer.startElement("img", null);
                writer.writeAttribute("src", (Object)image1x1, null);
                writer.writeAttribute("alt", (Object)"", null);
                writer.writeAttribute("width", (Object)Integer.toString(sortMarkerWidth), null);
                writer.writeAttribute("height", (Object)"1", null);
                writer.endElement("img");
            }
        } else {
            writer.startElement("img", null);
            writer.writeAttribute("src", (Object)image1x1, null);
            writer.writeAttribute("alt", (Object)"", null);
            writer.endElement("img");
        }
    }

    private void writeDirectPagingLinks(TobagoResponseWriter writer, FacesContext facesContext, Application application, UIData data) throws IOException {
        int skip;
        UICommand pagerCommand = (UICommand)data.getFacet("pagerPage");
        if (pagerCommand == null) {
            pagerCommand = SheetRenderer.createPagingCommand(application, PageAction.TO_PAGE, false);
            data.getFacets().put("pagerPage", pagerCommand);
        }
        String pagerCommandId = pagerCommand.getClientId(facesContext);
        String hrefPostfix = "', '" + ButtonRenderer.createOnClick(facesContext, (UIComponent)pagerCommand).replaceAll("'", "\"") + "');";
        int linkCount = ComponentUtil.getIntAttribute((UIComponent)data, (String)"directLinkCount");
        ArrayList<Integer> prevs = new ArrayList<Integer>(--linkCount);
        int page = data.getPage();
        for (int i = 0; i < linkCount && page > 1; ++i) {
            if (--page <= 0) continue;
            prevs.add(0, page);
        }
        ArrayList<Integer> nexts = new ArrayList<Integer>(linkCount);
        page = data.getPage();
        for (int i = 0; i < linkCount && page < data.getPages(); ++i) {
            if (++page <= 1) continue;
            nexts.add(page);
        }
        if (prevs.size() > linkCount / 2 && nexts.size() > linkCount - linkCount / 2) {
            while (prevs.size() > linkCount / 2) {
                prevs.remove(0);
            }
            while (nexts.size() > linkCount - linkCount / 2) {
                nexts.remove(nexts.size() - 1);
            }
        } else if (prevs.size() <= linkCount / 2) {
            while (prevs.size() + nexts.size() > linkCount) {
                nexts.remove(nexts.size() - 1);
            }
        } else {
            while (prevs.size() + nexts.size() > linkCount) {
                prevs.remove(0);
            }
        }
        int n = skip = prevs.size() > 0 ? (Integer)prevs.get(0) : 1;
        if (skip > 1) {
            skip -= linkCount - linkCount / 2;
            String name = "...";
            if (--skip < 1) {
                skip = 1;
                if ((Integer)prevs.get(0) == 2) {
                    name = "1";
                }
            }
            this.writeLinkElement(writer, name, Integer.toString(skip), pagerCommandId, hrefPostfix, true);
        }
        for (Integer prev : prevs) {
            String name = prev.toString();
            this.writeLinkElement(writer, name, name, pagerCommandId, hrefPostfix, true);
        }
        String name = Integer.toString(data.getPage());
        this.writeLinkElement(writer, name, name, pagerCommandId, hrefPostfix, false);
        for (Integer next : nexts) {
            name = next.toString();
            this.writeLinkElement(writer, name, name, pagerCommandId, hrefPostfix, true);
        }
        int n2 = skip = nexts.size() > 0 ? ((Integer)nexts.get(nexts.size() - 1)).intValue() : data.getPages();
        if (skip < data.getPages()) {
            skip += linkCount / 2;
            name = "...";
            if (++skip > data.getPages()) {
                skip = data.getPages();
                if ((Integer)nexts.get(nexts.size() - 1) == skip - 1) {
                    name = Integer.toString(skip);
                }
            }
            this.writeLinkElement(writer, name, Integer.toString(skip), pagerCommandId, hrefPostfix, true);
        }
    }

    private static UICommand createPagingCommand(Application application, PageAction command, boolean disabled) {
        UICommand link = (UICommand)application.createComponent("javax.faces.Command");
        link.setRendererType("SheetPageCommand");
        link.setRendered(true);
        link.setId(command.getToken());
        link.getAttributes().put("inline", Boolean.TRUE);
        link.getAttributes().put("disabled", disabled);
        return link;
    }

    private void writeLinkElement(TobagoResponseWriter writer, String str, String skip, String id, String hrefPostfix, boolean makeLink) throws IOException {
        String type = makeLink ? "a" : "span";
        writer.startElement(type, null);
        writer.writeClassAttribute("tobago-sheet-paging-links-link");
        if (makeLink) {
            writer.writeIdAttribute(id + "::" + "link_" + skip);
            writer.writeAttribute("href", (Object)("javascript: tobagoSheetSetPagerPage('" + id + "', '" + skip + hrefPostfix), null);
        }
        writer.write(str);
        writer.endElement(type);
    }

    public int getContentBorder(FacesContext facesContext, UIData data) {
        return this.getConfiguredValue(facesContext, (UIComponent)data, "contentBorder");
    }

    public void encodeAjax(FacesContext facesContext, UIComponent component) throws IOException {
        AjaxUtils.checkParamValidity((FacesContext)facesContext, (UIComponent)component, UIData.class);
        this.renderSheet(facesContext, (UIData)component);
        facesContext.responseComplete();
    }
}

