/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxRenderer;
import org.apache.myfaces.tobago.ajax.api.AjaxUtils;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UIPanel;
import org.apache.myfaces.tobago.component.UITabGroup;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.event.TabChangeEvent;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.StyleAttribute;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.util.AccessKeyMap;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TabGroupRenderer
extends RendererBase
implements AjaxRenderer {
    private static final Log LOG = LogFactory.getLog(TabGroupRenderer.class);
    public static final String ACTIVE_INDEX_POSTFIX = "::activeIndex";

    public void decode(FacesContext facesContext, UIComponent component) {
        if (ComponentUtil.isOutputOnly((UIComponent)component)) {
            return;
        }
        int oldIndex = ((UITabGroup)component).getRenderedIndex();
        String clientId = component.getClientId(facesContext);
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        String newValue = (String)parameters.get(clientId + ACTIVE_INDEX_POSTFIX);
        try {
            int activeIndex = Integer.parseInt(newValue);
            if (activeIndex != oldIndex) {
                ((UITabGroup)component).setActiveIndex(activeIndex);
                TabChangeEvent event = new TabChangeEvent(component, (Object)new Integer(oldIndex), (Object)new Integer(activeIndex));
                event.setPhaseId(PhaseId.UPDATE_MODEL_VALUES);
                component.queueEvent((FacesEvent)event);
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("Can't parse activeIndex: '" + newValue + "'"));
        }
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UITabGroup component = (UITabGroup)uiComponent;
        HtmlRendererUtil.createHeaderAndBodyStyles((FacesContext)facesContext, (UIComponent)component);
        String image1x1 = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/1x1.gif");
        UIPanel[] tabs = component.getTabs();
        this.layoutTabs(facesContext, component, tabs);
        int activeIndex = component.getActiveIndex();
        String clientId = component.getClientId(facesContext);
        String hiddenId = clientId + ACTIVE_INDEX_POSTFIX;
        String switchType = component.getSwitchType();
        UIPage page = ComponentUtil.findPage((UIComponent)component);
        page.getScriptFiles().add("script/tab.js");
        page.getScriptFiles().add("script/tabgroup.js");
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)Integer.toString(activeIndex), null);
        writer.writeNameAttribute(hiddenId);
        writer.writeIdAttribute(hiddenId);
        writer.endElement("input");
        for (int virtualTab = 0; virtualTab < tabs.length; ++virtualTab) {
            if (!"client".equals(switchType) && virtualTab != activeIndex) continue;
            StyleAttribute oStyle = new StyleAttribute((String)component.getAttributes().get("style"));
            if (virtualTab != activeIndex) {
                oStyle.add("display", "none");
            }
            writer.startElement("div", null);
            writer.writeComment((Object)"empty div fix problem with mozilla and fieldset");
            writer.endElement("div");
            writer.startElement("div", null);
            writer.writeIdAttribute(clientId);
            this.renderTabGroupView(facesContext, writer, component, virtualTab, oStyle, switchType, image1x1);
            writer.endElement("div");
            if (!TobagoConfig.getInstance((FacesContext)facesContext).isAjaxEnabled() || !"reloadTab".equals(switchType)) continue;
            String pageId = ComponentUtil.findPage((UIComponent)component).getClientId(facesContext);
            String[] scripts = new String[]{"script/tab.js", "script/tabgroup.js"};
            String[] cmds = new String[]{"new Tobago.TabGroup(", "    '" + clientId + "', ", "    '" + activeIndex + "');"};
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])scripts, (String[])cmds);
        }
    }

    private void renderTabGroupView(FacesContext facesContext, TobagoResponseWriter writer, UITabGroup component, int virtualTab, StyleAttribute oStyle, String switchType, String image1x1) throws IOException {
        UIPanel[] tabs = component.getTabs();
        writer.startElement("table", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("summary", (Object)"", null);
        String clientId = component.getClientId(facesContext);
        writer.writeIdAttribute(clientId + '.' + virtualTab);
        writer.writeAttribute("style", (Object)oStyle.toString(), null);
        writer.startElement("tr", null);
        writer.writeAttribute("valign", (Object)"bottom", null);
        writer.startElement("td", null);
        writer.startElement("table", (UIComponent)component);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("summary", (Object)"", null);
        writer.writeAttribute("style", null, "style_header");
        writer.startElement("tr", null);
        writer.writeAttribute("valign", (Object)"bottom", null);
        UIPanel activeTab = null;
        for (int i = 0; i < tabs.length; ++i) {
            String innerClass;
            String outerClass;
            UIPanel tab = tabs[i];
            String onclick = TobagoConfig.getInstance((FacesContext)facesContext).isAjaxEnabled() && "reloadTab".equals(switchType) ? null : ("reloadPage".equals(switchType) || "reloadTab".equals(switchType) ? "tobago_requestTab('" + clientId + "'," + i + ",'" + ComponentUtil.findPage((UIComponent)component).getFormId(facesContext) + "')" : "tobago_selectTab('" + clientId + "'," + i + ',' + tabs.length + ')');
            LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)tab);
            if (virtualTab == i) {
                outerClass = "tobago-tab-selected-outer";
                innerClass = "tobago-tab-selected-inner";
                activeTab = tab;
            } else {
                outerClass = "tobago-tab-unselected-outer";
                innerClass = "tobago-tab-unselected-inner";
            }
            writer.startElement("td", (UIComponent)tab);
            writer.writeAttribute("title", null, "tip");
            writer.startElement("div", null);
            writer.writeClassAttribute(outerClass);
            writer.startElement("div", null);
            writer.writeClassAttribute(innerClass);
            writer.startElement("span", null);
            writer.writeClassAttribute("tobago-tab-link");
            String tabId = clientId + "." + virtualTab + "::" + i;
            writer.writeIdAttribute(tabId);
            if (onclick != null) {
                writer.writeAttribute("onclick", (Object)onclick, null);
            }
            if (label.getText() != null) {
                HtmlRendererUtil.writeLabelWithAccessKey((ResponseWriter)writer, (LabelWithAccessKey)label);
            } else {
                writer.writeText((Object)Integer.toString(i + 1), null);
            }
            writer.endElement("span");
            if (label.getAccessKey() != null) {
                if (LOG.isWarnEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey())) {
                    LOG.warn((Object)("dublicated accessKey : " + label.getAccessKey()));
                }
                HtmlRendererUtil.addClickAcceleratorKey((FacesContext)facesContext, (String)tabId, (char)label.getAccessKey().charValue());
            }
            writer.endElement("div");
            writer.endElement("div");
            writer.endElement("td");
        }
        writer.startElement("td", null);
        writer.writeAttribute("width", (Object)"100%", null);
        writer.startElement("div", null);
        writer.writeClassAttribute("tobago-tab-fulfill");
        writer.startElement("img", null);
        writer.writeAttribute("src", (Object)image1x1, null);
        writer.writeAttribute("alt", (Object)"", null);
        writer.endElement("img");
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("td");
        writer.endElement("tr");
        this.encodeContent(writer, facesContext, activeTab);
        writer.endElement("table");
    }

    protected void encodeContent(TobagoResponseWriter writer, FacesContext facesContext, UIPanel activeTab) throws IOException {
        String bodyStyle = (String)activeTab.getParent().getAttributes().get("style_body");
        writer.startElement("tr", null);
        writer.startElement("td", null);
        writer.writeClassAttribute("tobago-tab-content");
        writer.writeAttribute("style", (Object)bodyStyle, null);
        writer.writeText((Object)"", null);
        RenderUtil.encodeChildren((FacesContext)facesContext, (UIComponent)activeTab);
        writer.endElement("td");
        writer.endElement("tr");
    }

    public void encodeAjax(FacesContext context, UIComponent component) throws IOException {
        AjaxUtils.checkParamValidity((FacesContext)context, (UIComponent)component, UITabGroup.class);
        this.renderTabGroupView(context, (TobagoResponseWriter)context.getResponseWriter(), (UITabGroup)component, ((UITabGroup)component).getActiveIndex(), new StyleAttribute((String)component.getAttributes().get("style")), "reloadTab", ResourceManagerUtil.getImageWithPath((FacesContext)context, (String)"image/1x1.gif"));
        context.responseComplete();
    }

    public int getFixedHeight(FacesContext facesContext, UIComponent uiComponent) {
        int fixedHeight;
        UITabGroup component = (UITabGroup)uiComponent;
        int height = ComponentUtil.getIntAttribute((UIComponent)component, (String)"height", (int)-1);
        if (height != -1) {
            fixedHeight = height;
        } else {
            UIPanel[] tabs = component.getTabs();
            fixedHeight = 0;
            for (int i = 0; i < tabs.length; ++i) {
                UIPanel tab = tabs[i];
                RendererBase renderer = ComponentUtil.getRenderer((FacesContext)facesContext, (UIComponent)tab);
                fixedHeight = Math.max(fixedHeight, renderer.getFixedHeight(facesContext, (UIComponent)tab));
            }
            fixedHeight += this.getConfiguredValue(facesContext, (UIComponent)component, "headerHeight");
            fixedHeight += this.getConfiguredValue(facesContext, (UIComponent)component, "paddingHeight");
        }
        return fixedHeight;
    }

    private void layoutTabs(FacesContext facesContext, UITabGroup component, UIPanel[] tabs) {
        Object layoutWidth = component.getAttributes().get("layoutWidth");
        Object layoutHeight = component.getAttributes().get("layoutHeight");
        for (int i = 0; i < tabs.length; ++i) {
            UIPanel tab = tabs[i];
            if (layoutWidth != null) {
                HtmlRendererUtil.layoutSpace((FacesContext)facesContext, (UIComponent)tab, (boolean)true);
            }
            if (layoutHeight == null) continue;
            HtmlRendererUtil.layoutSpace((FacesContext)facesContext, (UIComponent)tab, (boolean)false);
        }
    }

    public class TabController
    extends MethodBinding {
        public static final String ID_PREFIX = "tab_";

        public Object invoke(FacesContext facesContext, Object[] objects) throws EvaluationException {
            if (objects[0] instanceof ActionEvent) {
                UICommand command = (UICommand)((ActionEvent)objects[0]).getSource();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Id = " + command.getId()));
                }
                if (command.getId() != null && command.getId().startsWith(ID_PREFIX)) {
                    try {
                        int newTab = Integer.parseInt(command.getId().substring(ID_PREFIX.length()));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        public Class getType(FacesContext facesContext) throws MethodNotFoundException {
            return String.class;
        }
    }
}

