/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.renderkit.HtmlUtils;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.InRendererBase;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TextAreaRenderer
extends InRendererBase {
    protected void renderMain(FacesContext facesContext, UIInput input, TobagoResponseWriter writer) throws IOException {
        String currentValue;
        Iterator messages = facesContext.getMessages(input.getClientId(facesContext));
        StringBuffer stringBuffer = new StringBuffer();
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            stringBuffer.append(message.getDetail());
        }
        String title = null;
        if (stringBuffer.length() > 0) {
            title = stringBuffer.toString();
        }
        title = HtmlRendererUtil.addTip((String)title, (String)((String)input.getAttributes().get("tip")));
        String clientId = input.getClientId(facesContext);
        String onchange = HtmlUtils.generateOnchange((UIInput)input, (FacesContext)facesContext);
        writer.startElement("textarea", (UIComponent)input);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute("rows", null, "rows");
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        writer.writeAttribute("readonly", ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"readonly"));
        writer.writeAttribute("disabled", ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"disabled"));
        writer.writeAttribute("style", null, "style");
        writer.writeComponentClass();
        if (onchange != null) {
            writer.writeAttribute("onchange", (Object)onchange, null);
        }
        if ((currentValue = ComponentUtil.currentValue((UIComponent)input)) != null) {
            if (currentValue.startsWith("\r\n")) {
                currentValue = "\r\n" + currentValue;
            } else if (currentValue.startsWith("\n")) {
                currentValue = "\n" + currentValue;
            } else if (currentValue.startsWith("\r")) {
                currentValue = "\r" + currentValue;
            }
            writer.writeText((Object)currentValue, null);
        }
        writer.endElement("textarea");
    }
}

