/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.InRendererBase;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TimeRenderer
extends InRendererBase {
    private static final Log LOG = LogFactory.getLog(TimeRenderer.class);

    protected void renderMain(FacesContext facesContext, UIInput input, TobagoResponseWriter writer) throws IOException {
        List scriptFiles = ComponentUtil.findPage((UIComponent)input).getScriptFiles();
        scriptFiles.add("script/dateConverter.js");
        scriptFiles.add("script/calendar.js");
        Iterator messages = facesContext.getMessages(input.getClientId(facesContext));
        StringBuffer stringBuffer = new StringBuffer();
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            stringBuffer.append(message.getDetail());
        }
        String title = null;
        if (stringBuffer.length() > 0) {
            title = stringBuffer.toString();
        }
        title = HtmlRendererUtil.addTip((String)title, (String)((String)input.getAttributes().get("tip")));
        String currentValue = this.getCurrentValue(facesContext, (UIComponent)input);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("currentValue = '" + currentValue + "'"));
        }
        String converterPattern = "HH:mm";
        if (input.getConverter() != null) {
            String pattern;
            Converter converter = input.getConverter();
            if (converter instanceof DateTimeConverter && (pattern = ((DateTimeConverter)converter).getPattern()) != null && pattern.indexOf(115) > -1) {
                converterPattern = converterPattern + ":ss";
            }
        } else if (ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"popupCalendarForceTime")) {
            converterPattern = converterPattern + ":ss";
        }
        boolean hasSeconds = converterPattern.indexOf(115) > -1;
        SimpleDateFormat dateFormat = new SimpleDateFormat(converterPattern);
        Object value = input.getValue();
        Date date = value instanceof Date ? (Date)value : (value instanceof Calendar ? ((Calendar)value).getTime() : new Date());
        String hour = new SimpleDateFormat("HH").format(date);
        String minute = new SimpleDateFormat("mm").format(date);
        String second = new SimpleDateFormat("ss").format(date);
        String id = input.getClientId(facesContext);
        String idPrefix = id + "::";
        writer.startElement("div", (UIComponent)input);
        writer.writeComponentClass();
        writer.startElement("div", (UIComponent)input);
        writer.writeAttribute("id", (Object)(idPrefix + "borderDiv"), null);
        writer.writeClassAttribute("tobago-time-borderDiv" + (hasSeconds ? " tobago-time-borderDiv-seconds" : ""));
        this.writeInput(writer, idPrefix + "hour", hour, true);
        this.writeInputSeparator(writer, ":");
        this.writeInput(writer, idPrefix + "minute", minute, false);
        if (hasSeconds) {
            this.writeInputSeparator(writer, ":");
            this.writeInput(writer, idPrefix + "second", second, false);
        }
        writer.endElement("div");
        String imageId = idPrefix + "inc";
        String imageSrc = "image/timeIncrement.gif";
        HtmlRendererUtil.addImageSources((FacesContext)facesContext, (ResponseWriter)writer, (String)imageSrc, (String)imageId);
        writer.startElement("img");
        writer.writeIdAttribute(imageId);
        writer.writeAttribute("onclick", "tbgIncTime(this)", false);
        writer.writeClassAttribute("tobago-time-inc-image" + (hasSeconds ? " tobago-time-image-seconds" : ""));
        writer.writeAttribute("src", ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)imageSrc), true);
        writer.writeAttribute("alt", "", false);
        if (!ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"disabled")) {
            writer.writeAttribute("onmouseover", (Object)("Tobago.imageMouseover('" + imageId + "')"), null);
            writer.writeAttribute("onmouseout", (Object)("Tobago.imageMouseout('" + imageId + "')"), null);
        }
        writer.endElement("img");
        imageId = idPrefix + "dec";
        imageSrc = "image/timeDecrement.gif";
        HtmlRendererUtil.addImageSources((FacesContext)facesContext, (ResponseWriter)writer, (String)imageSrc, (String)imageId);
        writer.startElement("img");
        writer.writeIdAttribute(imageId);
        writer.writeAttribute("onclick", "tbgDecTime(this)", false);
        writer.writeClassAttribute("tobago-time-dec-image" + (hasSeconds ? " tobago-time-image-seconds" : ""));
        writer.writeAttribute("src", ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)imageSrc), true);
        writer.writeAttribute("alt", "", false);
        if (!ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"disabled")) {
            writer.writeAttribute("onmouseover", (Object)("Tobago.imageMouseover('" + imageId + "')"), null);
            writer.writeAttribute("onmouseout", (Object)("Tobago.imageMouseout('" + imageId + "')"), null);
        }
        writer.endElement("img");
        writer.startElement("input", (UIComponent)input);
        writer.writeAttribute("type", "hidden", false);
        writer.writeIdAttribute(id + ":converterPattern");
        writer.writeAttribute("value", (Object)converterPattern, null);
        writer.endElement("input");
        writer.startElement("input", (UIComponent)input);
        writer.writeAttribute("type", "hidden", false);
        writer.writeIdAttribute(id);
        writer.writeNameAttribute(id);
        writer.writeAttribute("value", hour + ":" + minute + ":" + second, false);
        writer.endElement("input");
        String dateTextBoxId = (String)input.getAttributes().get("CalendarDateInputId");
        if (dateTextBoxId != null) {
            HtmlRendererUtil.startJavascript((ResponseWriter)writer);
            writer.writeText((Object)("tbgInitTimeParse('" + id + "', '" + dateTextBoxId + "');"), null);
            HtmlRendererUtil.endJavascript((ResponseWriter)writer);
        }
        writer.endElement("div");
    }

    private void writeInputSeparator(TobagoResponseWriter writer, String sep) throws IOException {
        writer.startElement("span");
        writer.writeClassAttribute("tobago-time-sep");
        writer.writeText((Object)sep, null);
        writer.endElement("span");
    }

    private void writeInput(TobagoResponseWriter writer, String id, String hour, boolean hourMode) throws IOException {
        writer.startElement("input");
        writer.writeAttribute("type", "text", false);
        writer.writeIdAttribute(id);
        writer.writeClassAttribute("tobago-time-input");
        writer.writeAttribute("onfocus", "tbgTimerInputFocus(this, " + hourMode + ")", false);
        writer.writeAttribute("onblur", "tbgTimerInputBlur(this)", false);
        writer.writeAttribute("onkeyup", "tbgTimerKeyUp(this, event)", false);
        writer.writeAttribute("value", hour, true);
        writer.endElement("input");
    }
}

