/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIMenuSelectOne;
import org.apache.myfaces.tobago.component.UISelectBooleanCommand;
import org.apache.myfaces.tobago.component.UISelectOneCommand;
import org.apache.myfaces.tobago.context.ResourceManager;
import org.apache.myfaces.tobago.context.ResourceManagerFactory;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.CommandRendererBase;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag.ButtonRenderer;
import org.apache.myfaces.tobago.util.AccessKeyMap;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class ToolBarRenderer
extends RendererBase {
    private static final Log LOG = LogFactory.getLog(ToolBarRenderer.class);

    public void encodeEndTobago(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIPanel toolbar = (UIPanel)uiComponent;
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        boolean suppressContainer = ComponentUtil.getBooleanAttribute((UIComponent)toolbar, (String)"suppressToolbarContainer");
        if (!suppressContainer) {
            this.setToolBarHeight(facesContext, uiComponent);
            writer.startElement("div", (UIComponent)toolbar);
            writer.writeIdAttribute(toolbar.getClientId(facesContext));
            writer.writeComponentClass();
            writer.writeAttribute("style", null, "style");
            writer.startElement("div", (UIComponent)toolbar);
            writer.writeClassAttribute("tobago-toolbar-div-inner");
        }
        boolean boxFacet = this.isBoxFacet((UIComponent)toolbar);
        List children = toolbar.getChildren();
        int index = 0;
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            UIComponent component = (UIComponent)iter.next();
            if (component instanceof UICommand) {
                boolean addExtraClass = boxFacet ? !iter.hasNext() : index++ == 0;
                this.renderToolbarCommand(facesContext, (UICommand)component, writer, boxFacet, addExtraClass);
                continue;
            }
            LOG.error((Object)("Illegal UIComponent class in toolbar :" + component.getClass().getName()));
        }
        if (!suppressContainer) {
            writer.endElement("div");
            writer.endElement("div");
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    private boolean isBoxFacet(UIComponent component) {
        return "Box".equals(component.getParent().getRendererType()) && component.getParent().getFacet("toolBar") == component;
    }

    private void renderToolbarCommand(FacesContext facesContext, UICommand command, TobagoResponseWriter writer, boolean boxFacet, boolean addExtraHoverClass) throws IOException {
        if (command instanceof UISelectBooleanCommand) {
            this.renderSelectBoolean(facesContext, command, writer, boxFacet, addExtraHoverClass);
        } else if (command instanceof UISelectOneCommand) {
            this.renderSelectOne(facesContext, command, writer, boxFacet, addExtraHoverClass);
        } else {
            String onClick = this.createOnClick(facesContext, (UIComponent)command);
            this.renderToolbarButton(facesContext, command, writer, boxFacet, addExtraHoverClass, false, onClick);
        }
    }

    private void renderSelectOne(FacesContext facesContext, UICommand command, TobagoResponseWriter writer, boolean boxFacet, boolean addExtraHoverClass) throws IOException {
        String onClick = this.createOnClick(facesContext, (UIComponent)command);
        onClick = CommandRendererBase.appendConfirmationScript((String)onClick, (UIComponent)command, (FacesContext)facesContext);
        List items = ComponentUtil.getSelectItems((UIComponent)command);
        UIMenuSelectOne radio = (UIMenuSelectOne)command.getFacet("radio");
        if (radio == null) {
            radio = ComponentUtil.createUIMenuSelectOneFacet((FacesContext)facesContext, (UICommand)command);
            radio.setId(facesContext.getViewRoot().createUniqueId());
        }
        if (radio != null) {
            Object value = radio.getValue();
            boolean markFirst = !ComponentUtil.hasSelectedValue((List)items, (Object)value);
            String radioId = radio.getClientId(facesContext);
            String onClickPrefix = "menuSetRadioValue('" + radioId + "', '";
            String onClickPostfix = onClick != null ? "') ; " + onClick : "";
            for (SelectItem item : items) {
                boolean checked;
                String labelText = item.getLabel();
                if (labelText != null) {
                    command.getAttributes().put("label", labelText);
                } else {
                    LOG.warn((Object)("Menu item has label=null. UICommand.getClientId()=" + command.getClientId(facesContext)));
                }
                String image = null;
                if (item instanceof org.apache.myfaces.tobago.model.SelectItem) {
                    image = ((org.apache.myfaces.tobago.model.SelectItem)item).getImage();
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("select item is not " + org.apache.myfaces.tobago.model.SelectItem.class.getName()));
                }
                if (image == null) {
                    image = "image/1x1.gif";
                }
                command.getAttributes().put("image", image);
                if (item.getDescription() != null) {
                    command.getAttributes().put("tip", item.getDescription());
                }
                String formattedValue = ToolBarRenderer.getFormattedValue((FacesContext)facesContext, (UIComponent)command, (Object)item.getValue());
                onClick = onClickPrefix + formattedValue + onClickPostfix;
                if (item.getValue().equals(value) || markFirst) {
                    checked = true;
                    markFirst = false;
                    HtmlRendererUtil.startJavascript((ResponseWriter)writer);
                    writer.write("    " + onClickPrefix + formattedValue + "');");
                    HtmlRendererUtil.endJavascript((ResponseWriter)writer);
                } else {
                    checked = false;
                }
                this.renderToolbarButton(facesContext, command, writer, boxFacet, addExtraHoverClass, checked, onClick);
            }
        }
    }

    private void renderSelectBoolean(FacesContext facesContext, UICommand command, TobagoResponseWriter writer, boolean boxFacet, boolean addExtraHoverClass) throws IOException {
        UIComponent checkbox = command.getFacet("checkbox");
        if (checkbox == null) {
            checkbox = ComponentUtil.createUISelectBooleanFacet((FacesContext)facesContext, (UICommand)command);
            checkbox.setId(facesContext.getViewRoot().createUniqueId());
        }
        boolean checked = ComponentUtil.getBooleanAttribute((UIComponent)command, (String)"value");
        String onClick = this.createOnClick(facesContext, (UIComponent)command);
        String clientId = checkbox.getClientId(facesContext);
        onClick = RenderUtil.addMenuCheckToggle((String)clientId, (String)onClick);
        if (checked) {
            HtmlRendererUtil.startJavascript((ResponseWriter)writer);
            writer.write("    menuCheckToggle('" + clientId + "');\n");
            HtmlRendererUtil.endJavascript((ResponseWriter)writer);
        }
        this.renderToolbarButton(facesContext, command, writer, boxFacet, addExtraHoverClass, checked, onClick);
    }

    private void renderToolbarButton(FacesContext facesContext, UICommand command, TobagoResponseWriter writer, boolean boxFacet, boolean addExtraHoverClass, boolean selected, String onClick) throws IOException {
        boolean popupOn2;
        boolean anchorOnLabel;
        if (!command.isRendered()) {
            return;
        }
        String clientId = command.getClientId(facesContext);
        boolean disabled = ComponentUtil.getBooleanAttribute((UIComponent)command, (String)"disabled");
        LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)command);
        UIComponent popupMenu = command.getFacet("menupopup");
        Map parentAttributes = command.getParent().getAttributes();
        String labelPosition = (String)parentAttributes.get("labelPosition");
        String iconSize = (String)parentAttributes.get("iconSize");
        onClick = CommandRendererBase.appendConfirmationScript((String)onClick, (UIComponent)command, (FacesContext)facesContext);
        String divClasses = "tobago-toolbar-button tobago-toolbar-button-" + (boxFacet ? "box-facet-" : "") + (selected ? "selected-" : "") + (disabled ? "disabled" : "enabled") + (boxFacet ? " tobago-toolbar-button-box-facet" : "");
        String tableClasses = "tobago-toolbar-button-table" + (boxFacet ? " tobago-toolbar-button-table-box-facet" : "") + " tobago-toolbar-button-table-" + (boxFacet ? "box-facet-" : "") + (selected ? "selected-" : "") + (disabled ? "disabled" : "enabled");
        String iconName = (String)command.getAttributes().get("image");
        String image = this.getImage(facesContext, iconName, iconSize, disabled, selected);
        String graphicId = clientId + "::" + "icon";
        String extraHoverClass = "";
        if (addExtraHoverClass) {
            extraHoverClass = !boxFacet ? " tobago-toolBar-button-hover-first" : " tobago-box-toolBar-button-hover-last";
        }
        String args = "this, 'tobago-toolBar-button-hover" + (boxFacet ? " tobago-toolBar-button-box-facet-hover" : "") + extraHoverClass + "', '" + graphicId + "'";
        String mouseOverScript = "Tobago.toolbarMousesover(" + args + ");";
        String mouseOutScript = "Tobago.toolbarMousesout(" + args + ");";
        writer.startElement("div", null);
        writer.writeClassAttribute(divClasses);
        if (!disabled) {
            writer.writeAttribute("onmouseover", (Object)mouseOverScript, null);
            writer.writeAttribute("onmouseout", (Object)mouseOutScript, null);
            writer.writeAttribute("onclick", (Object)onClick, null);
        }
        writer.startElement("table", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("summary", (Object)"", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeClassAttribute(tableClasses);
        writer.startElement("tr", null);
        boolean bl = anchorOnLabel = label.getText() != null && !"off".equals(labelPosition);
        if (!"off".equals(iconSize)) {
            boolean render1pxImage;
            HtmlRendererUtil.addImageSources((FacesContext)facesContext, (ResponseWriter)writer, (String)(iconName != null ? iconName : "image/1x1.gif"), (String)graphicId);
            writer.startElement("td", (UIComponent)command);
            writer.writeAttribute("align", (Object)"center", null);
            writer.writeAttribute("title", null, "tip");
            boolean bl2 = render1pxImage = iconName == null && !"bottom".equals(labelPosition) && label.getText() != null;
            if ((!"off".equals(labelPosition) && label.getText() != null || popupMenu != null) && !render1pxImage) {
                writer.writeAttribute("style", (Object)"padding-right: 3px;", null);
            }
            String className = "tobago-image-default tobago-toolBar-button-image tobago-toolBar-button-image-" + iconSize;
            if (!anchorOnLabel) {
                this.renderAnchorBegin(facesContext, writer, command, label, disabled);
            }
            writer.startElement("img", (UIComponent)command);
            writer.writeIdAttribute(graphicId);
            writer.writeAttribute("src", (Object)image, null);
            writer.writeAttribute("alt", (Object)"", null);
            writer.writeAttribute("title", null, "tip");
            writer.writeAttribute("border", (Object)"0", null);
            writer.writeClassAttribute(className);
            if (render1pxImage) {
                writer.writeAttribute("style", (Object)"width: 1px;", null);
            }
            writer.endElement("img");
            if (!anchorOnLabel) {
                writer.endElement("a");
            }
            writer.endElement("td");
        }
        boolean bl3 = popupOn2 = "bottom".equals(labelPosition) && !"off".equals(iconSize);
        if (popupOn2) {
            if (popupMenu != null) {
                this.renderPopupTd(facesContext, writer, (UIComponent)command, popupMenu, true);
            }
            writer.endElement("tr");
            writer.startElement("tr", null);
        }
        if (!"off".equals(labelPosition)) {
            writer.startElement("td", null);
            writer.writeClassAttribute("tobago-toolbar-label-td");
            writer.writeAttribute("align", (Object)"center", null);
            if (popupMenu != null) {
                writer.writeAttribute("style", (Object)"padding-right: 3px;", null);
            }
            if (label.getText() != null) {
                this.renderAnchorBegin(facesContext, writer, command, label, disabled);
                HtmlRendererUtil.writeLabelWithAccessKey((ResponseWriter)writer, (LabelWithAccessKey)label);
                writer.endElement("a");
            }
            writer.endElement("td");
        }
        if (!popupOn2 && popupMenu != null) {
            this.renderPopupTd(facesContext, writer, (UIComponent)command, popupMenu, false);
        }
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
    }

    private String createOnClick(FacesContext facesContext, UIComponent component) {
        if (component.getFacet("menupopup") != null && ((UICommand)component).getAction() == null && ((UICommand)component).getActionListener() == null && ((UICommand)component).getActionListeners().length == 0) {
            String searchId = component.getClientId(facesContext) + "::popup";
            return "tobagoButtonOpenMenu(this, '" + searchId + "')";
        }
        return ButtonRenderer.createOnClick(facesContext, component);
    }

    private String getImage(FacesContext facesContext, String name, String iconSize, boolean disabled, boolean selected) {
        if (name == null) {
            return ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/1x1.gif");
        }
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            pos = name.length();
        }
        String key = name.substring(0, pos);
        String ext = name.substring(pos);
        String size = "";
        if ("small".equals(iconSize)) {
            size = "16";
        } else if ("big".equals(iconSize)) {
            size = "32";
        }
        String image = null;
        ResourceManager resourceManager = ResourceManagerFactory.getResourceManager((FacesContext)facesContext);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (disabled && selected && (image = resourceManager.getImage(viewRoot, key + "SelectedDisabled" + size + ext, true)) == null) {
            image = resourceManager.getImage(viewRoot, key + "SelectedDisabled" + ext, true);
        }
        if (image == null && disabled && (image = resourceManager.getImage(viewRoot, key + "Disabled" + size + ext, true)) == null) {
            image = resourceManager.getImage(viewRoot, key + "Disabled" + ext, true);
        }
        if (image == null && selected && (image = resourceManager.getImage(viewRoot, key + "Selected" + size + ext, true)) == null) {
            image = resourceManager.getImage(viewRoot, key + "Selected" + ext, true);
        }
        if (image == null && (image = resourceManager.getImage(viewRoot, key + size + ext, true)) == null) {
            image = resourceManager.getImage(viewRoot, key + ext, true);
        }
        String contextPath = facesContext.getExternalContext().getRequestContextPath();
        return contextPath + image;
    }

    private void renderAnchorBegin(FacesContext facesContext, TobagoResponseWriter writer, UICommand command, LabelWithAccessKey label, boolean disabled) throws IOException {
        writer.startElement("a", (UIComponent)command);
        writer.writeClassAttribute("tobago-toolBar-button-link" + (disabled ? "tobago-toolBar-button-link-disabled" : ""));
        writer.writeAttribute("title", null, "tip");
        if (!disabled) {
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("onfocus", (Object)"Tobago.toolbarFocus(this, event)", null);
            if (label.getAccessKey() != null) {
                if (LOG.isInfoEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey())) {
                    LOG.info((Object)("dublicated accessKey : " + label.getAccessKey()));
                }
                String id = command.getClientId(facesContext) + "::" + "link";
                writer.writeIdAttribute(id);
                HtmlRendererUtil.addClickAcceleratorKey((FacesContext)facesContext, (String)id, (char)label.getAccessKey().charValue());
            }
        }
    }

    private void renderPopupTd(FacesContext facesContext, TobagoResponseWriter writer, UIComponent command, UIComponent popupMenu, boolean labelBottom) throws IOException {
        writer.startElement("td", null);
        if (labelBottom) {
            writer.writeAttribute("rowspan", (Object)"2", null);
        }
        if (popupMenu != null) {
            String backgroundImage = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/1x1.gif");
            writer.startElement("div", null);
            writer.writeIdAttribute(command.getClientId(facesContext) + "::" + "popup");
            writer.writeClassAttribute("tobago-toolBar-button-menu");
            writer.startElement("img", null);
            writer.writeAttribute("src", (Object)backgroundImage, null);
            writer.writeClassAttribute("tobago-toolBar-button-menu-background-image");
            writer.endElement("img");
            writer.endElement("div");
            popupMenu.getAttributes().put("menuPopup", Boolean.TRUE);
            popupMenu.getAttributes().put("menuPopupType", "ToolBarButton");
            popupMenu.setRendererType("MenuBar");
            popupMenu.getAttributes().remove("label");
            popupMenu.getAttributes().put("image", "image/toolbarButtonMenu.gif");
            RenderUtil.encode((FacesContext)facesContext, (UIComponent)popupMenu);
        }
        writer.endElement("td");
    }

    private void setToolBarHeight(FacesContext facesContext, UIComponent component) {
        int height = this.getFixedHeight(facesContext, component);
        Map attributes = component.getAttributes();
        String style = HtmlRendererUtil.replaceStyleAttribute((String)((String)attributes.get("style")), (String)"height", (String)(Integer.toString(height) + "px"));
        attributes.put("style", style);
    }

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        Map attributes = component.getAttributes();
        String labelPosition = (String)attributes.get("labelPosition");
        String iconSize = (String)attributes.get("iconSize");
        String key = iconSize + "_" + labelPosition + "_Height";
        return this.getConfiguredValue(facesContext, component, key);
    }
}

