/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.UITreeListbox;
import org.apache.myfaces.tobago.component.UITreeListboxBox;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TreeListboxBoxRenderer
extends RendererBase {
    private static final Log LOG = LogFactory.getLog(TreeListboxBoxRenderer.class);

    public void encodeEndTobago(FacesContext facesContext, UIComponent component) throws IOException {
        int level = ((UITreeListboxBox)component).getLevel();
        UITreeListbox tree = (UITreeListbox)component.getParent();
        List selectionPath = tree.getSelectionPath();
        String className = "tobago-treeListbox-default";
        if (selectionPath.size() > 0 && selectionPath.size() - 1 <= level && ((UITreeNode)selectionPath.get(selectionPath.size() - 1)).getTreeNode().isLeaf()) {
            className = className + " tobago-treeListbox-unused";
        }
        String treeId = tree.getClientId(facesContext);
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        boolean siblingMode = "siblingLeafOnly".equals(tree.getAttributes().get("selectable"));
        String listboxId = treeId + "::" + "cont_" + level;
        String onChange = "tbgTreeListboxChange(this, '" + treeId + "')";
        String onClick = "tbgTreeListboxClick(this, '" + treeId + "')";
        writer.startElement("select", component);
        writer.writeIdAttribute(listboxId);
        writer.writeClassAttribute(className);
        writer.writeAttribute("style", null, "style");
        writer.writeAttribute("size", (Object)"2", null);
        if (siblingMode) {
            writer.writeAttribute("onchange", (Object)onChange, null);
        } else {
            writer.writeAttribute("onclick", (Object)onClick, null);
        }
        writer.writeAttribute("multiple", siblingMode);
        List nodes = ((UITreeListboxBox)component).getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            UITreeNode treeNode = (UITreeNode)nodes.get(i);
            DefaultMutableTreeNode node = treeNode.getTreeNode();
            writer.startElement("option", null);
            writer.writeAttribute("value", (Object)Integer.toString(i), null);
            if (treeNode.equals(tree.getSelectedNode(level)) || tree.isSelectedNode(node)) {
                writer.writeAttribute("selected", true);
            }
            writer.writeText(treeNode.getAttributes().get("name"), null);
            if (node.getChildCount() > 0) {
                writer.writeText((Object)" \u2192", null);
            }
            writer.endElement("option");
        }
        writer.endElement("select");
    }
}

