/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UITreeListbox;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag.TreeRenderer;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TreeListboxRenderer
extends TreeRenderer {
    private static final Log LOG = LogFactory.getLog(TreeListboxRenderer.class);

    public void encodeBeginTobago(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeListbox tree = (UITreeListbox)component;
        tree.createSelectionPath();
        String clientId = tree.getClientId(facesContext);
        UITreeNode root = tree.getRoot();
        UIPage page = ComponentUtil.findPage((UIComponent)tree);
        if (LOG.isDebugEnabled()) {
            page.getOnloadScripts().add("tbgTreeStates('" + clientId + "')");
        }
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        writer.startElement("div", (UIComponent)tree);
        writer.writeComponentClass();
        writer.writeAttribute("style", null, "style");
        String value = ";";
        List expandPath = tree.getExpandPath();
        for (UITreeNode node : expandPath) {
            value = value + this.nodeStateId(facesContext, node) + ";";
        }
        writer.startElement("input", (UIComponent)tree);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute("value", (Object)value, null);
        writer.endElement("input");
        Set selection = tree.getState().getSelection();
        value = ";";
        for (DefaultMutableTreeNode node : selection) {
            value = value + this.nodeStateId(facesContext, tree.findUITreeNode(root, (TreeNode)node)) + ";";
        }
        writer.startElement("input", (UIComponent)tree);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeNameAttribute(clientId + "-selectState");
        writer.writeIdAttribute(clientId + "-selectState");
        writer.writeAttribute("value", (Object)value, null);
        writer.endElement("input");
        String script = this.createJavascript(facesContext, clientId, root);
        String[] scripts = new String[]{"script/tree.js"};
        ComponentUtil.findPage((UIComponent)tree).getScriptFiles().add(scripts[0]);
        if (!TobagoConfig.getInstance((FacesContext)facesContext).isAjaxEnabled()) {
            HtmlRendererUtil.startJavascript((ResponseWriter)writer);
            writer.writeText((Object)script, null);
            HtmlRendererUtil.endJavascript((ResponseWriter)writer);
        } else {
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])scripts, (String[])new String[]{script.replaceAll("\n", " ")});
        }
    }

    private String createJavascript(FacesContext facesContext, String clientId, UITreeNode root) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("{\n");
        sb.append("  var treeResourcesHelp = new Object();\n");
        sb.append("  treeResourcesHelp.getImage = function (name) {\n");
        sb.append("    return \"");
        sb.append(ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/blank.gif"));
        sb.append("\";\n");
        sb.append("  };;\n");
        sb.append(this.getNodesAsJavascript(facesContext, root));
        sb.append("  var hidden =   document.getElementById('");
        sb.append(clientId);
        sb.append("'); \n");
        sb.append("  hidden.rootNode = ");
        String rootNode = TreeListboxRenderer.createJavascriptVariable(root.getClientId(facesContext));
        sb.append(rootNode);
        sb.append(";\n");
        sb.append("}\n");
        return sb.toString();
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("div");
    }
}

