/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIForm;
import org.apache.myfaces.tobago.component.UITree;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.model.TreeState;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag.TreeRenderer;

public class TreeNodeRenderer
extends RendererBase {
    private static final Log LOG = LogFactory.getLog(TreeNodeRenderer.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        String marked;
        String selected;
        String searchString;
        if (ComponentUtil.isOutputOnly((UIComponent)component)) {
            return;
        }
        UITreeNode node = (UITreeNode)component;
        UITree tree = node.findTreeRoot();
        TreeState state = tree.getState();
        String treeId = tree.getClientId(facesContext);
        String nodeId = node.getId();
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String expandState = (String)requestParameterMap.get(treeId);
        if (expandState.indexOf(searchString = ";" + nodeId + ";") > -1) {
            state.addExpandState((DefaultMutableTreeNode)node.getValue());
        }
        if (TreeRenderer.isSelectable(tree) && (selected = (String)requestParameterMap.get(treeId + "-selectState")).indexOf(searchString = ";" + nodeId + ";") > -1) {
            state.addSelection((DefaultMutableTreeNode)node.getValue());
        }
        if ((marked = (String)requestParameterMap.get(treeId + "-marker")) != null && marked.equals(searchString = treeId + ':' + nodeId)) {
            state.setMarker((DefaultMutableTreeNode)node.getValue());
        }
        String actionId = ComponentUtil.findPage((UIComponent)component).getActionId();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("actionId = '" + actionId + "'"));
            LOG.debug((Object)("nodeId = '" + treeId + ':' + nodeId + "'"));
        }
        if (actionId != null && actionId.equals(treeId + ':' + nodeId)) {
            UIForm form;
            UICommand treeNodeCommand = (UICommand)tree.getFacet("treeNodeCommand");
            if (treeNodeCommand != null) {
                UIParameter parameter = TreeNodeRenderer.ensureTreeNodeParameter(treeNodeCommand);
                parameter.setValue((Object)node.getId());
                treeNodeCommand.queueEvent((FacesEvent)new ActionEvent((UIComponent)treeNodeCommand));
            }
            if ((form = ComponentUtil.findForm((UIComponent)component)) != null) {
                form.setSubmitted(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("setting Form Active: " + form.getClientId(facesContext)));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("actionId: " + actionId));
                LOG.debug((Object)("nodeId: " + nodeId));
            }
        }
        node.setValid(true);
    }

    private static UIParameter ensureTreeNodeParameter(UICommand command) {
        UIParameter treeNodeParameter = null;
        for (UIComponent component : command.getChildren()) {
            UIParameter parameter;
            if (!(component instanceof UIParameter) || !(parameter = (UIParameter)component).getName().equals("treeNodeId")) continue;
            treeNodeParameter = parameter;
        }
        if (treeNodeParameter == null) {
            treeNodeParameter = new UIParameter();
            treeNodeParameter.setName("treeNodeId");
        }
        return treeNodeParameter;
    }

    public void encodeBeginTobago(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeNode treeNode = (UITreeNode)component;
        String clientId = treeNode.getClientId(facesContext);
        UIComponent parent = treeNode.getParent();
        String parentClientId = null;
        if (parent != null && parent instanceof UITreeNode) {
            parentClientId = treeNode.getParent().getClientId(facesContext);
        }
        UITree root = treeNode.findTreeRoot();
        String rootId = root.getClientId(facesContext);
        String jsClientId = TreeRenderer.createJavascriptVariable(clientId);
        String jsParentClientId = TreeRenderer.createJavascriptVariable(parentClientId);
        TreeState treeState = root.getState();
        if (treeState == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No treeState found. clientId=" + clientId));
            }
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeNode.getValue();
            ResponseWriter writer = facesContext.getResponseWriter();
            String debuging = null;
            writer.writeText((Object)"var ", null);
            writer.writeText((Object)jsClientId, null);
            writer.writeText((Object)" = new ", null);
            if (component.getChildCount() == 0) {
                writer.writeText((Object)"TreeNode", null);
            } else {
                writer.writeText((Object)"TreeFolder", null);
            }
            writer.writeText((Object)"('", null);
            Object name = treeNode.getAttributes().get("name");
            if (LOG.isDebugEnabled()) {
                debuging = debuging + name + " : ";
            }
            if (name != null) {
                writer.writeText((Object)StringEscapeUtils.escapeJavaScript((String)name.toString()), null);
            } else {
                LOG.warn((Object)"name = null");
            }
            writer.writeText((Object)"','", null);
            writer.writeText((Object)clientId, null);
            writer.writeText((Object)"',", null);
            writer.writeText((Object)Boolean.toString(!root.isShowIcons()), null);
            writer.writeText((Object)",", null);
            writer.writeText((Object)Boolean.toString(!root.isShowJunctions()), null);
            writer.writeText((Object)",", null);
            writer.writeText((Object)Boolean.toString(!root.isShowRootJunction()), null);
            writer.writeText((Object)",", null);
            writer.writeText((Object)Boolean.toString(!root.isShowRoot()), null);
            writer.writeText((Object)",'", null);
            writer.writeText((Object)rootId, null);
            writer.writeText((Object)"',", null);
            String selectable = ComponentUtil.getStringAttribute((UIComponent)root, (String)"selectable");
            if (!(selectable == null || selectable.equals("multi") || selectable.equals("multiLeafOnly") || selectable.equals("single") || selectable.equals("singleLeafOnly") || selectable.equals("sibling") || selectable.equals("siblingLeafOnly"))) {
                selectable = null;
            }
            if (selectable != null) {
                writer.writeText((Object)"'", null);
                writer.writeText((Object)selectable, null);
                writer.writeText((Object)"'", null);
            } else {
                writer.writeText((Object)"false", null);
            }
            writer.writeText((Object)",", null);
            writer.writeText((Object)Boolean.toString(ComponentUtil.getBooleanAttribute((UIComponent)root, (String)"mutable")), null);
            writer.writeText((Object)",'", null);
            writer.writeText((Object)ComponentUtil.findPage((UIComponent)component).getFormId(facesContext), null);
            writer.writeText((Object)"',", null);
            if (component.getChildCount() == 0 || selectable != null && !selectable.endsWith("LeafOnly")) {
                boolean selected = treeState.isSelected(node);
                writer.writeText((Object)Boolean.toString(selected), null);
                if (LOG.isDebugEnabled()) {
                    debuging = debuging + (selected ? "S" : "-");
                }
            } else {
                writer.writeText((Object)"false", null);
                if (LOG.isDebugEnabled()) {
                    debuging = debuging + "-";
                }
                if (treeState.isSelected(node)) {
                    LOG.warn((Object)"Ignore selected FolderNode in LeafOnly selection tree!");
                }
            }
            writer.writeText((Object)",", null);
            writer.writeText((Object)Boolean.toString(treeState.isMarked(node)), null);
            if (component.getChildCount() > 0) {
                writer.writeText((Object)",", null);
                boolean expanded = treeState.isExpanded(node);
                writer.writeText((Object)Boolean.toString(expanded), null);
                if (LOG.isDebugEnabled()) {
                    debuging = debuging + (expanded ? "E" : "-");
                }
            }
            writer.writeText((Object)",", null);
            writer.writeText((Object)Boolean.toString(root.isRequired()), null);
            writer.writeText((Object)",treeResourcesHelp);\n", null);
            if (jsParentClientId != null) {
                writer.writeText((Object)jsParentClientId, null);
                writer.writeText((Object)".add(", null);
                writer.writeText((Object)jsClientId, null);
                writer.writeText((Object)");\n", null);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)debuging);
            }
        }
    }
}

