/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UITree;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.model.TreeState;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TreeRenderer
extends RendererBase {
    private static final Log LOG = LogFactory.getLog(TreeRenderer.class);
    private static final String[] TREE_IMAGES = new String[]{"openfoldericon.gif", "foldericon.gif", "unchecked.gif", "checked.gif", "new.gif", "T.gif", "L.gif", "I.gif", "Lminus.gif", "Tminus.gif", "Rminus.gif", "Lplus.gif", "Tplus.gif", "Rplus.gif"};

    public void decode(FacesContext facesContext, UIComponent component) {
        if (ComponentUtil.isOutputOnly((UIComponent)component)) {
            return;
        }
        UITree tree = (UITree)component;
        TreeState state = tree.getState();
        if (state != null) {
            if ("Tree".equals(tree.getRendererType())) {
                state.clearExpandState();
            }
            if (TreeRenderer.isSelectable(tree)) {
                state.clearSelection();
            }
            if (ComponentUtil.getBooleanAttribute((UIComponent)tree, (String)"mutable")) {
                state.setMarker(null);
            }
        }
        tree.setValid(true);
    }

    public static boolean isSelectable(UITree tree) {
        return tree.isSelectableTree();
    }

    public static String createJavascriptVariable(String clientId) {
        return clientId == null ? null : clientId.replace(':', '_');
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent component) throws IOException {
        UITree tree = (UITree)component;
        String clientId = tree.getClientId(facesContext);
        UITreeNode root = tree.getRoot();
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        writer.startElement("div", (UIComponent)tree);
        writer.writeComponentClass();
        writer.writeAttribute("style", null, "style");
        writer.startElement("input", (UIComponent)tree);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute("value", (Object)";", null);
        writer.endElement("input");
        writer.startElement("input", (UIComponent)tree);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeNameAttribute(clientId + "-marker");
        writer.writeIdAttribute(clientId + "-marker");
        writer.writeAttribute("value", (Object)"", null);
        writer.endElement("input");
        if (TreeRenderer.isSelectable(tree)) {
            writer.startElement("input", (UIComponent)tree);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeNameAttribute(clientId + "-selectState");
            writer.writeIdAttribute(clientId + "-selectState");
            writer.writeAttribute("value", (Object)";", null);
            writer.endElement("input");
        }
        if (ComponentUtil.getBooleanAttribute((UIComponent)tree, (String)"mutable")) {
            UIComponent toolbar = tree.getFacet("mutableToolbar");
            if (toolbar == null) {
                toolbar = tree.getFacet("defaultToolbar");
            }
            RenderUtil.encode((FacesContext)facesContext, (UIComponent)toolbar);
        }
        writer.startElement("table", (UIComponent)tree);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("summary", (Object)"", null);
        writer.writeComponentClass();
        writer.startElement("tr", null);
        writer.startElement("td", null);
        writer.writeIdAttribute(clientId + "-cont");
        writer.writeComment((Object)"placeholder for treecontent");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        String script = this.createJavascript(facesContext, clientId, root);
        String[] scripts = new String[]{"script/tree.js"};
        ComponentUtil.findPage((UIComponent)tree).getScriptFiles().add(scripts[0]);
        if (!TobagoConfig.getInstance((FacesContext)facesContext).isAjaxEnabled()) {
            HtmlRendererUtil.startJavascript((ResponseWriter)writer);
            writer.writeText((Object)script, null);
            HtmlRendererUtil.endJavascript((ResponseWriter)writer);
        } else {
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])scripts, (String[])new String[]{script.replaceAll("\n", " ")});
        }
        writer.endElement("div");
    }

    private String createJavascript(FacesContext facesContext, String clientId, UITreeNode root) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("var treeResourcesHelp = new Object();\n");
        for (int i = 0; i < TREE_IMAGES.length; ++i) {
            sb.append("treeResourcesHelp.");
            sb.append(TREE_IMAGES[i].replace('.', '_'));
            sb.append(" = \"");
            sb.append(ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)("image/" + TREE_IMAGES[i])));
            sb.append("\";\n");
        }
        sb.append("treeResourcesHelp.getImage = function (name) {\n");
        sb.append("  var result = this[name.replace('.', '_')];\n");
        sb.append("  if (result) {\n");
        sb.append("    return result;\n");
        sb.append("  } else {\n");
        sb.append("    return \"");
        sb.append(ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/blank.gif"));
        sb.append("\";\n");
        sb.append("  }\n");
        sb.append("};\n");
        sb.append(this.getNodesAsJavascript(facesContext, root));
        sb.append("  var treeDiv = document.getElementById('");
        sb.append(clientId);
        sb.append("-cont');\n");
        sb.append("treeDiv.innerHTML = ");
        String rootNode = TreeRenderer.createJavascriptVariable(root.getClientId(facesContext));
        sb.append(rootNode);
        sb.append(".toString(0, true);\n");
        sb.append(rootNode);
        sb.append(".initSelection();\n");
        sb.append("}");
        return sb.toString();
    }

    protected String getNodesAsJavascript(FacesContext facesContext, UITreeNode root) throws IOException {
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        StringWriter stringWriter = new StringWriter();
        facesContext.setResponseWriter(writer.cloneWithWriter((Writer)stringWriter));
        RenderUtil.encode((FacesContext)facesContext, (UIComponent)root);
        facesContext.setResponseWriter((ResponseWriter)writer);
        return stringWriter.toString();
    }

    protected String nodeStateId(FacesContext facesContext, UITreeNode node) {
        String clientId = node.getClientId(facesContext);
        int last = clientId.lastIndexOf(58) + 1;
        return clientId.substring(last);
    }
}

