/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.fo.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.renderkit.fo.standard.standard.tag.Layout;

public class FoUtils {
    public static final int DEFAULT_HEIGHT = 200;

    public static void endBlockContainer(ResponseWriter writer) throws IOException {
        writer.endElement("fo:block-container");
    }

    public static void startBlockContainer(ResponseWriter writer, UIComponent component) throws IOException {
        writer.startElement("fo:block-container", component);
    }

    public static void writeBorder(ResponseWriter writer, int borderWidth) throws IOException {
        writer.writeAttribute("border-color", (Object)"blue", null);
        writer.writeAttribute("border-style", (Object)"solid", null);
        writer.writeAttribute("border-width", (Object)Layout.getMM(borderWidth), null);
    }

    public static void layoutBlockContainer(ResponseWriter writer, int height, int width, int x, int y) throws IOException {
        writer.writeAttribute("top", (Object)Layout.getMM(y), null);
        writer.writeAttribute("left", (Object)Layout.getMM(x), null);
        writer.writeAttribute("height", (Object)Layout.getMM(height), null);
        writer.writeAttribute("width", (Object)Layout.getMM(width), null);
        writer.writeAttribute("position", (Object)"absolute", null);
    }

    public static void writeTextBlockAlignStart(ResponseWriter writer, UIComponent component, String text) throws IOException {
        FoUtils.writeStartTextBlock(writer, component);
        writer.writeAttribute("text-align", (Object)"start", null);
        FoUtils.writeEndTextBlock(writer, text);
    }

    public static void writeTextBlockAlignLeft(ResponseWriter writer, UIComponent component, String text) throws IOException {
        FoUtils.writeStartTextBlock(writer, component);
        writer.writeAttribute("text-align", (Object)"left", null);
        FoUtils.writeEndTextBlock(writer, text);
    }

    private static void writeStartTextBlock(ResponseWriter writer, UIComponent component) throws IOException {
        writer.startElement("fo:block", component);
        writer.writeAttribute("line-height", (Object)"14pt", null);
        writer.writeAttribute("font-family", (Object)"sans-serif", null);
        writer.writeAttribute("font-size", (Object)"12pt", null);
    }

    private static void writeEndTextBlock(ResponseWriter writer, String text) throws IOException {
        writer.writeText((Object)text, null);
        writer.endElement("fo:block");
    }
}

