/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.fo.standard.standard.tag;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.UIGridLayout;
import org.apache.myfaces.tobago.renderkit.LayoutManager;
import org.apache.myfaces.tobago.renderkit.fo.standard.standard.tag.FoRendererBase;
import org.apache.myfaces.tobago.renderkit.fo.standard.standard.tag.FoUtils;
import org.apache.myfaces.tobago.renderkit.fo.standard.standard.tag.Layout;

public class GridLayoutRenderer
extends FoRendererBase
implements LayoutManager {
    private static final Log LOG = LogFactory.getLog(GridLayoutRenderer.class);

    public boolean getRendersChildren() {
        return false;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("*** begin    " + component));
        }
        try {
            this.layoutBegin(facesContext, component);
        }
        catch (RuntimeException e) {
            LOG.error((Object)"catched RuntimeException :", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LOG.error((Object)"catched Throwable :", e);
            throw new RuntimeException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("*   begin    " + component));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("*** end      " + component));
        }
        try {
            this.layoutEnd(facesContext, component);
        }
        catch (RuntimeException e) {
            LOG.error((Object)("catched " + e + " :" + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LOG.error((Object)"catched Throwable :", e);
            throw new RuntimeException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("*   end      " + component));
        }
    }

    public void layoutBegin(FacesContext facesContext, UIComponent component) {
    }

    private void layoutEnd(FacesContext facesContext, UIComponent component) {
        Layout layout = Layout.getLayout(component.getParent());
        if (layout == null) {
            throw new IllegalStateException("no Layout from " + component.getParent() + " " + component.getParent().getClientId(facesContext));
        }
        layout.setOrientation(2);
        if (component.getAttributes().get("columns") != null) {
            layout.setOrientation(1);
        }
        Layout.putLayout(component, layout);
        LOG.error((Object)layout);
        List children = component.getParent().getChildren();
        ResponseWriter writer = facesContext.getResponseWriter();
        LOG.error((Object)("parent is " + component.getParent() + "|" + component.getParent().getClientId(facesContext) + " component is " + component + "|" + component.getClientId(facesContext)));
        if (children.size() > 0) {
            int incrementX = layout.getWidth() / children.size();
            int incrementY = layout.getHeight() / children.size();
            int height = layout.getHeight();
            int width = layout.getWidth();
            int x = layout.getX();
            int y = layout.getY();
            for (int i = 0; i < children.size(); ++i) {
                LOG.error((Object)("i = " + i + " size = " + children.size()));
                UIComponent cell = (UIComponent)children.get(i);
                if (cell instanceof UIMessages || cell instanceof UIGridLayout) continue;
                try {
                    FoUtils.startBlockContainer(writer, component);
                    if (layout.getOrientation() == 2) {
                        FoUtils.layoutBlockContainer(writer, incrementY, width, x, y + incrementY * i);
                    } else {
                        FoUtils.layoutBlockContainer(writer, height, incrementY, x + incrementX * i, y);
                    }
                    Layout.setInLayout(cell, true);
                    this.encodeSuppe(facesContext, cell);
                    FoUtils.endBlockContainer(writer);
                    continue;
                }
                catch (IOException e) {
                    LOG.error((Object)"", (Throwable)e);
                }
            }
        }
    }

    private void encodeSuppe(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.getRendersChildren()) {
            component.encodeBegin(facesContext);
            component.encodeChildren(facesContext);
        } else {
            for (UIComponent kid : component.getChildren()) {
                this.encodeSuppe(facesContext, kid);
            }
        }
        component.encodeEnd(facesContext);
    }
}

