/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets;

import com.sun.facelets.Facelet;
import com.sun.facelets.FaceletException;
import com.sun.facelets.FaceletFactory;
import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.compiler.SAXCompiler;
import com.sun.facelets.compiler.TagLibraryConfig;
import com.sun.facelets.impl.DefaultFaceletFactory;
import com.sun.facelets.tag.TagDecorator;
import com.sun.facelets.tag.TagLibrary;
import com.sun.facelets.tag.ui.UIDebug;
import com.sun.facelets.util.DevTools;
import com.sun.facelets.util.FacesAPI;
import com.sun.facelets.util.FastWriter;
import com.sun.facelets.util.Resource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class FaceletViewHandler
extends ViewHandler {
    protected static final Logger log = Logger.getLogger("facelets.viewhandler");
    public static final long DEFAULT_REFRESH_PERIOD = 2L;
    public static final String PARAM_REFRESH_PERIO = "facelets.REFRESH_PERIOD";
    public static final String PARAM_SKIP_COMMENTS = "facelets.SKIP_COMMENTS";
    public static final String PARAM_VIEW_MAPPINGS = "facelets.VIEW_MAPPINGS";
    public static final String PARAM_LIBRARIES = "facelets.LIBRARIES";
    public static final String PARAM_DECORATORS = "facelets.DECORATORS";
    public static final String PARAM_DEVELOPMENT = "facelets.DEVELOPMENT";
    public static final String PARAM_BUFFER_SIZE = "facelets.BUFFER_SIZE";
    private static final String STATE_KEY = "~facelets.VIEW_STATE~";
    private static final int STATE_KEY_LEN = "~facelets.VIEW_STATE~".length();
    private static final Object STATE_NULL = new Object();
    private final ViewHandler parent;
    private boolean developmentMode = false;
    private int bufferSize;
    private String defaultSuffix;
    private FaceletFactory faceletFactory;
    private String[] extensionsArray;
    private String[] prefixesArray;

    protected static void removeTransient(UIComponent c) {
        UIComponent d;
        Iterator<Object> itr;
        if (c.getChildCount() > 0) {
            itr = c.getChildren().iterator();
            while (itr.hasNext()) {
                d = (UIComponent)itr.next();
                if (d.getFacets().size() > 0) {
                    Iterator jtr = d.getFacets().values().iterator();
                    while (jtr.hasNext()) {
                        UIComponent e = (UIComponent)jtr.next();
                        if (e.isTransient()) {
                            jtr.remove();
                            continue;
                        }
                        FaceletViewHandler.removeTransient(e);
                    }
                }
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                FaceletViewHandler.removeTransient(d);
            }
        }
        if (c.getFacets().size() > 0) {
            itr = c.getFacets().values().iterator();
            while (itr.hasNext()) {
                d = (UIComponent)itr.next();
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                FaceletViewHandler.removeTransient(d);
            }
        }
    }

    public FaceletViewHandler(ViewHandler parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(FacesContext context) {
        FaceletViewHandler faceletViewHandler = this;
        synchronized (faceletViewHandler) {
            if (this.faceletFactory == null) {
                log.fine("Initializing");
                Compiler c = this.createCompiler();
                this.initializeCompiler(c);
                this.faceletFactory = this.createFaceletFactory(c);
                this.initializeMappings(context);
                this.initializeMode(context);
                this.initializeBuffer(context);
                log.fine("Initialization Successful");
            }
        }
    }

    private void initializeMode(FacesContext context) {
        ExternalContext external = context.getExternalContext();
        String param = external.getInitParameter(PARAM_DEVELOPMENT);
        this.developmentMode = param != null && "true".equals(param);
    }

    private void initializeBuffer(FacesContext context) {
        ExternalContext external = context.getExternalContext();
        String param = external.getInitParameter(PARAM_BUFFER_SIZE);
        this.bufferSize = param != null && !"".equals(param) ? Integer.parseInt(param) : -1;
    }

    private void initializeMappings(FacesContext context) {
        ExternalContext external = context.getExternalContext();
        String viewMappings = external.getInitParameter(PARAM_VIEW_MAPPINGS);
        if (viewMappings != null && viewMappings.length() > 0) {
            String[] mappingsArray = viewMappings.split(";");
            ArrayList<String> extensionsList = new ArrayList<String>(mappingsArray.length);
            ArrayList<String> prefixesList = new ArrayList<String>(mappingsArray.length);
            for (int i = 0; i < mappingsArray.length; ++i) {
                String mapping = mappingsArray[i].trim();
                int mappingLength = mapping.length();
                if (mappingLength <= 1) continue;
                if (mapping.charAt(0) == '*') {
                    extensionsList.add(mapping.substring(1));
                    continue;
                }
                if (mapping.charAt(mappingLength - 1) != '*') continue;
                prefixesList.add(mapping.substring(0, mappingLength - 1));
            }
            this.extensionsArray = new String[extensionsList.size()];
            extensionsList.toArray(this.extensionsArray);
            this.prefixesArray = new String[prefixesList.size()];
            prefixesList.toArray(this.prefixesArray);
        }
    }

    protected FaceletFactory createFaceletFactory(Compiler c) {
        long refreshPeriod = 2L;
        FacesContext ctx = FacesContext.getCurrentInstance();
        String userPeriod = ctx.getExternalContext().getInitParameter(PARAM_REFRESH_PERIO);
        if (userPeriod != null && userPeriod.length() > 0) {
            refreshPeriod = Long.parseLong(userPeriod);
        }
        log.fine("Using Refresh Period: " + refreshPeriod + " sec");
        try {
            return new DefaultFaceletFactory(c, Resource.getResourceUrl(ctx, "/"), refreshPeriod);
        }
        catch (MalformedURLException e) {
            throw new FaceletException("Error Creating FaceletFactory", e);
        }
    }

    protected Compiler createCompiler() {
        return new SAXCompiler();
    }

    protected void initializeCompiler(Compiler c) {
        String skipParam;
        String decParam;
        int i;
        FacesContext ctx = FacesContext.getCurrentInstance();
        ExternalContext ext = ctx.getExternalContext();
        String libParam = ext.getInitParameter(PARAM_LIBRARIES);
        if (libParam != null) {
            libParam = libParam.trim();
            String[] libs = libParam.split(";");
            for (i = 0; i < libs.length; ++i) {
                try {
                    URL src = ext.getResource(libs[i].trim());
                    if (src == null) {
                        throw new FileNotFoundException(libs[i]);
                    }
                    TagLibrary libObj = TagLibraryConfig.create(src);
                    c.addTagLibrary(libObj);
                    log.fine("Successfully Loaded Library: " + libs[i]);
                    continue;
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Error Loading Library: " + libs[i], e);
                }
            }
        }
        if ((decParam = ext.getInitParameter(PARAM_DECORATORS)) != null) {
            decParam = decParam.trim();
            String[] decs = decParam.split(";");
            for (i = 0; i < decs.length; ++i) {
                try {
                    TagDecorator decObj = (TagDecorator)Class.forName(decs[i]).newInstance();
                    c.addTagDecorator(decObj);
                    log.fine("Successfully Loaded Decorator: " + decs[i]);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error Loading Decorator: " + decs[i], e);
                }
            }
        }
        if ((skipParam = ext.getInitParameter(PARAM_SKIP_COMMENTS)) != null && "false".equals(skipParam)) {
            c.setTrimmingComments(false);
        }
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        if (UIDebug.debugRequest(context)) {
            return new UIViewRoot();
        }
        return this.parent.restoreView(context, viewId);
    }

    protected ViewHandler getWrapped() {
        return this.parent;
    }

    protected ResponseWriter createResponseWriter(FacesContext context) throws IOException, FacesException {
        ExternalContext extContext = context.getExternalContext();
        RenderKit renderKit = context.getRenderKit();
        ServletRequest request = (ServletRequest)extContext.getRequest();
        ServletResponse response = (ServletResponse)extContext.getResponse();
        if (this.bufferSize != -1) {
            response.setBufferSize(this.bufferSize);
        }
        String contentType = null;
        String encoding = request.getCharacterEncoding();
        ResponseWriter writer = renderKit.createResponseWriter((Writer)NullWriter.Instance, null, encoding);
        contentType = writer.getContentType();
        encoding = writer.getCharacterEncoding();
        if (contentType == null) {
            contentType = "text/html";
            if (log.isLoggable(Level.FINEST)) {
                log.finest("ResponseWriter created had a null ContentType, defaulting to text/html");
            }
        }
        if (encoding == null) {
            encoding = "UTF-8";
            if (log.isLoggable(Level.FINEST)) {
                log.finest("ResponseWriter created had a null CharacterEncoding, defaulting to UTF-8");
            }
        }
        response.setContentType(contentType + "; charset=" + encoding);
        writer = writer.cloneWithWriter((Writer)response.getWriter());
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        String renderedViewId = this.getRenderedViewId(context, viewToRender.getViewId());
        viewToRender.setViewId(renderedViewId);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Building View: " + renderedViewId);
        }
        Facelet f = null;
        FaceletFactory.setInstance(this.faceletFactory);
        try {
            f = this.faceletFactory.getFacelet(viewToRender.getViewId());
        }
        finally {
            FaceletFactory.setInstance(null);
        }
        long time = System.currentTimeMillis();
        f.apply(context, (UIComponent)viewToRender);
        time = System.currentTimeMillis() - time;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Took " + time + "ms to build view: " + viewToRender.getViewId());
        }
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        if (this.faceletFactory == null) {
            this.initialize(context);
        }
        if (!viewToRender.isRendered()) {
            return;
        }
        if (!this.handledByFacelets(viewToRender)) {
            this.parent.renderView(context, viewToRender);
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Rendering View: " + viewToRender.getViewId());
        }
        try {
            this.buildView(context, viewToRender);
            ResponseWriter origWriter = this.createResponseWriter(context);
            FastWriter stateWriter = new FastWriter(this.bufferSize != -1 ? this.bufferSize : 1024);
            ResponseWriter writer = origWriter.cloneWithWriter((Writer)stateWriter);
            context.setResponseWriter(writer);
            long time = System.currentTimeMillis();
            writer.startDocument();
            if (FacesAPI.getVersion() >= 12) {
                viewToRender.encodeAll(context);
            } else {
                FaceletViewHandler.encodeRecursive(context, (UIComponent)viewToRender);
            }
            writer.endDocument();
            writer.close();
            if (FacesAPI.getVersion() < 12) {
                FaceletViewHandler.removeTransient((UIComponent)viewToRender);
            }
            StateManager stateMgr = context.getApplication().getStateManager();
            StateManager.SerializedView stateObj = stateMgr.saveSerializedView(context);
            String content = stateWriter.toString();
            if (stateMgr.isSavingStateInClient(context) || FacesAPI.getVersion() >= 12) {
                stateWriter.reset();
                stateMgr.writeState(context, stateObj);
                String stateStr = stateWriter.toString();
                int start = 0;
                int end = content.indexOf(STATE_KEY, start);
                while (end != -1) {
                    origWriter.write(content, start, end - start);
                    origWriter.write(stateStr);
                    start = end + STATE_KEY_LEN;
                    end = content.indexOf(STATE_KEY, start);
                }
                origWriter.write(content, start, content.length() - start);
            } else {
                origWriter.write(content);
            }
            time = System.currentTimeMillis() - time;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Took " + time + "ms to render view: " + viewToRender.getViewId());
            }
        }
        catch (FileNotFoundException fnfe) {
            this.handleFaceletNotFound(context, viewToRender.getViewId());
        }
        catch (Exception e) {
            this.handleRenderException(context, e);
        }
    }

    protected void handleRenderException(FacesContext context, Exception e) throws IOException, ELException, FacesException {
        Object resp = context.getExternalContext().getResponse();
        if (log.isLoggable(Level.SEVERE)) {
            UIViewRoot root = context.getViewRoot();
            StringBuffer sb = new StringBuffer(64);
            sb.append("Error Rendering View");
            if (root != null) {
                sb.append('[');
                sb.append(root.getViewId());
                sb.append(']');
            }
            log.log(Level.SEVERE, sb.toString(), e);
        }
        if (!this.developmentMode || context.getResponseComplete() || !(resp instanceof HttpServletResponse)) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
        HttpServletResponse httpResp = (HttpServletResponse)resp;
        httpResp.reset();
        httpResp.setContentType("text/html; charset=UTF-8");
        PrintWriter w = httpResp.getWriter();
        DevTools.debugHtml(w, context, e);
        ((Writer)w).flush();
        context.responseComplete();
    }

    protected void handleFaceletNotFound(FacesContext context, String viewId) throws FacesException, IOException {
        String actualId = this.getActionURL(context, viewId);
        Object respObj = context.getExternalContext().getResponse();
        if (respObj instanceof HttpServletResponse) {
            HttpServletResponse respHttp = (HttpServletResponse)respObj;
            respHttp.sendError(404, actualId);
            context.responseComplete();
        }
    }

    protected static final void encodeRecursive(FacesContext context, UIComponent viewToRender) throws IOException, FacesException {
        if (viewToRender.isRendered()) {
            viewToRender.encodeBegin(context);
            if (viewToRender.getRendersChildren()) {
                viewToRender.encodeChildren(context);
            } else if (viewToRender.getChildCount() > 0) {
                Iterator kids = viewToRender.getChildren().iterator();
                while (kids.hasNext()) {
                    UIComponent kid = (UIComponent)kids.next();
                    FaceletViewHandler.encodeRecursive(context, kid);
                }
            }
            viewToRender.encodeEnd(context);
        }
    }

    private boolean handledByFacelets(UIViewRoot viewToRender) {
        int i;
        if (this.extensionsArray == null && this.prefixesArray == null) {
            return true;
        }
        String viewId = viewToRender.getViewId();
        if (this.extensionsArray != null) {
            for (i = 0; i < this.extensionsArray.length; ++i) {
                String extension = this.extensionsArray[i];
                if (!viewId.endsWith(extension)) continue;
                return true;
            }
        }
        if (this.prefixesArray != null) {
            for (i = 0; i < this.prefixesArray.length; ++i) {
                String prefix = this.prefixesArray[i];
                if (!viewId.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public String getDefaultSuffix(FacesContext context) throws FacesException {
        if (this.defaultSuffix == null) {
            ExternalContext extCtx = context.getExternalContext();
            String viewSuffix = extCtx.getInitParameter("javax.faces.DEFAULT_SUFFIX");
            this.defaultSuffix = viewSuffix != null ? viewSuffix : ".jsp";
        }
        return this.defaultSuffix;
    }

    protected String getRenderedViewId(FacesContext context, String actionId) {
        ExternalContext extCtx = context.getExternalContext();
        String viewId = actionId;
        if (extCtx.getRequestPathInfo() == null) {
            String facesSuffix = actionId.substring(actionId.lastIndexOf(46));
            String viewSuffix = this.getDefaultSuffix(context);
            viewId = actionId.replaceFirst(facesSuffix, viewSuffix);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("ActionId -> ViewId: " + actionId + " -> " + viewId);
        }
        return viewId;
    }

    public void writeState(FacesContext context) throws IOException {
        if (this.handledByFacelets(context.getViewRoot())) {
            StateManager stateMgr = context.getApplication().getStateManager();
            if (stateMgr.isSavingStateInClient(context) || FacesAPI.getVersion() >= 12) {
                context.getResponseWriter().write(STATE_KEY);
            }
        } else {
            this.parent.writeState(context);
        }
    }

    public Locale calculateLocale(FacesContext context) {
        return this.parent.calculateLocale(context);
    }

    public String calculateRenderKitId(FacesContext context) {
        return this.parent.calculateRenderKitId(context);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        if (UIDebug.debugRequest(context)) {
            return new UIViewRoot();
        }
        return this.parent.createView(context, viewId);
    }

    public String getActionURL(FacesContext context, String viewId) {
        return this.parent.getActionURL(context, viewId);
    }

    public String getResourceURL(FacesContext context, String path) {
        return this.parent.getResourceURL(context, path);
    }

    protected static class NullWriter
    extends Writer {
        static final NullWriter Instance = new NullWriter();

        protected NullWriter() {
        }

        public void write(char[] buffer) {
        }

        public void write(char[] buffer, int off, int len) {
        }

        public void write(String str) {
        }

        public void write(int c) {
        }

        public void write(String str, int off, int len) {
        }

        public void close() {
        }

        public void flush() {
        }
    }
}

