/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.compiler;

import com.sun.facelets.FaceletHandler;
import com.sun.facelets.compiler.CompilationUnit;
import com.sun.facelets.compiler.UILiteralTextHandler;
import com.sun.facelets.compiler.UITextHandler;
import com.sun.facelets.el.ELText;
import com.sun.facelets.tag.CompositeFaceletHandler;
import com.sun.facelets.tag.Tag;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.el.ELException;

final class TextUnit
extends CompilationUnit {
    private final StringBuffer buffer;
    private final Stack tags;
    private final List children;
    private boolean startTagOpen;
    private final String alias;

    public TextUnit(String alias) {
        this.alias = alias;
        this.buffer = new StringBuffer(256);
        this.tags = new Stack();
        this.children = new ArrayList();
        this.startTagOpen = false;
    }

    public FaceletHandler createFaceletHandler() {
        this.flushBufferToConfig(false);
        if (this.children.size() == 0) {
            return LEAF;
        }
        FaceletHandler[] h = new FaceletHandler[this.children.size()];
        for (int i = 0; i < h.length; ++i) {
            Object obj = this.children.get(i);
            h[i] = obj instanceof FaceletHandler ? (FaceletHandler)obj : ((CompilationUnit)obj).createFaceletHandler();
        }
        if (h.length == 1) {
            return h[0];
        }
        return new CompositeFaceletHandler(h);
    }

    public void write(String text) {
        this.finishStartTag();
        this.buffer.append(text);
    }

    public void startTag(Tag tag) {
        this.finishStartTag();
        this.tags.push(tag);
        this.buffer.append('<');
        this.buffer.append(tag.getQName());
        TagAttribute[] attrs = tag.getAttributes().getAll();
        if (attrs.length > 0) {
            for (int i = 0; i < attrs.length; ++i) {
                this.buffer.append(' ').append(attrs[i].getQName()).append("=\"").append(attrs[i].getValue()).append("\"");
            }
        }
        this.startTagOpen = true;
    }

    private void finishStartTag() {
        if (this.tags.size() > 0 && this.startTagOpen) {
            this.buffer.append(">");
            this.startTagOpen = false;
        }
    }

    public void endTag() {
        Tag tag = (Tag)this.tags.pop();
        if (this.startTagOpen) {
            this.buffer.append("/>");
            this.startTagOpen = false;
        } else {
            this.buffer.append("</").append(tag.getQName()).append('>');
        }
    }

    public void addChild(CompilationUnit unit) {
        this.finishStartTag();
        this.flushBufferToConfig(true);
        this.children.add(unit);
    }

    protected void flushBufferToConfig(boolean child) {
        if (this.buffer.length() > 0) {
            String s = this.buffer.toString();
            if (s.trim().length() > 0) {
                if (child) {
                    s = TextUnit.trimRight(s);
                }
                if (s.length() > 0) {
                    try {
                        ELText txt = ELText.parse(s);
                        if (txt != null) {
                            if (txt.isLiteral()) {
                                this.children.add(new UILiteralTextHandler(txt.toString()));
                            } else {
                                this.children.add(new UITextHandler(this.alias, txt));
                            }
                        }
                    }
                    catch (ELException e) {
                        if (this.tags.size() > 0) {
                            throw new TagException((Tag)this.tags.peek(), e.getMessage());
                        }
                        throw new ELException(this.alias + ": " + e.getMessage(), e.getCause());
                    }
                }
            }
            this.buffer.setLength(0);
        }
    }

    public boolean isClosed() {
        return this.tags.empty();
    }

    private static final String trimRight(String s) {
        int i;
        for (i = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        if (i == s.length() - 1) {
            return s;
        }
        if (i + 1 < s.length() && Character.isSpaceChar(s.charAt(i + 1))) {
            return s.substring(0, i + 2);
        }
        return s.substring(0, i + 1);
    }

    public String toString() {
        return "TextUnit[" + this.children.size() + "]";
    }
}

