/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.impl;

import com.sun.facelets.Facelet;
import com.sun.facelets.FaceletException;
import com.sun.facelets.FaceletFactory;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.impl.DefaultFacelet;
import com.sun.facelets.util.ParameterCheck;
import com.sun.facelets.util.Resource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;

public final class DefaultFaceletFactory
extends FaceletFactory {
    protected static final Logger log = Logger.getLogger("facelets.factory");
    private final Compiler compiler;
    private final Map facelets;
    private final Map relativeLocations;
    private final URL location;
    private final long refreshPeriod;

    public DefaultFaceletFactory(Compiler compiler, URL url) {
        this(compiler, url, -1L);
    }

    public DefaultFaceletFactory(Compiler compiler, URL url, long refreshPeriod) {
        ParameterCheck.notNull("compiler", compiler);
        ParameterCheck.notNull("url", url);
        this.compiler = compiler;
        this.facelets = new HashMap();
        this.relativeLocations = new HashMap();
        this.location = url;
        log.fine("Using Base Location: " + url);
        this.refreshPeriod = refreshPeriod > 0L ? refreshPeriod * 1000L : -1L;
        log.fine("Using Refresh Period: " + this.refreshPeriod);
    }

    public Facelet getFacelet(String uri) throws IOException, FaceletException, FacesException, ELException {
        URL url = (URL)this.relativeLocations.get(uri);
        if (url == null) {
            url = this.resolveURL(this.location, uri);
            if (url != null) {
                this.relativeLocations.put(uri, url);
            } else {
                throw new IOException("'" + uri + "' not found.");
            }
        }
        return this.getFacelet(url);
    }

    public URL resolveURL(URL source, String path) throws IOException {
        if (path.startsWith("/")) {
            URL url = Resource.getResourceUrl(FacesContext.getCurrentInstance(), path);
            if (url == null) {
                throw new FileNotFoundException(path + " Not Found in ExternalContext as a Resource");
            }
            return url;
        }
        return new URL(source, path);
    }

    public Facelet getFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        ParameterCheck.notNull("url", url);
        DefaultFacelet f = (DefaultFacelet)this.facelets.get(url);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = this.createFacelet(url);
            this.facelets.put(url, f);
        }
        return f;
    }

    protected boolean needsToBeRefreshed(DefaultFacelet facelet) {
        if (this.refreshPeriod != -1L) {
            long ttl = facelet.getCreateTime() + this.refreshPeriod;
            if (System.currentTimeMillis() > ttl) {
                try {
                    long atl = facelet.getSource().openConnection().getLastModified();
                    return atl > ttl;
                }
                catch (Exception e) {
                    throw new FaceletException("Error Checking Last Modified for " + facelet.getAlias(), e);
                }
            }
        }
        return false;
    }

    private DefaultFacelet createFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Facelet for: " + url);
        }
        String alias = "/" + url.getFile().replaceFirst(this.location.getFile(), "");
        try {
            FaceletHandler h = this.compiler.compile(url, alias);
            DefaultFacelet f = new DefaultFacelet(this, this.compiler.createExpressionFactory(), url, alias, h);
            return f;
        }
        catch (FileNotFoundException fnfe) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning(alias + " not found at " + url.toExternalForm());
            }
            throw fnfe;
        }
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }
}

