/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag.jsf;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.LegacyValueBinding;
import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.MetaTagHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.jsf.ActionSourceRule;
import com.sun.facelets.tag.jsf.ComponentConfig;
import com.sun.facelets.tag.jsf.ComponentRule;
import com.sun.facelets.tag.jsf.ComponentSupport;
import com.sun.facelets.tag.jsf.EditableValueHolderRule;
import com.sun.facelets.tag.jsf.ValueHolderRule;
import com.sun.facelets.util.FacesAPI;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class ComponentHandler
extends MetaTagHandler {
    private static final Logger log = Logger.getLogger("facelets.tag.component");
    private final TagAttribute binding;
    private final String componentType;
    private final TagAttribute id;
    private final String rendererType;

    public ComponentHandler(ComponentConfig config) {
        super(config);
        this.componentType = config.getComponentType();
        this.rendererType = config.getRendererType();
        this.id = this.getAttribute("id");
        this.binding = this.getAttribute("binding");
    }

    public final void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        if (parent == null) {
            throw new TagException(this.tag, "Parent UIComponent was null");
        }
        String id = ctx.generateUniqueId(this.tagId);
        UIComponent c = ComponentSupport.findChildByTagId(parent, id);
        boolean componentFound = false;
        if (c != null) {
            componentFound = true;
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.tag + " Component[" + id + "] Found, marking children for cleanup");
            }
            ComponentSupport.markForDeletion(c);
        } else {
            c = this.createComponent(ctx);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.tag + " Component[" + id + "] Created: " + c.getClass().getName());
            }
            this.setAttributes(ctx, c);
            c.getAttributes().put("com.sun.facelets.MARK_ID", id);
            if (this.id != null) {
                c.setId(ctx.generateUniqueId(this.id.getValue(ctx)));
            } else {
                UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
                if (root != null) {
                    c.setId(root.createUniqueId());
                }
            }
            if (this.rendererType != null) {
                c.setRendererType(this.rendererType);
            }
            this.onComponentCreated(ctx, c, parent);
        }
        this.nextHandler.apply(ctx, c);
        if (componentFound) {
            ComponentSupport.finalizeForDeletion(c);
            parent.getChildren().remove(c);
        }
        parent.getChildren().add(c);
    }

    protected UIComponent createComponent(FaceletContext ctx) {
        UIComponent c = null;
        FacesContext faces = ctx.getFacesContext();
        Application app = faces.getApplication();
        if (this.binding != null) {
            ValueExpression ve = this.binding.getValueExpression(ctx, Object.class);
            if (FacesAPI.getVersion() >= 12) {
                c = app.createComponent(ve, faces, this.componentType);
                if (c != null) {
                    if (FacesAPI.getComponentVersion(c) >= 12) {
                        c.setValueExpression("binding", ve);
                    } else {
                        LegacyValueBinding vb = new LegacyValueBinding(ve);
                        c.setValueBinding("binding", (ValueBinding)vb);
                    }
                }
            } else {
                LegacyValueBinding vb = new LegacyValueBinding(ve);
                c = app.createComponent((ValueBinding)vb, faces, this.componentType);
                if (c != null) {
                    c.setValueBinding("binding", (ValueBinding)vb);
                }
            }
        } else {
            c = app.createComponent(this.componentType);
        }
        return c;
    }

    protected String getId(FaceletContext ctx) {
        if (this.id != null) {
            return this.id.getValue(ctx);
        }
        return ctx.generateUniqueId(this.tagId);
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset m = super.createMetaRuleset(type);
        m.ignore("binding").ignore("id");
        m.addRule(ComponentRule.Instance);
        if (ActionSource.class.isAssignableFrom(type)) {
            m.addRule(ActionSourceRule.Instance);
        }
        if (ValueHolder.class.isAssignableFrom(type)) {
            m.addRule(ValueHolderRule.Instance);
            if (EditableValueHolder.class.isAssignableFrom(type)) {
                m.ignore("submittedValue");
                m.ignore("valid");
                m.addRule(EditableValueHolderRule.Instance);
            }
        }
        return m;
    }

    protected void onComponentCreated(FaceletContext ctx, UIComponent c, UIComponent parent) {
    }
}

