/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag.jsf;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;

public final class ComponentSupport {
    private static final String MARK_DELETED = "com.sun.facelets.MARK_DELETED";
    public static final String MARK_CREATED = "com.sun.facelets.MARK_ID";

    public static final void finalizeForDeletion(UIComponent c) {
        c.getAttributes().remove(MARK_DELETED);
        int sz = c.getChildCount();
        if (sz > 0) {
            UIComponent cc = null;
            List cl = c.getChildren();
            while (--sz >= 0) {
                cc = (UIComponent)cl.get(sz);
                if (!cc.getAttributes().containsKey(MARK_DELETED)) continue;
                cl.remove(sz);
            }
        }
        if (c.getFacets().size() > 0) {
            Collection col = c.getFacets().values();
            Iterator itr = col.iterator();
            while (itr.hasNext()) {
                UIComponent fc = (UIComponent)itr.next();
                if (!fc.getAttributes().containsKey(MARK_DELETED)) continue;
                itr.remove();
            }
        }
    }

    public static final UIComponent findChild(UIComponent parent, String id) {
        int sz = parent.getChildCount();
        if (sz > 0) {
            UIComponent c = null;
            List cl = parent.getChildren();
            while (--sz >= 0) {
                c = (UIComponent)cl.get(sz);
                if (!id.equals(c.getId())) continue;
                return c;
            }
        }
        return null;
    }

    public static final UIComponent findChildByTagId(UIComponent parent, String id) {
        int sz = parent.getChildCount();
        if (sz > 0) {
            UIComponent c = null;
            List cl = parent.getChildren();
            String cid = null;
            while (--sz >= 0) {
                c = (UIComponent)cl.get(sz);
                cid = (String)c.getAttributes().get(MARK_CREATED);
                if (!id.equals(cid)) continue;
                return c;
            }
        }
        return null;
    }

    public static final Locale getLocale(FaceletContext ctx, TagAttribute attr) throws TagAttributeException {
        Object obj = attr.getObject(ctx);
        if (obj instanceof Locale) {
            return (Locale)obj;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            if (s.length() == 2) {
                return new Locale(s);
            }
            if (s.length() == 5) {
                return new Locale(s.substring(0, 2), s.substring(3, 5).toUpperCase());
            }
            if (s.length() >= 7) {
                return new Locale(s.substring(0, 2), s.substring(3, 5).toUpperCase(), s.substring(6, s.length()));
            }
            throw new TagAttributeException(attr, "Invalid Locale Specified: " + s);
        }
        throw new TagAttributeException(attr, "Attribute did not evaluate to a String or Locale: " + obj);
    }

    public static final UIViewRoot getViewRoot(FaceletContext ctx, UIComponent parent) {
        UIComponent c = parent;
        do {
            if (!(c instanceof UIViewRoot)) continue;
            return (UIViewRoot)c;
        } while ((c = c.getParent()) != null);
        return ctx.getFacesContext().getViewRoot();
    }

    public static final void markForDeletion(UIComponent c) {
        c.getAttributes().put(MARK_DELETED, Boolean.TRUE);
        int sz = c.getChildCount();
        if (sz > 0) {
            UIComponent cc = null;
            List cl = c.getChildren();
            while (--sz >= 0) {
                cc = (UIComponent)cl.get(sz);
                if (!cc.getAttributes().containsKey(MARK_CREATED)) continue;
                cc.getAttributes().put(MARK_DELETED, Boolean.TRUE);
            }
        }
        if (c.getFacets().size() > 0) {
            Collection col = c.getFacets().values();
            Iterator itr = col.iterator();
            while (itr.hasNext()) {
                UIComponent fc = (UIComponent)itr.next();
                if (!fc.getAttributes().containsKey(MARK_CREATED)) continue;
                fc.getAttributes().put(MARK_DELETED, Boolean.TRUE);
            }
        }
    }

    public static final boolean isNew(UIComponent component) {
        return component != null && component.getParent() == null;
    }
}

