/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.ajax.api;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxUtils;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;

public class AjaxPhaseListener
implements PhaseListener {
    private static final Log LOG = LogFactory.getLog(AjaxPhaseListener.class);
    public static final String AJAX_COMPONENT_ID = "affectedAjaxComponent";

    public static Object getValueForComponent(FacesContext facesContext, UIComponent component) {
        String possibleClientId = component.getClientId(facesContext);
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(possibleClientId)) {
            return requestParameterMap.get(possibleClientId);
        }
        possibleClientId = (String)requestParameterMap.get(AJAX_COMPONENT_ID);
        UIViewRoot root = facesContext.getViewRoot();
        UIComponent ajaxComponent = root.findComponent(possibleClientId);
        if (ajaxComponent == component) {
            return requestParameterMap.get(possibleClientId);
        }
        LOG.error((Object)("No value found for this component : " + possibleClientId));
        return null;
    }

    public void afterPhase(PhaseEvent event) {
        if (event.getPhaseId().getOrdinal() != PhaseId.APPLY_REQUEST_VALUES.getOrdinal()) {
            return;
        }
        FacesContext facesContext = event.getFacesContext();
        ExternalContext externalContext = facesContext.getExternalContext();
        if (externalContext.getRequestParameterMap().containsKey(AJAX_COMPONENT_ID)) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("AJAX: componentID gefunden :" + externalContext.getRequestParameterMap().get(AJAX_COMPONENT_ID)));
                }
                UIViewRoot viewRoot = facesContext.getViewRoot();
                StringWriter content = new StringWriter();
                RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
                RenderKit renderKit = renderFactory.getRenderKit(facesContext, viewRoot.getRenderKitId());
                ResponseWriter contentWriter = renderKit.createResponseWriter((Writer)content, null, null);
                facesContext.setResponseWriter(contentWriter);
                AjaxUtils.processAjax(facesContext, (UIComponent)viewRoot);
                this.writeAjaxResponse(facesContext, content.toString());
                StateManager stateManager = facesContext.getApplication().getStateManager();
                if (!stateManager.isSavingStateInClient(facesContext)) {
                    stateManager.saveSerializedView(facesContext);
                }
                facesContext.responseComplete();
            }
            catch (IOException e) {
                LOG.error((Object)"Exception while processing Ajax", (Throwable)e);
            }
        }
    }

    private void writeAjaxResponse(FacesContext facesContext, String content) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        StringBuffer buf = new StringBuffer(content);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Size of AjaxResponse:\n" + buf.length() + " = 0x" + Integer.toHexString(buf.length())));
        }
        buf.insert(0, Integer.toHexString(buf.length()) + "\r\n");
        buf.append("\r\n0\r\n\r\n");
        if (externalContext.getResponse() instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)externalContext.getResponse();
            httpServletResponse.addHeader("Transfer-Encoding", "chunked");
            PrintWriter responseWriter = httpServletResponse.getWriter();
            responseWriter.print(buf.toString());
            responseWriter.flush();
            responseWriter.close();
        }
    }

    public void beforePhase(PhaseEvent event) {
        if (event.getPhaseId().getOrdinal() != PhaseId.RENDER_RESPONSE.getOrdinal()) {
            return;
        }
        try {
            FacesContext facesContext = event.getFacesContext();
            ExternalContext externalContext = facesContext.getExternalContext();
            Map requestParameterMap = externalContext.getRequestParameterMap();
            if (requestParameterMap.containsKey(AJAX_COMPONENT_ID)) {
                LOG.error((Object)"Ignoring AjaxRequest without valid component tree!");
                String message = ResourceManagerUtil.getPropertyNotNull(facesContext, "tobago", "tobago.ajax.response.error");
                this.writeAjaxResponse(facesContext, message);
                facesContext.responseComplete();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Exception while processing Ajax", (Throwable)e);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

