/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.ajax.api;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxComponent;
import org.apache.myfaces.tobago.ajax.api.AjaxRenderer;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIViewRoot;
import org.apache.myfaces.tobago.renderkit.RendererBase;

public class AjaxUtils {
    private static final Log LOG = LogFactory.getLog(AjaxUtils.class);

    public static void checkParamValidity(FacesContext facesContext, UIComponent uiComponent, Class compClass) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext may not be null");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent may not be null");
        }
        if (compClass != null && !compClass.isInstance(uiComponent)) {
            throw new IllegalArgumentException("uiComponent : " + uiComponent.getClass().getName() + " is not instance of " + compClass.getName() + " as it should be");
        }
    }

    public static void encodeAjaxComponent(FacesContext facesContext, UIComponent component) throws IOException {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (!component.isRendered()) {
            return;
        }
        RendererBase renderer = ComponentUtil.getRenderer(facesContext, component);
        if (renderer != null && renderer instanceof AjaxRenderer) {
            ((AjaxRenderer)((Object)renderer)).encodeAjax(facesContext, component);
        }
    }

    public static void processAjax(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof AjaxComponent) {
            ((AjaxComponent)component).processAjax(facesContext);
        } else {
            AjaxUtils.processAjaxOnChildren(facesContext, component);
        }
    }

    public static void processActiveAjaxComponent(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof AjaxComponent) {
            UIViewRoot viewRoot = (UIViewRoot)facesContext.getViewRoot();
            if (!facesContext.getRenderResponse()) {
                component.processValidators(facesContext);
                viewRoot.broadcastEventsForPhase(facesContext, PhaseId.PROCESS_VALIDATIONS);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Skipping validate");
            }
            if (!facesContext.getRenderResponse()) {
                component.processUpdates(facesContext);
                viewRoot.broadcastEventsForPhase(facesContext, PhaseId.UPDATE_MODEL_VALUES);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Skipping updates");
            }
            if (!facesContext.getRenderResponse()) {
                viewRoot.processApplication(facesContext);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Skipping application");
            }
            ((AjaxComponent)component).encodeAjax(facesContext);
        } else {
            LOG.error((Object)("Can't process non AjaxComponent : \"" + component.getClientId(facesContext) + "\" = " + component.getClass().getName()));
        }
    }

    public static void processAjaxOnChildren(FacesContext facesContext, UIComponent component) throws IOException {
        Iterator facetsAndChildren = component.getFacetsAndChildren();
        while (facetsAndChildren.hasNext() && !facesContext.getResponseComplete()) {
            AjaxUtils.processAjax(facesContext, (UIComponent)facetsAndChildren.next());
        }
    }
}

