/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.application;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.application.FopConverter;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.webapp.TobagoResponse;

public class ViewHandlerImpl
extends ViewHandler {
    private static final Log LOG = LogFactory.getLog(ViewHandlerImpl.class);
    public static final String PAGE_ID = "tobago::page-id";
    private ViewHandler base;

    public ViewHandlerImpl(ViewHandler base) {
        LOG.info((Object)("Hiding ri base implemation: " + base));
        this.base = base;
    }

    public Locale calculateLocale(FacesContext facesContext) {
        return this.base.calculateLocale(facesContext);
    }

    public String calculateRenderKitId(FacesContext facesContext) {
        return this.base.calculateRenderKitId(facesContext);
    }

    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        UIViewRoot viewRoot;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating new view with viewId:        '" + viewId + "'"));
        }
        if (!((viewRoot = this.base.createView(facesContext, viewId)) instanceof org.apache.myfaces.tobago.component.UIViewRoot)) {
            UIViewRoot tobagoViewRoot = (UIViewRoot)facesContext.getApplication().createComponent("javax.faces.ViewRoot");
            if (!(tobagoViewRoot instanceof org.apache.myfaces.tobago.component.UIViewRoot)) {
                LOG.warn((Object)"Application creating wrong UIViewRoot, forcing Tobago");
                tobagoViewRoot = new org.apache.myfaces.tobago.component.UIViewRoot();
            }
            tobagoViewRoot.setLocale(viewRoot.getLocale());
            tobagoViewRoot.setViewId(viewId);
            tobagoViewRoot.setRenderKitId(viewRoot.getRenderKitId());
            viewRoot = tobagoViewRoot;
        }
        this.ensureClientProperties(facesContext, viewRoot);
        return viewRoot;
    }

    private void ensureClientProperties(FacesContext facesContext, UIViewRoot viewRoot) {
        if (viewRoot != null) {
            ClientProperties clientProperties = ClientProperties.getInstance(facesContext);
            viewRoot.getAttributes().put("clientProperties", clientProperties);
        }
    }

    public String getActionURL(FacesContext facesContext, String viewId) {
        return this.base.getActionURL(facesContext, viewId);
    }

    public String getResourceURL(FacesContext facesContext, String path) {
        return this.base.getResourceURL(facesContext, path);
    }

    public void renderView(FacesContext facesContext, UIViewRoot viewRoot) throws IOException, FacesException {
        String requestUri = viewRoot.getViewId();
        String contentType = ClientProperties.getInstance(viewRoot).getContentType();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("contentType = '" + contentType + "'"));
        }
        try {
            if (contentType.indexOf("fo") == -1) {
                this.base.renderView(facesContext, viewRoot);
            } else if (facesContext.getExternalContext().getResponse() instanceof TobagoResponse) {
                ((TobagoResponse)((Object)facesContext.getExternalContext().getResponse())).setBuffering();
                HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
                HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
                RequestDispatcher requestDispatcher = request.getRequestDispatcher(requestUri);
                requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
                response.setContentType("application/pdf");
                String buffer = ((TobagoResponse)((Object)facesContext.getExternalContext().getResponse())).getBufferedString();
                ServletResponse servletResponse = (ServletResponse)facesContext.getExternalContext().getResponse();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("fo buffer: " + buffer));
                }
                FopConverter.fo2Pdf(servletResponse, buffer);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("requestUri '" + requestUri + "'"), (Throwable)e);
            throw new FacesException((Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"VIEW");
            LOG.debug((Object)ComponentUtil.toString((UIComponent)facesContext.getViewRoot(), 0));
        }
    }

    public UIViewRoot restoreView(FacesContext facesContext, String viewId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("restore view with viewId:             '" + viewId + "'"));
        }
        this.handleEncoding(facesContext);
        UIViewRoot viewRoot = this.base.restoreView(facesContext, viewId);
        this.ensureClientProperties(facesContext, viewRoot);
        return viewRoot;
    }

    private void handleEncoding(FacesContext facesContext) {
        try {
            HttpServletRequest request;
            if (facesContext.getExternalContext().getRequest() instanceof HttpServletRequest && (request = (HttpServletRequest)facesContext.getExternalContext().getRequest()).getCharacterEncoding() == null) {
                request.setCharacterEncoding("UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)("" + e), (Throwable)e);
        }
    }

    public void writeState(FacesContext facesContext) throws IOException {
        this.base.writeState(facesContext);
    }
}

