/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.bean;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceMap
extends Properties {
    private static final Log LOG = LogFactory.getLog(ResourceMap.class);

    public ResourceMap() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"creating ResourceMap");
        }
    }

    public void setFilename(String filename) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("filename = '" + filename + "'"));
        }
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(filename);
            if (is == null) {
                LOG.error((Object)("Cannot load resource map from file: " + filename));
            }
            this.load(is);
        }
        catch (IOException e) {
            LOG.error((Object)("Cannot load resource map from file: " + filename), (Throwable)e);
        }
        for (Object x : this.keySet()) {
            LOG.debug(x);
        }
    }

    public Object get(Object key) {
        Object value = super.get(key);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Unknown value for key='" + key + "'"));
        }
        if (value == null) {
            LOG.warn((Object)("Unknown value for key='" + key + "'"));
        }
        return value;
    }
}

