/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.UIColumn;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIData;
import org.apache.myfaces.tobago.component.UIForm;
import org.apache.myfaces.tobago.component.UIInput;
import org.apache.myfaces.tobago.component.UIMenuSelectOne;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UISelectItem;
import org.apache.myfaces.tobago.el.ConstantMethodBinding;
import org.apache.myfaces.tobago.event.SheetStateChangeEvent;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.util.RangeParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentUtil {
    private static final Log LOG = LogFactory.getLog(ComponentUtil.class);
    private static final String RENDER_KEY_PREFIX = "org.apache.myfaces.tobago.component.ComponentUtil.RendererKeyPrefix_";
    private static final Class[] ACTION_LISTENER_ARGS = new Class[]{ActionEvent.class};
    private static final Class[] VALUE_CHANGE_LISTENER_ARGS = new Class[]{ValueChangeEvent.class};
    private static final Class[] VALIDATOR_ARGS = new Class[]{FacesContext.class, UIComponent.class, Object.class};

    private ComponentUtil() {
    }

    public static UIPage findPage(UIComponent component) {
        while (component != null) {
            if (component instanceof UIPage) {
                return (UIPage)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static void addStyles(UIComponent component, String[] styles) {
        UIPage uiPage = ComponentUtil.findPage(component);
        for (String style : styles) {
            uiPage.getStyleFiles().add(style);
        }
    }

    public static void addScripts(UIComponent component, String[] scripts) {
        UIPage uiPage = ComponentUtil.findPage(component);
        for (String script : scripts) {
            uiPage.getScriptFiles().add(script);
        }
    }

    public static void addOnloadCommands(UIComponent component, String[] cmds) {
        UIPage uiPage = ComponentUtil.findPage(component);
        for (String cmd : cmds) {
            uiPage.getOnloadScripts().add(cmd);
        }
    }

    public static UIPage findPage(FacesContext facesContext) {
        return ComponentUtil.findPageBreadthFirst((UIComponent)facesContext.getViewRoot());
    }

    private static UIPage findPageBreadthFirst(UIComponent component) {
        UIComponent child;
        for (Object o : component.getChildren()) {
            child = (UIComponent)o;
            if (!(child instanceof UIPage)) continue;
            return (UIPage)child;
        }
        for (Object o : component.getChildren()) {
            child = (UIComponent)o;
            UIPage result = ComponentUtil.findPageBreadthFirst(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static UIForm findForm(UIComponent component) {
        while (component != null) {
            if (component instanceof UIForm) {
                return (UIForm)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static List<UIForm> findSubForms(UIComponent component) {
        ArrayList<UIForm> collect = new ArrayList<UIForm>();
        ComponentUtil.findSubForms(collect, component);
        return collect;
    }

    private static void findSubForms(List<UIForm> collect, UIComponent component) {
        List children = component.getChildren();
        for (UIComponent child : children) {
            if (child instanceof UIForm) {
                collect.add((UIForm)child);
                continue;
            }
            ComponentUtil.findSubForms(collect, child);
        }
    }

    public static String findClientIdFor(UIComponent component, FacesContext facesContext) {
        UIComponent forComponent = ComponentUtil.findFor(component);
        if (forComponent != null) {
            String clientId = forComponent.getClientId(facesContext);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("found clientId: '" + clientId + "'"));
            }
            return clientId;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"found no clientId");
        }
        return null;
    }

    public static UIComponent findFor(UIComponent component) {
        String forValue = (String)component.getAttributes().get("for");
        if (forValue == null) {
            return component.getParent();
        }
        return component.findComponent(forValue);
    }

    public static boolean isInActiveForm(UIComponent component) {
        while (component != null) {
            UIForm form;
            if (component instanceof UIForm && (form = (UIForm)component).isSubmitted()) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    public static boolean isError(UIComponent component) {
        if (component instanceof EditableValueHolder) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Iterator messages = facesContext.getMessages(component.getClientId(facesContext));
            return !((EditableValueHolder)component).isValid() || messages.hasNext();
        }
        return false;
    }

    public static boolean isOutputOnly(UIComponent component) {
        return ComponentUtil.getBooleanAttribute(component, "disabled") || ComponentUtil.getBooleanAttribute(component, "readonly");
    }

    public static boolean mayValidate(UIComponent component) {
        return !ComponentUtil.isOutputOnly(component) && ComponentUtil.isInActiveForm(component);
    }

    public static boolean mayUpdateModel(UIComponent component) {
        return ComponentUtil.mayValidate(component);
    }

    public static boolean getBooleanAttribute(UIComponent component, String name) {
        Object bool = component.getAttributes().get(name);
        if (bool == null) {
            return false;
        }
        if (bool instanceof ValueBinding) {
            bool = ((ValueBinding)bool).getValue(FacesContext.getCurrentInstance());
        }
        if (bool instanceof Boolean) {
            return (Boolean)bool;
        }
        if (bool instanceof String) {
            LOG.warn((Object)("Searching for a boolean, but find a String. Should not happen. attribute: '" + name + "' comp: '" + component + "'"));
            return Boolean.getBoolean((String)bool);
        }
        LOG.warn((Object)("Unknown type '" + bool.getClass().getName() + "' for boolean attribute: " + name + " comp: " + component));
        return false;
    }

    public static Object getAttribute(UIComponent component, String name) {
        Object value = component.getAttributes().get(name);
        if (value instanceof ValueBinding) {
            value = ((ValueBinding)value).getValue(FacesContext.getCurrentInstance());
        }
        return value;
    }

    public static String getStringAttribute(UIComponent component, String name) {
        return (String)ComponentUtil.getAttribute(component, name);
    }

    public static int getIntAttribute(UIComponent component, String name) {
        return ComponentUtil.getIntAttribute(component, name, 0);
    }

    public static int getIntAttribute(UIComponent component, String name, int defaultValue) {
        Object integer = component.getAttributes().get(name);
        if (integer instanceof Number) {
            return ((Number)integer).intValue();
        }
        if (integer instanceof String) {
            try {
                return Integer.parseInt((String)integer);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Can't parse number from string : \"" + integer + "\"!"));
                return defaultValue;
            }
        }
        if (integer == null) {
            return defaultValue;
        }
        LOG.warn((Object)("Unknown type '" + integer.getClass().getName() + "' for integer attribute: " + name + " comp: " + component));
        return defaultValue;
    }

    public static Character getCharakterAttribute(UIComponent component, String name) {
        Object charakter = component.getAttributes().get(name);
        if (charakter == null) {
            return null;
        }
        if (charakter instanceof Character) {
            return (Character)charakter;
        }
        if (charakter instanceof String) {
            String asString = (String)charakter;
            return asString.length() > 0 ? new Character(asString.charAt(0)) : null;
        }
        LOG.warn((Object)("Unknown type '" + charakter.getClass().getName() + "' for integer attribute: " + name + " comp: " + component));
        return null;
    }

    public static boolean isFacetOf(UIComponent component, UIComponent parent) {
        for (Object o : parent.getFacets().keySet()) {
            UIComponent facet = parent.getFacet((String)o);
            if (!component.equals(facet)) continue;
            return true;
        }
        return false;
    }

    public static RendererBase getRenderer(FacesContext facesContext, UIComponent component) {
        return ComponentUtil.getRenderer(facesContext, component.getFamily(), component.getRendererType());
    }

    public static RendererBase getRenderer(FacesContext facesContext, String family, String rendererType) {
        if (rendererType == null) {
            return null;
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        RendererBase renderer = (RendererBase)requestMap.get(RENDER_KEY_PREFIX + rendererType);
        if (renderer == null) {
            RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            RenderKit renderKit = rkFactory.getRenderKit(facesContext, facesContext.getViewRoot().getRenderKitId());
            renderer = (RendererBase)renderKit.getRenderer(family, rendererType);
            requestMap.put(RENDER_KEY_PREFIX + rendererType, renderer);
        }
        return renderer;
    }

    public static String currentValue(UIComponent component) {
        String currentValue = null;
        if (component instanceof ValueHolder) {
            Object value;
            if (component instanceof EditableValueHolder && (value = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return (String)value;
            }
            value = ((ValueHolder)component).getValue();
            if (value != null) {
                Converter converter = ((ValueHolder)component).getConverter();
                if (converter == null) {
                    FacesContext context = FacesContext.getCurrentInstance();
                    converter = context.getApplication().createConverter(value.getClass());
                }
                currentValue = converter != null ? converter.getAsString(FacesContext.getCurrentInstance(), component, value) : value.toString();
            }
        }
        return currentValue;
    }

    public static List<SelectItem> getSelectItems(UIComponent component) {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        for (Object o1 : component.getChildren()) {
            Object value;
            UIComponent kid = (UIComponent)o1;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("kid " + kid));
                LOG.debug((Object)("kid " + kid.getClass().getName()));
            }
            if (kid instanceof javax.faces.component.UISelectItem) {
                value = ((javax.faces.component.UISelectItem)kid).getValue();
                if (value == null) {
                    javax.faces.component.UISelectItem item = (javax.faces.component.UISelectItem)kid;
                    if (kid instanceof UISelectItem) {
                        list.add(new org.apache.myfaces.tobago.model.SelectItem((UISelectItem)kid));
                        continue;
                    }
                    list.add(new SelectItem(item.getItemValue() == null ? "" : item.getItemValue(), item.getItemLabel(), item.getItemDescription()));
                    continue;
                }
                if (value instanceof SelectItem) {
                    list.add((SelectItem)value);
                    continue;
                }
                throw new IllegalArgumentException("TYPE ERROR: value NOT instanceof SelectItem. type=" + value.getClass().getName());
            }
            if (!(kid instanceof UISelectItems)) continue;
            value = ((UISelectItems)kid).getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("value " + value));
                if (value != null) {
                    LOG.debug((Object)("value " + value.getClass().getName()));
                }
            }
            if (value == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)"value is null");
                continue;
            }
            if (value instanceof SelectItem) {
                list.add((SelectItem)value);
                continue;
            }
            if (value instanceof SelectItem[]) {
                SelectItem[] items;
                for (SelectItem item : items = (SelectItem[])value) {
                    list.add(item);
                }
                continue;
            }
            if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    list.add((SelectItem)o);
                }
                continue;
            }
            if (value instanceof Map) {
                for (Object key : ((Map)value).keySet()) {
                    Object val;
                    if (key == null || (val = ((Map)value).get(key)) == null) continue;
                    list.add(new SelectItem((Object)val.toString(), key.toString(), null));
                }
                continue;
            }
            throw new IllegalArgumentException("TYPE ERROR: value NOT instanceof SelectItem, SelectItem[], Collection, Map. type=" + value.getClass().getName());
        }
        return list;
    }

    public static Object findParameter(UIComponent component, String name) {
        for (Object o : component.getChildren()) {
            UIComponent child = (UIComponent)o;
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Select name='" + parameter.getName() + "'"));
                LOG.debug((Object)("Select value='" + parameter.getValue() + "'"));
            }
            if (!name.equals(parameter.getName())) continue;
            return parameter.getValue();
        }
        return null;
    }

    public static String toString(UIComponent component, int offset) {
        return ComponentUtil.toString(component, offset, false);
    }

    private static String toString(UIComponent component, int offset, boolean asFacet) {
        StringBuffer result = new StringBuffer();
        if (component == null) {
            result.append("null");
        } else {
            Map facets;
            result.append('\n');
            if (!asFacet) {
                result.append(ComponentUtil.spaces(offset));
                result.append(ComponentUtil.toString(component));
            }
            if ((facets = component.getFacets()).size() > 0) {
                for (Object name : facets.keySet()) {
                    UIComponent facet = (UIComponent)facets.get(name);
                    result.append('\n');
                    result.append(ComponentUtil.spaces(offset + 1));
                    result.append('\"');
                    result.append(name);
                    result.append("\" = ");
                    result.append(ComponentUtil.toString(facet));
                    result.append(ComponentUtil.toString(facet, offset + 1, true));
                }
            }
            for (Object o : component.getChildren()) {
                result.append(ComponentUtil.toString((UIComponent)o, offset + 1, false));
            }
        }
        return result.toString();
    }

    private static String toString(UIComponent component) {
        StringBuffer buf = new StringBuffer(component.getClass().getName());
        buf.append('@');
        buf.append(Integer.toHexString(component.hashCode()));
        buf.append(" ");
        buf.append(component.getRendererType());
        buf.append(" ");
        if (component instanceof UIViewRoot) {
            buf.append(((UIViewRoot)component).getViewId());
        } else {
            buf.append(component.getId());
            buf.append(" ");
            buf.append(component.getClientId(FacesContext.getCurrentInstance()));
        }
        return buf.toString();
    }

    private static String spaces(int n) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            buffer.append("  ");
        }
        return buffer.toString();
    }

    public static ActionListener createActionListener(String type) throws JspException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = type.getClass().getClassLoader();
            }
            Class<?> clazz = classLoader.loadClass(type);
            return (ActionListener)clazz.newInstance();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("type=" + type), (Throwable)e);
            }
            throw new JspException((Throwable)e);
        }
    }

    public static UIGraphic getFirstGraphicChild(UIComponent component) {
        UIGraphic graphic = null;
        for (Object o : component.getChildren()) {
            UIComponent uiComponent = (UIComponent)o;
            if (!(uiComponent instanceof UIGraphic)) continue;
            graphic = (UIGraphic)uiComponent;
            break;
        }
        return graphic;
    }

    public static boolean isHoverEnabled(UIComponent component) {
        return ComponentUtil.getBooleanAttribute(component, "hover");
    }

    public static UIOutput getFirstNonGraphicChild(UIComponent component) {
        UIOutput output = null;
        for (Object o : component.getChildren()) {
            UIComponent uiComponent = (UIComponent)o;
            if (!(uiComponent instanceof UIOutput) || uiComponent instanceof UIGraphic) continue;
            output = (UIOutput)uiComponent;
            break;
        }
        return output;
    }

    public static void setIntegerProperty(UIComponent component, String name, String value) {
        if (value != null) {
            if (UIComponentTag.isValueReference((String)value)) {
                component.setValueBinding(name, ComponentUtil.createValueBinding(value));
            } else {
                component.getAttributes().put(name, new Integer(value));
            }
        }
    }

    public static void setBooleanProperty(UIComponent component, String name, String value) {
        if (value != null) {
            if (UIComponentTag.isValueReference((String)value)) {
                component.setValueBinding(name, ComponentUtil.createValueBinding(value));
            } else {
                component.getAttributes().put(name, Boolean.valueOf(value));
            }
        }
    }

    public static void setStringProperty(UIComponent component, String name, String value) {
        if (value != null) {
            if (UIComponentTag.isValueReference((String)value)) {
                component.setValueBinding(name, ComponentUtil.createValueBinding(value));
            } else {
                component.getAttributes().put(name, value);
            }
        }
    }

    public static void setValueForValueBinding(String name, Object value) {
        FacesContext context = FacesContext.getCurrentInstance();
        ValueBinding valueBinding = context.getApplication().createValueBinding(name);
        valueBinding.setValue(context, value);
    }

    public static ValueBinding createValueBinding(String value) {
        return FacesContext.getCurrentInstance().getApplication().createValueBinding(value);
    }

    public static String getValueFromEl(String script) {
        if (UIComponentTag.isValueReference((String)script)) {
            ValueBinding valueBinding = ComponentUtil.createValueBinding(script);
            script = (String)valueBinding.getValue(FacesContext.getCurrentInstance());
        }
        return script;
    }

    public static UIComponent createComponent(String componentType, String rendererType) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return ComponentUtil.createComponent(facesContext, componentType, rendererType);
    }

    public static UIComponent createComponent(FacesContext facesContext, String componentType, String rendererType) {
        UIComponent component = facesContext.getApplication().createComponent(componentType);
        component.setRendererType(rendererType);
        return component;
    }

    public static UIColumn createTextColumn(String label, String sortable, String align, String value) {
        UIComponent text = ComponentUtil.createComponent("javax.faces.Output", "Out");
        ComponentUtil.setStringProperty(text, "value", value);
        ComponentUtil.setBooleanProperty(text, "createSpan", "false");
        ComponentUtil.setBooleanProperty(text, "escape", "false");
        return ComponentUtil.createColumn(label, sortable, align, text);
    }

    public static UIColumn createColumn(String label, String sortable, String align, UIComponent child) {
        UIColumn column = ComponentUtil.createColumn(label, sortable, align);
        column.getChildren().add(child);
        return column;
    }

    private static UIColumn createColumn(String label, String sortable, String align) {
        UIColumn column = (UIColumn)ComponentUtil.createComponent("org.apache.myfaces.tobago.Column", null);
        ComponentUtil.setStringProperty((UIComponent)column, "label", label);
        ComponentUtil.setBooleanProperty((UIComponent)column, "sortable", sortable);
        ComponentUtil.setStringProperty((UIComponent)column, "align", align);
        return column;
    }

    public static UIMenuSelectOne createUIMenuSelectOneFacet(FacesContext facesContext, javax.faces.component.UICommand command) {
        UIMenuSelectOne radio = null;
        ValueBinding valueBinding = command.getValueBinding("value");
        if (valueBinding != null) {
            radio = (UIMenuSelectOne)ComponentUtil.createComponent(facesContext, "org.apache.myfaces.tobago.MenuSelectOne", "SelectOneRadio");
            command.getFacets().put("radio", radio);
            radio.setValueBinding("value", valueBinding);
        }
        return radio;
    }

    public static boolean hasSelectedValue(List<SelectItem> items, Object value) {
        for (SelectItem item : items) {
            if (!item.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public static UIComponent createUISelectBooleanFacet(FacesContext facesContext, javax.faces.component.UICommand command) {
        UIComponent checkbox = null;
        ValueBinding valueBinding = command.getValueBinding("value");
        if (valueBinding != null) {
            checkbox = ComponentUtil.createComponent(facesContext, "javax.faces.SelectBoolean", "SelectBooleanCheckbox");
            command.getFacets().put("checkbox", checkbox);
            checkbox.setValueBinding("value", valueBinding);
        }
        return checkbox;
    }

    public static int getIntValue(ValueBinding valueBinding) {
        return ComponentUtil.getAsInt(valueBinding.getValue(FacesContext.getCurrentInstance()));
    }

    private static int getAsInt(Object value) {
        int result;
        if (value instanceof Number) {
            result = ((Number)value).intValue();
        } else if (value instanceof String) {
            result = Integer.parseInt((String)value);
        } else {
            throw new IllegalArgumentException("Can't convert " + value + " to int!");
        }
        return result;
    }

    public static String createPickerId(FacesContext facesContext, UIComponent component, String postfix) {
        String id = ComponentUtil.getComponentId(facesContext, component);
        return id + "_picker" + postfix;
    }

    public static String getComponentId(FacesContext facesContext, UIComponent component) {
        String id = component.getId();
        return id;
    }

    public static UIComponent provideLabel(FacesContext facesContext, UIComponent component) {
        UIComponent label = component.getFacet("label");
        if (label == null) {
            Map attributes = component.getAttributes();
            Object labelText = component.getValueBinding("label");
            if (labelText == null) {
                labelText = attributes.get("label");
            }
            if (labelText != null) {
                Application application = FacesContext.getCurrentInstance().getApplication();
                label = application.createComponent("javax.faces.Output");
                label.setRendererType("Label");
                String idprefix = ComponentUtil.getComponentId(facesContext, component);
                label.setId(idprefix + "_" + "label");
                label.setRendered(true);
                if (labelText instanceof ValueBinding) {
                    label.setValueBinding("value", labelText);
                } else if (labelText != null) {
                    label.getAttributes().put("value", labelText);
                }
                component.getFacets().put("label", label);
            }
        }
        return label;
    }

    public static List<SelectItem> getItemsToRender(UISelectOne component) {
        return ComponentUtil.getItems((javax.faces.component.UIInput)component);
    }

    public static List<SelectItem> getItemsToRender(UISelectMany component) {
        return ComponentUtil.getItems((javax.faces.component.UIInput)component);
    }

    private static List<SelectItem> getItems(javax.faces.component.UIInput component) {
        List<SelectItem> selectItems = ComponentUtil.getSelectItems((UIComponent)component);
        String renderRange = (String)component.getAttributes().get("renderRangeExtern");
        if (renderRange == null) {
            renderRange = (String)component.getAttributes().get("renderRange");
        }
        if (renderRange == null) {
            return selectItems;
        }
        int[] indices = RangeParser.getIndices(renderRange);
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(indices.length);
        if (selectItems.size() != 0) {
            for (int indice : indices) {
                items.add(selectItems.get(indice));
            }
        } else {
            LOG.warn((Object)"No items found! rendering dummys instead!");
            for (int i = 0; i < indices.length; ++i) {
                items.add(new SelectItem((Object)Integer.toString(i), "Item " + i, ""));
            }
        }
        return items;
    }

    public static void setValidator(EditableValueHolder editableValueHolder, String validator) {
        if (validator != null && editableValueHolder.getValidator() == null && UIComponentTag.isValueReference((String)validator)) {
            MethodBinding methodBinding = FacesContext.getCurrentInstance().getApplication().createMethodBinding(validator, VALIDATOR_ARGS);
            editableValueHolder.setValidator(methodBinding);
        }
    }

    public static void setConverter(UIComponent component, String converter) {
        ValueHolder valueHolder = (ValueHolder)component;
        if (converter != null && valueHolder.getConverter() == null) {
            valueHolder.setConverter(FacesContext.getCurrentInstance().getApplication().createConverter(converter));
        }
    }

    public static void setAction(UIComponent component, String type, String action) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        String commandType = type != null && UIComponentTag.isValueReference((String)type) ? (String)application.createValueBinding(type).getValue(facesContext) : type;
        if (commandType != null && (commandType.equals("navigate") || commandType.equals("reset") || commandType.equals("script"))) {
            if (commandType.equals("navigate")) {
                ComponentUtil.setStringProperty(component, "link", action);
            } else if (commandType.equals("script")) {
                ComponentUtil.setStringProperty(component, "onclick", action);
            } else {
                LOG.warn((Object)"Type reset is not supported");
            }
        } else if (action != null) {
            if (UIComponentTag.isValueReference((String)action)) {
                MethodBinding binding = application.createMethodBinding(action, null);
                ((UICommand)component).setAction(binding);
            } else {
                ((UICommand)component).setAction(new ConstantMethodBinding(action));
            }
        }
    }

    public static void setSuggestMethodBinding(UIComponent component, String suggestMethod) {
        if (suggestMethod != null) {
            if (UIComponentTag.isValueReference((String)suggestMethod)) {
                MethodBinding methodBinding = FacesContext.getCurrentInstance().getApplication().createMethodBinding(suggestMethod, new Class[]{String.class});
                ((UIInput)component).setSuggestMethod(methodBinding);
            } else {
                throw new IllegalArgumentException("Must be a valueReference (suggestMethod): " + suggestMethod);
            }
        }
    }

    public static void setActionListener(ActionSource command, String actionListener) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        if (actionListener != null) {
            if (UIComponentTag.isValueReference((String)actionListener)) {
                MethodBinding binding = application.createMethodBinding(actionListener, ACTION_LISTENER_ARGS);
                command.setActionListener(binding);
            } else {
                throw new IllegalArgumentException("Must be a valueReference (actionListener): " + actionListener);
            }
        }
    }

    public static void setValueChangeListener(EditableValueHolder valueHolder, String valueChangeListener) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        if (valueChangeListener != null) {
            if (UIComponentTag.isValueReference((String)valueChangeListener)) {
                MethodBinding binding = application.createMethodBinding(valueChangeListener, VALUE_CHANGE_LISTENER_ARGS);
                valueHolder.setValueChangeListener(binding);
            } else {
                throw new IllegalArgumentException("Must be a valueReference (valueChangeListener): " + valueChangeListener);
            }
        }
    }

    public static void setSortActionListener(UIData data, String actionListener) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        if (actionListener != null) {
            if (UIComponentTag.isValueReference((String)actionListener)) {
                MethodBinding binding = application.createMethodBinding(actionListener, ACTION_LISTENER_ARGS);
                data.setSortActionListener(binding);
            } else {
                throw new IllegalArgumentException("Must be a valueReference (sortActionListener): " + actionListener);
            }
        }
    }

    public static void setValueBinding(UIComponent component, String name, String state) {
        if (state != null && UIComponentTag.isValueReference((String)state)) {
            ValueBinding valueBinding = ComponentUtil.createValueBinding(state);
            component.setValueBinding(name, valueBinding);
        }
    }

    public static void setStateChangeListener(UIData data, String stateChangeListener) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        if (stateChangeListener != null) {
            if (UIComponentTag.isValueReference((String)stateChangeListener)) {
                Class[] arguments = new Class[]{SheetStateChangeEvent.class};
                MethodBinding binding = application.createMethodBinding(stateChangeListener, arguments);
                data.setStateChangeListener(binding);
            } else {
                throw new IllegalArgumentException("Must be a valueReference (actionListener): " + stateChangeListener);
            }
        }
    }
}

