/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import javax.faces.el.ValueBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.UIData;
import org.apache.myfaces.tobago.event.PageActionEvent;

public class Pager
extends MethodBinding {
    private static final Log LOG = LogFactory.getLog(Pager.class);

    public Class getType(FacesContext facescontext) throws MethodNotFoundException {
        return String.class;
    }

    public Object invoke(FacesContext facesContext, Object[] aobj) throws EvaluationException {
        if (aobj[0] instanceof PageActionEvent) {
            PageActionEvent pageEvent = (PageActionEvent)((Object)aobj[0]);
            UIData sheet = pageEvent.getSheet();
            int first = -1;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("action = '" + pageEvent.getAction().name() + "'"));
            }
            switch (pageEvent.getAction()) {
                case FIRST: {
                    first = 0;
                    break;
                }
                case PREV: {
                    int start = sheet.getFirst() - sheet.getRows();
                    first = start < 0 ? 0 : start;
                    break;
                }
                case NEXT: {
                    if (sheet.hasRowCount()) {
                        int start = sheet.getFirst() + sheet.getRows();
                        first = start > sheet.getRowCount() ? sheet.getLastPageIndex() : start;
                        break;
                    }
                    if (sheet.isAtEnd()) {
                        first = sheet.getFirst();
                        break;
                    }
                    first = sheet.getFirst() + sheet.getRows();
                    break;
                }
                case LAST: {
                    first = sheet.getLastPageIndex();
                    break;
                }
                case TO_ROW: {
                    int start = pageEvent.getValue() - 1;
                    if (start > sheet.getLastPageIndex()) {
                        start = sheet.getLastPageIndex();
                    } else if (start < 0) {
                        start = 0;
                    }
                    first = start;
                    break;
                }
                case TO_PAGE: {
                    int start = pageEvent.getValue() - 1;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("start = " + start + "  sheet.getRows() = " + sheet.getRows() + " => start = " + start * sheet.getRows()));
                    }
                    if ((start *= sheet.getRows()) > sheet.getLastPageIndex()) {
                        start = sheet.getLastPageIndex();
                    } else if (start < 0) {
                        start = 0;
                    }
                    first = start;
                    break;
                }
            }
            ValueBinding valueBinding = sheet.getValueBinding("first");
            if (valueBinding != null) {
                valueBinding.setValue(facesContext, (Object)first);
            } else {
                sheet.setFirst(first);
            }
            sheet.getSheetState(facesContext).setFirst(first);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("aobj[0] instanceof '" + aobj[0] + "'"));
        }
        return null;
    }
}

