/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UIPanel;
import javax.faces.component.UISelectBoolean;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import javax.faces.el.ValueBinding;
import javax.faces.model.DataModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIData;
import org.apache.myfaces.tobago.component.UISelectMany;
import org.apache.myfaces.tobago.component.UISelectOne;
import org.apache.myfaces.tobago.event.SortActionEvent;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.util.BeanComparator;
import org.apache.myfaces.tobago.util.ComparatorBase;
import org.apache.myfaces.tobago.util.ValueBindingComparator;

public class Sorter
extends MethodBinding {
    private static final Log LOG = LogFactory.getLog(Sorter.class);
    private Comparator comparator;

    public Object invoke(FacesContext facesContext, Object[] aobj) throws EvaluationException {
        if (aobj[0] instanceof SortActionEvent) {
            SortActionEvent sortEvent = (SortActionEvent)((Object)aobj[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("sorterId = " + sortEvent.getComponent().getId()));
            }
            UIColumn column = sortEvent.getColumn();
            UIData data = sortEvent.getSheet();
            Object value = data.getValue();
            if (value instanceof DataModel) {
                value = ((DataModel)value).getWrappedData();
            }
            SheetState sheetState = data.getSheetState(facesContext);
            ComparatorBase actualComparator = null;
            if (value instanceof List || value instanceof Object[]) {
                block16: {
                    try {
                        UIComponent child = this.getFirstSortableChild(column.getChildren());
                        if (child != null) {
                            ValueBinding valueBinding = child.getValueBinding("value");
                            String var = data.getVar();
                            if (valueBinding != null) {
                                if (this.isSimpleProperty(valueBinding.getExpressionString())) {
                                    String expressionString = valueBinding.getExpressionString();
                                    if (expressionString.startsWith("#{") && expressionString.endsWith("}")) {
                                        expressionString = expressionString.substring(2, expressionString.length() - 1);
                                    }
                                    String sortProperty = expressionString.substring(var.length() + 1);
                                    actualComparator = new BeanComparator(sortProperty, this.comparator, !sheetState.isAscending());
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)("Sort property is " + sortProperty));
                                    }
                                } else {
                                    actualComparator = new ValueBindingComparator(facesContext, var, valueBinding, !sheetState.isAscending(), this.comparator);
                                }
                            }
                            break block16;
                        }
                        LOG.error((Object)"No sortable component found!");
                        this.removeSortableAttribute(column);
                        return null;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error while extracting sortMethod :" + e.getMessage()), (Throwable)e);
                        if (column != null) {
                            this.removeSortableAttribute(column);
                        }
                        return null;
                    }
                }
                if (value instanceof List) {
                    Collections.sort((List)value, actualComparator);
                } else {
                    Arrays.sort((Object[])value, actualComparator);
                }
            } else {
                LOG.warn((Object)("Sorting not supported for type " + (value != null ? value.getClass().toString() : "null")));
            }
        }
        return null;
    }

    private boolean isSimpleProperty(String expressionString) {
        return expressionString.matches("^#\\{(\\w+(\\.\\w)*)\\}$");
    }

    private void removeSortableAttribute(UIColumn uiColumn) {
        LOG.warn((Object)("removing attribute sortable from column " + uiColumn.getId()));
        uiColumn.getAttributes().remove("sortable");
    }

    private UIComponent getFirstSortableChild(List children) {
        UIComponent child2 = null;
        for (UIComponent child2 : children) {
            if (child2 instanceof UICommand || child2 instanceof UIPanel) {
                child2 = this.getFirstSortableChild(child2.getChildren());
            }
            if (child2 instanceof UISelectMany || child2 instanceof UISelectOne || child2 instanceof UISelectBoolean || child2 instanceof UIInput && "Hidden".equals(child2.getRendererType()) || !(child2 instanceof UIOutput)) continue;
            break;
        }
        return child2;
    }

    public Class getType(FacesContext facescontext) throws MethodNotFoundException {
        return String.class;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }
}

