/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxComponent;
import org.apache.myfaces.tobago.ajax.api.AjaxUtils;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.Pager;
import org.apache.myfaces.tobago.component.Sorter;
import org.apache.myfaces.tobago.component.UIColumnSelector;
import org.apache.myfaces.tobago.component.UILayout;
import org.apache.myfaces.tobago.event.PageActionEvent;
import org.apache.myfaces.tobago.event.SheetStateChangeEvent;
import org.apache.myfaces.tobago.event.SheetStateChangeListener;
import org.apache.myfaces.tobago.event.SheetStateChangeSource;
import org.apache.myfaces.tobago.event.SortActionEvent;
import org.apache.myfaces.tobago.event.SortActionSource;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.SheetRendererWorkaround;
import org.apache.myfaces.tobago.util.LayoutInfo;
import org.apache.myfaces.tobago.util.LayoutUtil;
import org.apache.myfaces.tobago.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIData
extends javax.faces.component.UIData
implements SheetStateChangeSource,
SortActionSource,
AjaxComponent {
    private static final Log LOG = LogFactory.getLog(UIData.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Data";
    public static final String FACET_SORTER = "sorter";
    public static final String SORTER_ID = "sorter";
    public static final String NONE = "none";
    public static final int DEFAULT_DIRECT_LINK_COUNT = 9;
    private MethodBinding stateChangeListener;
    private List<Integer> widthList;
    private MethodBinding sortActionListener;
    private SheetState sheetState;
    private Boolean showHeader;
    private String showRowRange;
    private String showPageRange;
    private String showDirectLinks;
    private Integer directLinkCount;

    public void encodeBegin(FacesContext facesContext) throws IOException {
        UILayout.prepareDimension(facesContext, (UIComponent)this);
        SheetState state = this.getSheetState(facesContext);
        if (state.getFirst() > -1 && state.getFirst() < this.getRowCount()) {
            ValueBinding valueBinding = this.getValueBinding("first");
            if (valueBinding != null) {
                valueBinding.setValue(facesContext, (Object)state.getFirst());
            } else {
                this.setFirst(state.getFirst());
            }
        }
        super.encodeBegin(facesContext);
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        this.setupState(facesContext);
        this.prepareDimensions(facesContext);
        super.encodeEnd(facesContext);
    }

    public String getShowRowRange() {
        if (this.showRowRange != null) {
            return this.showRowRange;
        }
        ValueBinding vb = this.getValueBinding("showRowRange");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return NONE;
    }

    public void setShowRowRange(String showRowRange) {
        this.showRowRange = showRowRange;
    }

    public String getShowPageRange() {
        if (this.showPageRange != null) {
            return this.showPageRange;
        }
        ValueBinding vb = this.getValueBinding("showPageRange");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return NONE;
    }

    public void setShowPageRange(String showPageRange) {
        this.showPageRange = showPageRange;
    }

    public String getShowDirectLinks() {
        if (this.showDirectLinks != null) {
            return this.showDirectLinks;
        }
        ValueBinding vb = this.getValueBinding("showDirectLinks");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return NONE;
    }

    public void setShowDirectLinks(String showDirectLinks) {
        this.showDirectLinks = showDirectLinks;
    }

    public Integer getDirectLinkCount() {
        if (this.directLinkCount != null) {
            return this.directLinkCount;
        }
        ValueBinding vb = this.getValueBinding("directLinkCount");
        if (vb != null) {
            return (Integer)vb.getValue(this.getFacesContext());
        }
        return 9;
    }

    public void setDirectLinkCount(Integer directLinkCount) {
        this.directLinkCount = directLinkCount;
    }

    private void setupState(FacesContext facesContext) {
        SheetState state = this.getSheetState(facesContext);
        this.ensureColumnWidthList(facesContext, state);
    }

    public void setState(SheetState state) {
        this.sheetState = state;
    }

    public SheetState getSheetState(FacesContext facesContext) {
        if (this.sheetState != null) {
            return this.sheetState;
        }
        ValueBinding stateBinding = this.getValueBinding("state");
        if (stateBinding != null) {
            SheetState state = (SheetState)stateBinding.getValue(facesContext);
            if (state == null) {
                state = new SheetState();
                stateBinding.setValue(facesContext, (Object)state);
            }
            return state;
        }
        this.sheetState = new SheetState();
        return this.sheetState;
    }

    private void ensureColumnWidthList(FacesContext facesContext, SheetState state) {
        List<Integer> currrentWidthList = null;
        List<UIColumn> columns = this.getRendererdColumns();
        Map attributes = this.getAttributes();
        String widthListString = null;
        if (state != null) {
            widthListString = state.getColumnWidths();
        }
        if (widthListString == null) {
            widthListString = (String)attributes.get("widthListString");
        }
        if (widthListString != null) {
            currrentWidthList = StringUtil.parseIntegerList(widthListString);
        }
        if (currrentWidthList != null && currrentWidthList.size() != columns.size()) {
            currrentWidthList = null;
        }
        if (currrentWidthList == null) {
            String[] layoutTokens;
            String columnLayout = (String)attributes.get("columns");
            List<UIColumn> allColumns = this.getAllColumns();
            if (columnLayout == null && allColumns.size() > 0) {
                StringBuffer sb = new StringBuffer();
                for (UIColumn allColumn : allColumns) {
                    sb.append("1*;");
                }
                columnLayout = sb.deleteCharAt(sb.lastIndexOf(";")).toString();
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("No columns found! Using created layout tokens: " + columnLayout));
                }
            }
            if ((layoutTokens = LayoutInfo.createLayoutTokens(columnLayout, allColumns.size(), "1*")).length != allColumns.size()) {
                LOG.warn((Object)"Count of columnLayout tokens != count of columns! Using default token '1*' for all columns");
                layoutTokens = LayoutInfo.createLayoutTokens(null, allColumns.size(), "1*");
            }
            boolean changed = false;
            for (int i = 0; i < layoutTokens.length; ++i) {
                if (allColumns.get(i).isRendered()) continue;
                layoutTokens[i] = null;
                changed = true;
            }
            if (changed) {
                String[] allTokens = layoutTokens;
                layoutTokens = new String[columns.size()];
                int j = 0;
                for (String allToken : allTokens) {
                    if (allToken == null) continue;
                    layoutTokens[j] = allToken;
                    ++j;
                }
            }
            int space = LayoutUtil.getInnerSpace(facesContext, (UIComponent)this, true);
            SheetRendererWorkaround renderer = (SheetRendererWorkaround)((Object)ComponentUtil.getRenderer(facesContext, (UIComponent)this));
            space -= renderer.getContentBorder(facesContext, this);
            if (renderer.needVerticalScrollbar(facesContext, this)) {
                space -= renderer.getScrollbarWidth(facesContext, (UIComponent)this);
            }
            LayoutInfo layoutInfo = new LayoutInfo(this.getRendererdColumns().size(), space, layoutTokens, false);
            this.parseFixedWidth(facesContext, layoutInfo);
            layoutInfo.parseColumnLayout(space);
            currrentWidthList = layoutInfo.getSpaceList();
        }
        if (currrentWidthList != null) {
            if (columns.size() != currrentWidthList.size()) {
                LOG.warn((Object)("widthList.size() = " + currrentWidthList.size() + " != columns.size() = " + columns.size() + "  widthList : " + LayoutInfo.listToTokenString(currrentWidthList)));
            } else {
                this.widthList = currrentWidthList;
            }
        }
    }

    private void parseFixedWidth(FacesContext facesContext, LayoutInfo layoutInfo) {
        String[] tokens = layoutInfo.getLayoutTokens();
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].equals("fixed")) continue;
            int width = 0;
            List<UIColumn> columns = this.getRendererdColumns();
            if (!columns.isEmpty()) {
                if (i < columns.size()) {
                    UIColumn column = columns.get(i);
                    if (column instanceof UIColumnSelector) {
                        RendererBase renderer = ComponentUtil.getRenderer(facesContext, (UIComponent)column);
                        if (renderer == null) {
                            LOG.warn((Object)("can't find renderer for " + column.getClass().getName()));
                            renderer = ComponentUtil.getRenderer(facesContext, "javax.faces.Panel", "Out");
                        }
                        width = renderer.getFixedWidth(facesContext, (UIComponent)column);
                    } else {
                        for (UIComponent component : column.getChildren()) {
                            RendererBase renderer = ComponentUtil.getRenderer(facesContext, component);
                            width += renderer.getFixedWidth(facesContext, component);
                        }
                    }
                    layoutInfo.update(width, i);
                } else {
                    layoutInfo.update(0, i);
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)"More LayoutTokens found than rows! skipping!");
                    }
                }
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("set column " + i + " from fixed to with " + width));
        }
    }

    private void prepareDimensions(FacesContext facesContext) {
        List<Integer> columnWidths = this.getWidthList();
        int i = 0;
        for (UIColumn column : this.getRendererdColumns()) {
            if (i < columnWidths.size()) {
                Integer width = columnWidths.get(i);
                if (!(column instanceof UIColumnSelector)) {
                    if (column.getChildCount() == 1) {
                        UIComponent child = (UIComponent)column.getChildren().get(0);
                        int cellPaddingWidth = ((RendererBase)this.getRenderer(facesContext)).getConfiguredValue(facesContext, (UIComponent)this, "cellPaddingWidth");
                        child.getAttributes().put("layoutWidth", width - cellPaddingWidth);
                        child.getAttributes().remove("innerWidth");
                    } else {
                        LOG.warn((Object)("More or less than 1 child in column! Can't set width for column " + i + " to " + width));
                    }
                }
            } else {
                LOG.warn((Object)("More columns than columnSizes! Can't set width for column " + i));
            }
            ++i;
        }
    }

    public int getLast() {
        int last = this.getFirst() + this.getRows();
        return last < this.getRowCount() ? last : this.getRowCount();
    }

    public int getPage() {
        int rows;
        int first = this.getFirst() + 1;
        if (first % (rows = this.getRows()) > 0) {
            return first / rows + 1;
        }
        return first / rows;
    }

    public int getPages() {
        return this.getRowCount() / this.getRows() + (this.getRowCount() % this.getRows() == 0 ? 0 : 1);
    }

    public List<UIComponent> getRenderedChildrenOf(UIColumn column) {
        ArrayList<UIComponent> children = new ArrayList<UIComponent>();
        for (Object o : column.getChildren()) {
            UIComponent kid = (UIComponent)o;
            if (!kid.isRendered()) continue;
            children.add(kid);
        }
        return children;
    }

    public boolean isAtBeginning() {
        return this.getFirst() == 0;
    }

    public boolean hasRowCount() {
        return this.getRowCount() != -1;
    }

    public boolean isAtEnd() {
        if (!this.hasRowCount()) {
            this.setRowIndex(this.getFirst() + this.getRows() + 1);
            return !this.isRowAvailable();
        }
        return this.getFirst() >= this.getLastPageIndex();
    }

    public int getLastPageIndex() {
        int tail = this.getRowCount() % this.getRows();
        return this.getRowCount() - (tail != 0 ? tail : this.getRows());
    }

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        this.updateSheetState(context);
    }

    private void updateSheetState(FacesContext facesContext) {
        SheetState state = this.getSheetState(facesContext);
        if (state != null) {
            state.setSelectedRows((List)this.getAttributes().get("selectedListString"));
            state.setColumnWidths((String)this.getAttributes().get("widthListString"));
        }
    }

    public Object saveState(FacesContext context) {
        Object[] saveState = new Object[]{super.saveState(context), this.sheetState, UIData.saveAttachedState((FacesContext)context, (Object)this.sortActionListener), UIData.saveAttachedState((FacesContext)context, (Object)this.stateChangeListener), this.showHeader, this.showRowRange, this.showPageRange, this.showDirectLinks, this.directLinkCount};
        return saveState;
    }

    public void restoreState(FacesContext context, Object savedState) {
        Object[] values = (Object[])savedState;
        super.restoreState(context, values[0]);
        this.sheetState = (SheetState)values[1];
        this.sortActionListener = (MethodBinding)UIData.restoreAttachedState((FacesContext)context, (Object)values[2]);
        this.stateChangeListener = (MethodBinding)UIData.restoreAttachedState((FacesContext)context, (Object)values[3]);
        this.showHeader = (Boolean)values[4];
        this.showRowRange = (String)values[5];
        this.showPageRange = (String)values[6];
        this.showDirectLinks = (String)values[7];
        this.directLinkCount = (Integer)values[8];
    }

    public List<UIColumn> getAllColumns() {
        ArrayList<UIColumn> columns = new ArrayList<UIColumn>();
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof UIColumn)) continue;
            columns.add((UIColumn)kid);
        }
        return columns;
    }

    public List<UIColumn> getRendererdColumns() {
        ArrayList<UIColumn> columns = new ArrayList<UIColumn>();
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof UIColumn) || !kid.isRendered()) continue;
            columns.add((UIColumn)kid);
        }
        return columns;
    }

    @Override
    public MethodBinding getSortActionListener() {
        if (this.sortActionListener != null) {
            return this.sortActionListener;
        }
        return new Sorter();
    }

    @Override
    public void setSortActionListener(MethodBinding sortActionListener) {
        this.sortActionListener = sortActionListener;
    }

    public void queueEvent(FacesEvent facesEvent) {
        UIComponent parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("component is not a descendant of a UIViewRoot");
        }
        if (facesEvent.getComponent() == this && (facesEvent instanceof SheetStateChangeEvent || facesEvent instanceof PageActionEvent)) {
            parent.queueEvent(facesEvent);
        } else {
            UIComponent source = facesEvent.getComponent();
            UIComponent sourceParent = source.getParent();
            if (sourceParent.getParent() == this && source.getId() != null && source.getId().endsWith("sorter")) {
                parent.queueEvent((FacesEvent)new SortActionEvent(this, (UIColumn)sourceParent));
            } else {
                super.queueEvent(facesEvent);
            }
        }
    }

    public void broadcast(FacesEvent facesEvent) throws AbortProcessingException {
        super.broadcast(facesEvent);
        if (facesEvent instanceof SheetStateChangeEvent) {
            this.invokeMethodBinding(this.getStateChangeListener(), facesEvent);
        } else if (facesEvent instanceof PageActionEvent) {
            this.invokeMethodBinding(new Pager(), facesEvent);
            this.invokeMethodBinding(this.getStateChangeListener(), new SheetStateChangeEvent((UIComponent)this));
        } else if (facesEvent instanceof SortActionEvent) {
            this.getSheetState(this.getFacesContext()).updateSortState((SortActionEvent)facesEvent);
            this.invokeMethodBinding(this.getSortActionListener(), facesEvent);
        }
    }

    private void invokeMethodBinding(MethodBinding methodBinding, FacesEvent event) {
        if (methodBinding != null && event != null) {
            try {
                Object[] objects = new Object[]{event};
                methodBinding.invoke(this.getFacesContext(), objects);
            }
            catch (EvaluationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof AbortProcessingException) {
                    throw (AbortProcessingException)cause;
                }
                throw e;
            }
        }
    }

    @Override
    public void addStateChangeListener(SheetStateChangeListener listener) {
        this.addFacesListener(listener);
    }

    @Override
    public SheetStateChangeListener[] getStateChangeListeners() {
        return (SheetStateChangeListener[])this.getFacesListeners(SheetStateChangeListener.class);
    }

    @Override
    public void removeStateChangeListener(SheetStateChangeListener listener) {
        this.removeFacesListener(listener);
    }

    @Override
    public MethodBinding getStateChangeListener() {
        return this.stateChangeListener;
    }

    @Override
    public void setStateChangeListener(MethodBinding stateChangeListener) {
        this.stateChangeListener = stateChangeListener;
    }

    public List<Integer> getWidthList() {
        return this.widthList;
    }

    public boolean isShowHeader() {
        if (this.showHeader != null) {
            return this.showHeader;
        }
        ValueBinding vb = this.getValueBinding("showHeader");
        if (vb != null) {
            return !Boolean.FALSE.equals(vb.getValue(this.getFacesContext()));
        }
        return true;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    @Override
    public void encodeAjax(FacesContext facesContext) throws IOException {
        this.setupState(facesContext);
        this.prepareDimensions(facesContext);
        AjaxUtils.encodeAjaxComponent(facesContext, (UIComponent)this);
    }

    @Override
    public void processAjax(FacesContext facesContext) throws IOException {
        String ajaxId = (String)facesContext.getExternalContext().getRequestParameterMap().get("affectedAjaxComponent");
        if (ajaxId.equals(this.getClientId(facesContext))) {
            AjaxUtils.processActiveAjaxComponent(facesContext, (UIComponent)this);
        } else {
            AjaxUtils.processAjaxOnChildren(facesContext, (UIComponent)this);
        }
    }
}

