/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.list.SetUniqueList;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIForm;
import org.apache.myfaces.tobago.component.UIPopup;
import org.apache.myfaces.tobago.model.PageState;
import org.apache.myfaces.tobago.model.PageStateImpl;
import org.apache.myfaces.tobago.webapp.TobagoMultipartFormdataRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIPage
extends UIForm {
    private static final Log LOG = LogFactory.getLog(UIPage.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Page";
    public static final String DEFAULT_STYLE = "style/style.css";
    private String formId;
    private String focusId;
    private String actionId;
    private String defaultActionId;
    private List<KeyValue> postfields;
    private SetUniqueList scriptFiles = SetUniqueList.decorate(new ArrayList());
    private Set<String> scriptBlocks = new ListOrderedSet();
    private Set<String> styleFiles = new ListOrderedSet();
    private Set<String> styleBlocks;
    private Set<String> onloadScripts;
    private Set<String> onunloadScripts;
    private Set<String> onexitScripts;
    private List<UIPopup> popups;

    public UIPage() {
        this.styleFiles.add(DEFAULT_STYLE);
        this.styleBlocks = new ListOrderedSet();
        this.onloadScripts = new ListOrderedSet();
        this.onunloadScripts = new ListOrderedSet();
        this.onexitScripts = new ListOrderedSet();
        this.popups = new ArrayList<UIPopup>();
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        super.encodeBegin(facesContext);
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    public String getFormId(FacesContext facesContext) {
        if (this.formId == null) {
            this.formId = this.getClientId(facesContext) + "::" + "form";
        }
        return this.formId;
    }

    @Override
    public void processDecodes(FacesContext facesContext) {
        String contentType = (String)facesContext.getExternalContext().getRequestHeaderMap().get("content-type");
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            ServletRequest wrappedRequest;
            Object request = facesContext.getExternalContext().getRequest();
            boolean okay = false;
            if (request instanceof TobagoMultipartFormdataRequest) {
                okay = true;
            } else if (request instanceof HttpServletRequestWrapper && (wrappedRequest = ((HttpServletRequestWrapper)request).getRequest()) instanceof TobagoMultipartFormdataRequest) {
                okay = true;
            }
            if (!okay) {
                LOG.error((Object)"Can't process multipart/form-data without TobagoRequest. Please check the web.xml and define a TobagoMultipartFormdataFilter. See documentation for <tc:file>");
                facesContext.addMessage(null, new FacesMessage("An error has occured!"));
            }
        }
        this.decode(facesContext);
        this.setSubmitted(false);
        this.getOnloadScripts().clear();
        this.getOnunloadScripts().clear();
        this.getOnexitScripts().clear();
        this.getScriptBlocks().clear();
        String currentActionId = this.getActionId();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("actionId = '" + currentActionId + "'"));
        }
        if (currentActionId == null) {
            return;
        }
        UIComponent command = null;
        try {
            command = this.findComponent(currentActionId);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        while (command == null && currentActionId.indexOf(58) != -1) {
            currentActionId = StringUtils.substring((String)currentActionId, (int)0, (int)currentActionId.lastIndexOf(58));
            command = this.findComponent(currentActionId);
        }
        UIForm form = ComponentUtil.findForm(command);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)command);
            LOG.debug((Object)form);
            LOG.debug((Object)ComponentUtil.toString((UIComponent)facesContext.getViewRoot(), 0));
            if (form != null) {
                LOG.debug((Object)form.getClientId(facesContext));
            }
        }
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processDecodes(facesContext);
        }
        if (form != null) {
            form.setSubmitted(true);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No form found! Rerender the view.");
            }
            facesContext.renderResponse();
        }
    }

    public List<KeyValue> getPostfields() {
        if (this.postfields == null) {
            this.postfields = new ArrayList<KeyValue>();
        }
        return this.postfields;
    }

    @Override
    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        this.updatePageState(context);
    }

    public void updatePageState(FacesContext facesContext) {
        PageState state = this.getPageState(facesContext);
        if (state != null) {
            this.decodePageState(facesContext, state);
        }
    }

    private void decodePageState(FacesContext facesContext, PageState pageState) {
        String value = null;
        try {
            String name = this.getClientId(facesContext) + "::" + "form-clientDimension";
            value = (String)facesContext.getExternalContext().getRequestParameterMap().get(name);
            StringTokenizer tokenizer = new StringTokenizer(value, ";");
            int width = Integer.parseInt(tokenizer.nextToken());
            int height = Integer.parseInt(tokenizer.nextToken());
            pageState.setClientWidth(width);
            pageState.setClientHeight(height);
        }
        catch (Exception e) {
            LOG.error((Object)("Error in decoding state: value='" + value + "'"), (Throwable)e);
        }
    }

    public PageState getPageState(FacesContext facesContext) {
        ValueBinding stateBinding = this.getValueBinding("state");
        if (stateBinding != null) {
            PageState state = (PageState)stateBinding.getValue(facesContext);
            if (state == null) {
                state = new PageStateImpl();
                stateBinding.setValue(facesContext, (Object)state);
            }
            return state;
        }
        return null;
    }

    public String getFocusId() {
        return this.focusId;
    }

    public void setFocusId(String focusId) {
        this.focusId = focusId;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getDefaultActionId() {
        return this.defaultActionId;
    }

    public void setDefaultActionId(String defaultActionId) {
        this.defaultActionId = defaultActionId;
    }

    public List<String> getScriptFiles() {
        return this.scriptFiles;
    }

    public Set<String> getScriptBlocks() {
        return this.scriptBlocks;
    }

    public Set<String> getStyleFiles() {
        return this.styleFiles;
    }

    public Set<String> getStyleBlocks() {
        return this.styleBlocks;
    }

    public Set<String> getOnloadScripts() {
        return this.onloadScripts;
    }

    public Set<String> getOnunloadScripts() {
        return this.onunloadScripts;
    }

    public Set<String> getOnexitScripts() {
        return this.onexitScripts;
    }

    public List<UIPopup> getPopups() {
        return this.popups;
    }
}

