/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.io.IOException;
import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxComponent;
import org.apache.myfaces.tobago.ajax.api.AjaxUtils;
import org.apache.myfaces.tobago.component.UIPanel;
import org.apache.myfaces.tobago.event.TabChangeListener;
import org.apache.myfaces.tobago.event.TabChangeSource;

public class UITabGroup
extends UIPanel
implements TabChangeSource,
AjaxComponent {
    private static final Log LOG = LogFactory.getLog(UITabGroup.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.TabGroup";
    public static final String RENDERED_INDEX = "org.apache.myfaces.tobago.component.UITabGroup.RENDERED_INDEX";
    private int activeIndex;
    private int renderedIndex;
    private String switchType;
    private MethodBinding tabChangeListener = null;
    public static final String SWITCH_TYPE_CLIENT = "client";
    public static final String SWITCH_TYPE_RELOAD_PAGE = "reloadPage";
    public static final String SWITCH_TYPE_RELOAD_TAB = "reloadTab";

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        Object state;
        ValueBinding stateBinding = this.getValueBinding("state");
        Object object = state = stateBinding != null ? stateBinding.getValue(facesContext) : null;
        if (state instanceof Integer) {
            this.activeIndex = (Integer)state;
        } else if (state != null) {
            LOG.warn((Object)("Illegal class in stateBinding: " + state.getClass().getName()));
        }
        this.setRenderedIndex(this.activeIndex);
        super.encodeBegin(facesContext);
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        this.resetTabLayout();
        super.encodeEnd(facesContext);
    }

    private void resetTabLayout() {
        for (UIPanel tab : this.getTabs()) {
            tab.getAttributes().remove("layoutWidth");
            tab.getAttributes().remove("layoutHeight");
        }
    }

    public UIPanel[] getTabs() {
        ArrayList<UIPanel> tabs = new ArrayList<UIPanel>();
        for (Object o : this.getChildren()) {
            UIComponent kid = (UIComponent)o;
            if (kid instanceof UIPanel) {
                if (!kid.isRendered()) continue;
                tabs.add((UIPanel)kid);
                continue;
            }
            LOG.error((Object)("Invalid component in UITabGroup: " + kid));
        }
        return tabs.toArray(new UIPanel[tabs.size()]);
    }

    public UIPanel getActiveTab() {
        return this.getTabs()[this.activeIndex];
    }

    public void processDecodes(FacesContext context) {
        if (!this.isClientType()) {
            if (context == null) {
                throw new NullPointerException("context");
            }
            if (!this.isRendered()) {
                return;
            }
            UIPanel renderedTab = this.getTabs()[this.getRenderedIndex()];
            renderedTab.processDecodes(context);
            try {
                this.decode(context);
            }
            catch (RuntimeException e) {
                context.renderResponse();
                throw e;
            }
        } else {
            super.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!this.isClientType()) {
            if (context == null) {
                throw new NullPointerException("context");
            }
            if (!this.isRendered()) {
                return;
            }
            UIPanel renderedTab = this.getTabs()[this.getRenderedIndex()];
            renderedTab.processValidators(context);
        } else {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (!this.isClientType()) {
            if (context == null) {
                throw new NullPointerException("context");
            }
            if (!this.isRendered()) {
                return;
            }
            UIPanel renderedTab = this.getTabs()[this.getRenderedIndex()];
            renderedTab.processUpdates(context);
            this.updateState(context);
        } else {
            super.processUpdates(context);
            this.updateState(context);
        }
    }

    public void broadcast(FacesEvent facesEvent) throws AbortProcessingException {
        super.broadcast(facesEvent);
        MethodBinding tabChangeListenerBinding = this.getTabChangeListener();
        if (tabChangeListenerBinding != null) {
            try {
                tabChangeListenerBinding.invoke(this.getFacesContext(), new Object[]{facesEvent});
            }
            catch (EvaluationException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof AbortProcessingException) {
                    throw (AbortProcessingException)cause;
                }
                throw e;
            }
        }
    }

    public void setTabChangeListener(MethodBinding tabStateChangeListener) {
        this.tabChangeListener = tabStateChangeListener;
    }

    public MethodBinding getTabChangeListener() {
        return this.tabChangeListener;
    }

    public void updateState(FacesContext facesContext) {
        ValueBinding stateBinding = this.getValueBinding("state");
        if (stateBinding != null) {
            stateBinding.setValue(facesContext, (Object)this.activeIndex);
        }
    }

    public void addTabChangeListener(TabChangeListener listener) {
        if (LOG.isWarnEnabled() && this.isClientType()) {
            LOG.warn((Object)"Adding TabChangeListener to Client side Tabgroup!");
        }
        this.addFacesListener(listener);
    }

    private boolean isClientType() {
        return this.switchType == null || this.switchType.equals(SWITCH_TYPE_CLIENT);
    }

    public void removeTabChangeListener(TabChangeListener listener) {
        this.removeFacesListener(listener);
    }

    public TabChangeListener[] getTabChangeListeners() {
        return (TabChangeListener[])this.getFacesListeners(TabChangeListener.class);
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.renderedIndex, this.activeIndex, UITabGroup.saveAttachedState((FacesContext)context, (Object)this.tabChangeListener), this.switchType};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.renderedIndex = (Integer)values[1];
        this.activeIndex = (Integer)values[2];
        this.tabChangeListener = (MethodBinding)UITabGroup.restoreAttachedState((FacesContext)context, (Object)values[3]);
        this.switchType = (String)values[4];
    }

    public void encodeAjax(FacesContext facesContext) throws IOException {
        if (this.activeIndex < 0 || this.activeIndex >= this.getTabs().length) {
            Object state;
            LOG.error((Object)"This should never occur! Problem in decoding?");
            ValueBinding stateBinding = this.getValueBinding("state");
            Object object = state = stateBinding != null ? stateBinding.getValue(facesContext) : null;
            if (state instanceof Integer) {
                this.activeIndex = (Integer)state;
            } else if (state != null) {
                LOG.warn((Object)("Illegal class in stateBinding: " + state.getClass().getName()));
            }
        }
        this.setRenderedIndex(this.activeIndex);
        AjaxUtils.encodeAjaxComponent(facesContext, (UIComponent)this);
    }

    public int getActiveIndex() {
        return this.activeIndex;
    }

    public void setActiveIndex(int activeIndex) {
        this.activeIndex = activeIndex;
    }

    private void setRenderedIndex(int index) {
        this.renderedIndex = index;
    }

    public int getRenderedIndex() {
        return this.renderedIndex;
    }

    public String getSwitchType() {
        String value = null;
        if (this.switchType != null) {
            value = this.switchType;
        } else {
            ValueBinding vb = this.getValueBinding("switchType");
            if (vb != null) {
                value = (String)vb.getValue(FacesContext.getCurrentInstance());
            }
        }
        if (SWITCH_TYPE_CLIENT.equals(value) || SWITCH_TYPE_RELOAD_PAGE.equals(value) || SWITCH_TYPE_RELOAD_TAB.equals(value)) {
            return value;
        }
        if (value == null) {
            return SWITCH_TYPE_CLIENT;
        }
        LOG.warn((Object)("Illegal value for attribute switchtype : " + this.switchType + " Using default value " + SWITCH_TYPE_CLIENT));
        return SWITCH_TYPE_CLIENT;
    }

    public void setSwitchType(String switchType) {
        this.switchType = switchType;
    }
}

