/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.component.ActionSource;
import javax.faces.component.NamingContainer;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.model.TreeState;
import org.apache.myfaces.tobago.util.MessageFactory;
import org.apache.myfaces.tobago.util.StringUtil;

public class UITree
extends UIInput
implements NamingContainer,
ActionSource {
    private static final Log LOG = LogFactory.getLog(UITree.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Tree";
    public static final String MESSAGE_NOT_LEAF = "tobago.tree.MESSAGE_NOT_LEAF";
    public static final String SEP = "-";
    public static final String TREE_STATE = "-treeState";
    public static final String SELECT_STATE = "-selectState";
    public static final String MARKER = "-marker";
    public static final String FACET_TREE_NODE_COMMAND = "treeNodeCommand";
    public static final String PARAMETER_TREE_NODE_ID = "treeNodeId";
    public static final String COMMAND_PREFIX = "command";
    public static final String COMMAND_NEW = "new";
    public static final String COMMAND_DELETE = "delete";
    public static final String COMMAND_EDIT = "edit";
    public static final String COMMAND_CUT = "cut";
    public static final String COMMAND_COPY = "copy";
    public static final String COMMAND_PASTE = "paste";
    public static final String COMMAND_MOVE_UP = "moveUp";
    public static final String COMMAND_MOVE_DOWN = "moveDown";
    private Command[] treeCommands = new Command[]{new Command("new"), new Command("delete"), new Command("edit"), new Command("cut"), new Command("copy"), new Command("paste"), new Command("moveUp"), new Command("moveDown")};
    private MethodBinding actionListenerBinding;
    private TreeState treeState;
    private boolean showJunctions = true;
    private boolean showJunctionsSet = false;
    private boolean showIcons = true;
    private boolean showIconsSet = false;
    private boolean showRoot = true;
    private boolean showRootSet = false;
    private boolean showRootJunction = true;
    private boolean showRootJunctionSet = false;

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        MethodBinding binding = this.getActionListener();
        if (binding != null) {
            FacesContext context = this.getFacesContext();
            binding.invoke(context, new Object[]{event});
        }
    }

    public MethodBinding getAction() {
        return null;
    }

    public void setAction(MethodBinding methodBinding) {
    }

    public MethodBinding getActionListener() {
        return this.actionListenerBinding;
    }

    public void setActionListener(MethodBinding actionListener) {
        this.actionListenerBinding = actionListener;
    }

    public void addActionListener(ActionListener actionListener) {
        this.addFacesListener((FacesListener)actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(ActionListener.class);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.removeFacesListener((FacesListener)actionListener);
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        this.recreateTreeNodes();
        if (ComponentUtil.getBooleanAttribute((UIComponent)this, "mutable") && this.getFacet("mutableToolbar") == null && this.getFacet("defaultToolbar") == null) {
            this.createDefaultToolbar(facesContext);
        }
        super.encodeBegin(facesContext);
    }

    public void createDefaultToolbar(FacesContext facesContext) {
        UIComponent toolbar = ComponentUtil.createComponent(facesContext, "javax.faces.Panel", "ToolBar");
        toolbar.getAttributes().put("iconSize", "small");
        toolbar.getAttributes().put("labelPosition", "off");
        ActionListener[] handlers = this.getActionListeners();
        if ((handlers == null || handlers.length == 0) && this.getActionListener() == null) {
            LOG.error((Object)"No actionListener found in tree, so tree editing will not work!");
        }
        Command[] commands = this.getCommands();
        for (int i = 0; i < commands.length; ++i) {
            UICommand command = (UICommand)ComponentUtil.createComponent(facesContext, "javax.faces.Command", "Link");
            toolbar.getChildren().add(command);
            command.setId(commands[i].getCommand());
            for (ActionListener listener : this.getActionListeners()) {
                command.addActionListener(listener);
            }
            command.setActionListener(this.getActionListener());
            command.getAttributes().put("image", "image/tobago.tree." + commands[i].getCommand() + ".gif");
            String title = ResourceManagerUtil.getPropertyNotNull(facesContext, "tobago", "tree" + StringUtil.firstToUpperCase(commands[i].getCommand()));
            command.getAttributes().put("tip", title);
        }
        this.getFacets().put("defaultToolbar", toolbar);
    }

    private void recreateTreeNodes() {
        UITreeNode root = this.getRoot();
        try {
            if (root != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"removing root 1");
                }
                this.getChildren().remove((Object)root);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"removing root 2");
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
        try {
            root = new UITreeNode((UIComponent)this, 0);
            root.createTreeNodes();
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
    }

    public UITreeNode getRoot() {
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof UITreeNode)) continue;
            return (UITreeNode)child;
        }
        return null;
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    public UITreeNode findUITreeNode(UITreeNode node, TreeNode treeNode) {
        UITreeNode uiTreeNode;
        UITreeNode found = null;
        if (node.getTreeNode().equals(treeNode)) {
            return node;
        }
        Iterator iter = node.getChildren().iterator();
        while (iter.hasNext() && (found = this.findUITreeNode(uiTreeNode = (UITreeNode)((Object)iter.next()), treeNode)) == null) {
        }
        return found;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public boolean isSelectableTree() {
        Object selectable = ComponentUtil.getAttribute((UIComponent)this, "selectable");
        return selectable != null && (selectable.equals("multi") || selectable.equals("multiLeafOnly") || selectable.equals("single") || selectable.equals("singleLeafOnly") || selectable.equals("sibling") || selectable.equals("siblingLeafOnly"));
    }

    public void processDecodes(FacesContext facesContext) {
        if (ComponentUtil.isOutputOnly((UIComponent)this)) {
            this.setValid(true);
        } else {
            this.decode(facesContext);
            Iterator i = this.getFacetsAndChildren();
            while (i.hasNext()) {
                UIComponent uiComponent = (UIComponent)i.next();
                uiComponent.processDecodes(facesContext);
            }
        }
    }

    public void validate(FacesContext context) {
        String selectable;
        if (this.isRequired() && this.getState().getSelection().size() == 0) {
            this.setValid(false);
            FacesMessage facesMessage = MessageFactory.createFacesMessage(context, "tobago.SelectOne.MESSAGE_VALUE_REQUIRED", FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), facesMessage);
        }
        if ((selectable = ComponentUtil.getStringAttribute((UIComponent)this, "selectable")) != null && selectable.endsWith("LeafOnly")) {
            Set<DefaultMutableTreeNode> selection = this.getState().getSelection();
            for (DefaultMutableTreeNode node : selection) {
                if (node.isLeaf()) continue;
                FacesMessage facesMessage = MessageFactory.createFacesMessage(context, MESSAGE_NOT_LEAF, FacesMessage.SEVERITY_ERROR);
                context.addMessage(this.getClientId(context), facesMessage);
                break;
            }
        }
        if (this.getValidators() != null) {
            for (Validator validator : this.getValidators()) {
                try {
                    validator.validate(context, (UIComponent)this, null);
                }
                catch (ValidatorException ve) {
                    this.setValid(false);
                    FacesMessage message = ve.getFacesMessage();
                    if (message == null) continue;
                    message.setSeverity(FacesMessage.SEVERITY_ERROR);
                    context.addMessage(this.getClientId(context), message);
                }
            }
        }
    }

    public void updateModel(FacesContext facesContext) {
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), UITree.saveAttachedState((FacesContext)context, (Object)this.actionListenerBinding), this.showJunctionsSet ? Boolean.valueOf(this.showJunctions) : null, this.showIconsSet ? Boolean.valueOf(this.showIcons) : null, this.showRootSet ? Boolean.valueOf(this.showRoot) : null, this.showRootJunctionSet ? Boolean.valueOf(this.showRootJunction) : null};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.actionListenerBinding = (MethodBinding)UITree.restoreAttachedState((FacesContext)context, (Object)values[1]);
        if (values[2] != null) {
            this.showJunctions = (Boolean)values[2];
            this.showJunctionsSet = true;
        }
        if (values[3] != null) {
            this.showIcons = (Boolean)values[3];
            this.showIconsSet = true;
        }
        if (values[4] != null) {
            this.showRoot = (Boolean)values[4];
            this.showRootSet = true;
        }
        if (values[5] != null) {
            this.showRootJunction = (Boolean)values[5];
            this.showRootJunctionSet = true;
        }
    }

    public Command[] getCommands() {
        return this.treeCommands;
    }

    public TreeState getState() {
        if (this.treeState != null) {
            return this.treeState;
        }
        ValueBinding valueBinding = this.getValueBinding("state");
        if (valueBinding != null) {
            return (TreeState)valueBinding.getValue(this.getFacesContext());
        }
        return null;
    }

    public void setState(TreeState state) {
        this.treeState = state;
    }

    public boolean isShowJunctions() {
        if (this.showJunctionsSet) {
            return this.showJunctions;
        }
        ValueBinding vb = this.getValueBinding("showJunctions");
        if (vb != null) {
            return !Boolean.FALSE.equals(vb.getValue(this.getFacesContext()));
        }
        return this.showJunctions;
    }

    public void setShowJunctions(boolean showJunctions) {
        this.showJunctions = showJunctions;
        this.showJunctionsSet = true;
    }

    public boolean isShowIcons() {
        if (this.showIconsSet) {
            return this.showIcons;
        }
        ValueBinding vb = this.getValueBinding("showIcons");
        if (vb != null) {
            return !Boolean.FALSE.equals(vb.getValue(this.getFacesContext()));
        }
        return this.showIcons;
    }

    public void setShowIcons(boolean showIcons) {
        this.showIcons = showIcons;
        this.showIconsSet = true;
    }

    public boolean isShowRoot() {
        if (this.showRootSet) {
            return this.showRoot;
        }
        ValueBinding vb = this.getValueBinding("showRoot");
        if (vb != null) {
            return !Boolean.FALSE.equals(vb.getValue(this.getFacesContext()));
        }
        return this.showRoot;
    }

    public void setShowRoot(boolean showRoot) {
        this.showRoot = showRoot;
        this.showRootSet = true;
    }

    public boolean isShowRootJunction() {
        if (this.showRootJunctionSet) {
            return this.showRootJunction;
        }
        ValueBinding vb = this.getValueBinding("showRootJunction");
        if (vb != null) {
            return !Boolean.FALSE.equals(vb.getValue(this.getFacesContext()));
        }
        return this.showRootJunction;
    }

    public void setShowRootJunction(boolean showRootJunction) {
        this.showRootJunction = showRootJunction;
        this.showRootJunctionSet = true;
    }

    public static class Command
    implements Serializable {
        private String command;

        public Command(String command) {
            this.command = command;
        }

        public String getCommand() {
            return this.command;
        }
    }
}

