/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.UITree;

public class UITreeNode
extends UIInput {
    private static final Log LOG = LogFactory.getLog(UITreeNode.class);
    private static final String SUB_REFERENCE_KEY = "subReferenceKey";

    protected UITreeNode(UIComponent parent, int index) {
        if (parent instanceof UITreeNode) {
            String parentSubReference = ((UITreeNode)parent).getSubReference();
            if (parentSubReference == null) {
                this.getAttributes().put(SUB_REFERENCE_KEY, "childAt[" + index + "]");
            } else {
                this.getAttributes().put(SUB_REFERENCE_KEY, parentSubReference + ".childAt[" + index + "]");
            }
        }
        this.setRendererType("TreeNode");
        parent.getChildren().add(this);
        this.initId();
        this.initName();
    }

    public UITreeNode() {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public String getSubReference() {
        return (String)this.getAttributes().get(SUB_REFERENCE_KEY);
    }

    public DefaultMutableTreeNode getTreeNode() {
        return (DefaultMutableTreeNode)this.getValue();
    }

    public Object getValue() {
        TreeNode value = null;
        UITree root = this.findTreeRoot();
        String subReference = this.getSubReference();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("root         = '" + (Object)((Object)root) + "'"));
            LOG.debug((Object)("subReference = '" + subReference + "'"));
        }
        TreeNode rootNode = (TreeNode)root.getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("rootNode = '" + rootNode + "'"));
        }
        if (rootNode != null) {
            try {
                value = subReference == null ? rootNode : (TreeNode)PropertyUtils.getProperty((Object)rootNode, (String)subReference);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("treeNode     = '" + value + "'"));
                }
            }
            catch (Throwable e) {
                LOG.error((Object)("subReference = '" + subReference + "'"), e);
            }
        }
        return value;
    }

    protected void createTreeNodes() {
        TreeNode node = (TreeNode)this.getValue();
        if (node != null) {
            int childCount = node.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UITreeNode component = new UITreeNode((UIComponent)this, i);
                component.createTreeNodes();
            }
        }
    }

    private void initName() {
        String name = null;
        UITree root = this.findTreeRoot();
        TreeNode treeNode = (TreeNode)this.getValue();
        if (treeNode != null) {
            String nameReference = (String)root.getAttributes().get("nameReference");
            if (nameReference != null) {
                try {
                    name = BeanUtils.getProperty((Object)treeNode, (String)nameReference);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Can't find name over ref='" + nameReference + "' treeNode='" + treeNode + "!"), (Throwable)e);
                }
            }
            if (name == null) {
                name = ((Object)((Object)this)).toString();
            }
            this.getAttributes().put("name", name);
        }
    }

    private void initId() {
        String id = null;
        UITree root = this.findTreeRoot();
        TreeNode treeNode = (TreeNode)this.getValue();
        if (treeNode != null) {
            String idReference = (String)root.getAttributes().get("idReference");
            if (idReference != null) {
                try {
                    id = BeanUtils.getProperty((Object)treeNode, (String)idReference);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Can't find id over ref '" + idReference + "' treeNode='" + treeNode + "!"), (Throwable)e);
                }
            }
            if (id == null) {
                id = "node" + Integer.toString(System.identityHashCode(treeNode));
            }
            this.setId(id);
        }
    }

    public UITree findTreeRoot() {
        UIComponent ancestor;
        for (ancestor = this.getParent(); ancestor != null && ancestor instanceof UITreeNode; ancestor = ancestor.getParent()) {
        }
        if (ancestor instanceof UITree) {
            return (UITree)ancestor;
        }
        return null;
    }

    public void updateModel(FacesContext facesContext) {
    }

    protected Object checkValue(Object currentValue) {
        if (currentValue == null) {
            LOG.error((Object)"currentValue is null");
            currentValue = this.emergencyValue();
        }
        if (!(currentValue instanceof MutableTreeNode)) {
            LOG.error((Object)("currentValue is not valid: '" + currentValue + "'"));
            LOG.error((Object)("currentValue is not of type '" + MutableTreeNode.class.getName() + "': '" + currentValue.getClass().getName() + "'"));
            currentValue = this.emergencyValue();
        }
        return currentValue;
    }

    protected Object emergencyValue() {
        return new DefaultMutableTreeNode("Default");
    }
}

