/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.ResourceManagerImpl;

public class UIViewRoot
extends javax.faces.component.UIViewRoot {
    private ResourceManagerImpl.CacheKey rendererCacheKey;
    private ClientProperties clientProperties;
    public static final int ANY_PHASE_ORDINAL = PhaseId.ANY_PHASE.getOrdinal();
    private List events = null;

    public UIViewRoot() {
        this.updateRendererCachePrefix();
    }

    public ClientProperties getClientProperties() {
        return this.clientProperties;
    }

    public void setClientProperties(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
        this.updateRendererCachePrefix();
    }

    public ResourceManagerImpl.CacheKey getRendererCacheKey() {
        return this.rendererCacheKey;
    }

    public void updateRendererCachePrefix() {
        this.rendererCacheKey = ResourceManagerImpl.getRendererCacheKey(this.clientProperties != null ? this.clientProperties.getId() : "null", this.getLocale());
    }

    public void broadcastEventsForPhase(FacesContext context, PhaseId phaseId) {
        this.broadcastForPhase(phaseId);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        if (this.events == null) {
            this.events = new ArrayList();
        }
        this.events.add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastForPhase(PhaseId phaseId) {
        if (this.events == null) {
            return;
        }
        boolean abort = false;
        int phaseIdOrdinal = phaseId.getOrdinal();
        ListIterator listiterator = this.events.listIterator();
        while (listiterator.hasNext()) {
            FacesEvent event = (FacesEvent)listiterator.next();
            int ordinal = event.getPhaseId().getOrdinal();
            if (ordinal != ANY_PHASE_ORDINAL && ordinal != phaseIdOrdinal) continue;
            UIComponent source = event.getComponent();
            try {
                source.broadcast(event);
            }
            catch (AbortProcessingException e) {
                abort = true;
                break;
            }
            finally {
                try {
                    listiterator.remove();
                }
                catch (ConcurrentModificationException cme) {
                    int eventIndex = listiterator.previousIndex();
                    this.events.remove(eventIndex);
                }
            }
        }
        if (abort) {
            this.clearEvents();
        }
    }

    private void clearEvents() {
        this.events = null;
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        super.processDecodes(context);
        this.broadcastForPhase(PhaseId.APPLY_REQUEST_VALUES);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        super.processValidators(context);
        this.broadcastForPhase(PhaseId.PROCESS_VALIDATIONS);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        super.processUpdates(context);
        this.broadcastForPhase(PhaseId.UPDATE_MODEL_VALUES);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    public void processApplication(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.broadcastForPhase(PhaseId.INVOKE_APPLICATION);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }
}

