/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.config.MappingRule;
import org.apache.myfaces.tobago.context.Theme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TobagoConfig {
    private static final Log LOG = LogFactory.getLog(TobagoConfig.class);
    public static final String TOBAGO_CONFIG = "org.apache.myfaces.tobago.config.TobagoConfig";
    private List<Theme> supportedThemes;
    private List<String> supportedThemeNames = new ArrayList<String>();
    private Theme defaultTheme;
    private String defaultThemeName;
    private Set<String> resourceDirs;
    private List<MappingRule> mappingRules;
    private boolean ajaxEnabled;
    private Map<String, Theme> availableTheme;

    public TobagoConfig() {
        this.supportedThemes = new ArrayList<Theme>();
        this.resourceDirs = new HashSet<String>();
    }

    public void addMappingRule(MappingRule mappingRule) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addMappingRule: {" + mappingRule + "}"));
        }
        if (this.mappingRules == null) {
            this.mappingRules = new ArrayList<MappingRule>();
        }
        this.mappingRules.add(mappingRule);
    }

    public void addSupportedThemeName(String name) {
        this.supportedThemeNames.add(name);
    }

    public void resoveThemes() {
        this.defaultTheme = this.availableTheme.get(this.defaultThemeName);
        this.checkThemeIsAvailable(this.defaultThemeName, this.defaultTheme);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("name = '" + this.defaultThemeName + "'"));
            LOG.debug((Object)("defaultTheme = '" + this.defaultTheme + "'"));
        }
        for (String name : this.supportedThemeNames) {
            Theme theme = this.availableTheme.get(name);
            this.checkThemeIsAvailable(name, theme);
            this.supportedThemes.add(theme);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("name = '" + name + "'"));
            LOG.debug((Object)("supportedThemes.last() = '" + this.supportedThemes.get(this.supportedThemes.size() - 1) + "'"));
        }
    }

    private void checkThemeIsAvailable(String name, Theme theme) {
        if (theme == null) {
            String error = "Theme not found! name: '" + name + "'. " + "Please ensure you have a tobago-theme.xml file in your " + "theme jar. Found the following themes: " + this.availableTheme.keySet();
            LOG.error((Object)error);
            throw new RuntimeException(error);
        }
    }

    public static TobagoConfig getInstance(FacesContext facesContext) {
        return (TobagoConfig)facesContext.getExternalContext().getApplicationMap().get(TOBAGO_CONFIG);
    }

    public MappingRule getMappingRule(String requestUri) {
        Iterator<MappingRule> i = this.getMappingRules();
        while (i.hasNext()) {
            MappingRule rule = i.next();
            if (!rule.getRequestUri().equals(requestUri)) continue;
            return rule;
        }
        return null;
    }

    public Iterator<MappingRule> getMappingRules() {
        if (this.mappingRules == null) {
            List objects = Collections.emptyList();
            return objects.iterator();
        }
        return this.mappingRules.iterator();
    }

    public Theme getTheme(String name) {
        if (name == null) {
            LOG.debug((Object)"searching theme: null");
            return this.defaultTheme;
        }
        if (this.defaultTheme.getName().equals(name)) {
            return this.defaultTheme;
        }
        for (Theme theme : this.supportedThemes) {
            if (!theme.getName().equals(name)) continue;
            return theme;
        }
        LOG.debug((Object)("searching theme '" + name + "' not found. " + "Using default: " + this.defaultTheme));
        return this.defaultTheme;
    }

    public void setDefaultThemeName(String defaultThemeName) {
        this.defaultThemeName = defaultThemeName;
    }

    public List<Theme> getSupportedThemes() {
        return Collections.unmodifiableList(this.supportedThemes);
    }

    public void addResourceDir(String resourceDir) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("adding resourceDir = '" + resourceDir + "'"));
        }
        this.resourceDirs.add(resourceDir);
    }

    public Set<String> getResourceDirs() {
        return this.resourceDirs;
    }

    public boolean isAjaxEnabled() {
        return this.ajaxEnabled;
    }

    public void setAjaxEnabled(String value) {
        this.ajaxEnabled = Boolean.valueOf(value);
    }

    @Deprecated
    public void setLoadThemesFromClasspath(String loadThemesFromClasspath) {
        LOG.warn((Object)"Deprecated: setting load-theme-resources-from-classpath is no longer supported");
    }

    public Theme getDefaultTheme() {
        return this.defaultTheme;
    }

    public void setAvailableThemes(Map<String, Theme> availableTheme) {
        this.availableTheme = availableTheme;
    }
}

