/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.faces.FacesException;
import javax.servlet.ServletContext;
import org.apache.commons.digester.Digester;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.config.Attribute;
import org.apache.myfaces.tobago.config.MappingRule;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.xml.sax.SAXException;

public class TobagoConfigParser {
    private static final Log LOG = LogFactory.getLog(TobagoConfigParser.class);
    private static final String TOBAGO_CONFIG_DTD = "/org/apache/myfaces/tobago/config/tobago-config_1_0.dtd";

    public TobagoConfig parse(ServletContext context) throws IOException, SAXException, FacesException {
        TobagoConfig tobagoConfig = new TobagoConfig();
        Digester digester = new Digester();
        this.configure(tobagoConfig, digester);
        this.parse(context, digester);
        return tobagoConfig;
    }

    private Digester configure(TobagoConfig config, Digester digester) {
        digester.push((Object)config);
        digester.setValidating(true);
        digester.addCallMethod("tobago-config/theme-config/default-theme", "setDefaultThemeName", 0);
        digester.addCallMethod("tobago-config/theme-config/supported-theme", "addSupportedThemeName", 0);
        digester.addObjectCreate("tobago-config/mapping-rule", MappingRule.class);
        digester.addSetNext("tobago-config/mapping-rule", "addMappingRule");
        digester.addCallMethod("tobago-config/mapping-rule/request-uri", "setRequestUri", 0);
        digester.addCallMethod("tobago-config/mapping-rule/forward-uri", "setForwardUri", 0);
        digester.addObjectCreate("tobago-config/mapping-rule/attribute", Attribute.class);
        digester.addSetNext("tobago-config/mapping-rule/attribute", "addAttribute");
        digester.addCallMethod("tobago-config/mapping-rule/attribute/key", "setKey", 0);
        digester.addCallMethod("tobago-config/mapping-rule/attribute/value", "setValue", 0);
        digester.addCallMethod("tobago-config/load-theme-resources-from-classpath", "setLoadThemesFromClasspath", 0);
        digester.addCallMethod("tobago-config/resource-dir", "addResourceDir", 0);
        digester.addCallMethod("tobago-config/ajax-enabled", "setAjaxEnabled", 0);
        return digester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(ServletContext context, Digester digester) throws IOException, SAXException, FacesException {
        block4: {
            String configPath = "/WEB-INF/tobago-config.xml";
            InputStream input = null;
            this.registerDtd(digester);
            try {
                input = context.getResourceAsStream(configPath);
                if (input != null) {
                    digester.parse(input);
                    break block4;
                }
                throw new FacesException("No config file found: '" + configPath + "'. Tobago can't run without configuration.");
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
    }

    private void registerDtd(Digester digester) {
        URL url = this.getClass().getResource(TOBAGO_CONFIG_DTD);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("registering dtd: url=" + url));
        }
        if (null != url) {
            digester.register("-//Atanion GmbH//DTD Tobago Config 1.0//EN", url.toString());
            digester.register("-//The Apache Software Foundation//DTD Tobago Config 1.0//EN", url.toString());
        } else {
            LOG.warn((Object)"unable to retrieve local DTD '/org/apache/myfaces/tobago/config/tobago-config_1_0.dtd'; trying external URL");
        }
    }
}

