/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.context.ResourceManagerFactory;
import org.apache.myfaces.tobago.context.ResourceManagerImpl;
import org.apache.myfaces.tobago.context.ThemeBuilder;
import org.apache.myfaces.tobago.context.ThemeImpl;
import org.apache.myfaces.tobago.context.ThemeParser;
import org.apache.myfaces.tobago.util.XmlUtils;

class ResourceLocator {
    private static final Log LOG = LogFactory.getLog(ResourceLocator.class);
    private ServletContext servletContext;
    private ResourceManagerImpl resourceManager;
    private ThemeBuilder themeBuilder;

    public ResourceLocator(ServletContext servletContext, ResourceManagerImpl resourceManager, ThemeBuilder tobagoConfig) {
        this.servletContext = servletContext;
        this.resourceManager = resourceManager;
        this.themeBuilder = tobagoConfig;
    }

    public void locate() throws ServletException {
        this.locateResourcesInWar(this.servletContext, this.resourceManager, "/");
        this.locateResourcesFromClasspath(this.resourceManager);
    }

    private void locateResourcesInWar(ServletContext servletContext, ResourceManagerImpl resources, String path) throws ServletException {
        Set resourcePaths;
        if (path.startsWith("/WEB-INF/")) {
            return;
        }
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        if ((resourcePaths = servletContext.getResourcePaths(path)) == null || resourcePaths.isEmpty()) {
            LOG.error((Object)("ResourcePath empty! Please check the tobago-config.xml file! path='" + path + "'"));
            return;
        }
        for (String childPath : resourcePaths) {
            InputStream inputStream;
            if (childPath.endsWith("/")) {
                if (childPath.equals(path)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("childPath dir " + childPath));
                }
                this.locateResourcesInWar(servletContext, resources, childPath);
                continue;
            }
            if (childPath.endsWith(".properties")) {
                inputStream = servletContext.getResourceAsStream(childPath);
                this.addProperties(inputStream, resources, childPath, false);
                continue;
            }
            if (childPath.endsWith(".properties.xml")) {
                inputStream = servletContext.getResourceAsStream(childPath);
                this.addProperties(inputStream, resources, childPath, true);
                continue;
            }
            resources.add(childPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locateResourcesFromClasspath(ResourceManagerImpl resources) throws ServletException {
        ThemeParser parser = new ThemeParser();
        try {
            LOG.info((Object)"Loading tobago-theme.xml");
            Enumeration<URL> urls = this.getClass().getClassLoader().getResources("META-INF/tobago-theme.xml");
            while (urls.hasMoreElements()) {
                URL themeUrl = urls.nextElement();
                ThemeImpl theme = parser.parse(themeUrl);
                this.themeBuilder.addTheme(theme);
                String prefix = this.ensureSlash(theme.getResourcePath());
                String protocol = themeUrl.getProtocol();
                if ("jar".equals(protocol) || "zip".equals(protocol)) {
                    URL jarFile;
                    LOG.info((Object)("themeUrl = '" + themeUrl + "'"));
                    String fileName = themeUrl.toString().substring(4, themeUrl.toString().indexOf("!"));
                    ClassLoader classLoader = ResourceManagerFactory.class.getClassLoader();
                    try {
                        jarFile = new URL(fileName);
                    }
                    catch (MalformedURLException e) {
                        jarFile = new URL("file:" + fileName);
                    }
                    InputStream stream = null;
                    try {
                        stream = jarFile.openStream();
                        ZipInputStream zip = new ZipInputStream(stream);
                        while (zip.available() > 0) {
                            InputStream inputStream;
                            String name;
                            ZipEntry nextEntry = zip.getNextEntry();
                            if (nextEntry == null || nextEntry.isDirectory() || !(name = "/" + nextEntry.getName()).startsWith(prefix) || name.endsWith(".class")) continue;
                            if (name.endsWith(".properties")) {
                                LOG.info((Object)("** " + name.substring(1)));
                                inputStream = classLoader.getResourceAsStream(name.substring(1));
                                this.addProperties(inputStream, resources, name, false);
                                continue;
                            }
                            if (name.endsWith(".properties.xml")) {
                                LOG.info((Object)("** " + name.substring(1)));
                                inputStream = classLoader.getResourceAsStream(name.substring(1));
                                LOG.info((Object)inputStream);
                                this.addProperties(inputStream, resources, name, true);
                                continue;
                            }
                            resources.add(name);
                        }
                        continue;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)stream);
                        continue;
                    }
                }
                String error = "Unknown protocol '" + themeUrl + "'";
                LOG.error((Object)error);
                throw new Exception(error);
            }
        }
        catch (Exception e) {
            String msg = "while loading ";
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)msg, (Throwable)e);
            }
            throw new ServletException(msg, (Throwable)e);
        }
    }

    private String ensureSlash(String resourcePath) {
        if (!resourcePath.startsWith("/")) {
            resourcePath = '/' + resourcePath;
        }
        if (!resourcePath.endsWith("/")) {
            resourcePath = resourcePath + '/';
        }
        return resourcePath;
    }

    private void addProperties(InputStream stream, ResourceManagerImpl resources, String childPath, boolean xml) throws ServletException {
        String directory = childPath.substring(0, childPath.lastIndexOf(47));
        String filename = childPath.substring(childPath.lastIndexOf(47) + 1);
        int end = filename.lastIndexOf(46);
        if (xml) {
            end = filename.lastIndexOf(46, end - 1);
        }
        String locale = filename.substring(0, end);
        Properties temp = new Properties();
        try {
            if (xml) {
                XmlUtils.load(temp, stream);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)childPath);
                    LOG.debug((Object)("xml properties: " + temp.size()));
                }
            } else {
                temp.load(stream);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)childPath);
                    LOG.debug((Object)("    properties: " + temp.size()));
                }
            }
        }
        catch (IOException e) {
            String msg = "while loading " + childPath;
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)msg, (Throwable)e);
            }
            throw new ServletException(msg, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        Enumeration<?> e = temp.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            resources.add(directory + '/' + locale + '/' + key, temp.getProperty(key));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)(directory + '/' + locale + '/' + key + "=" + temp.getProperty(key)));
        }
    }
}

