/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.faces.component.UIViewRoot;
import javax.faces.render.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.ResourceManager;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.UserAgent;

public class ResourceManagerImpl
implements ResourceManager {
    private static final Log LOG = LogFactory.getLog(ResourceManagerImpl.class);
    private final Properties resourceList = new Properties();
    private final Cache cache = new Cache();
    private TobagoConfig tobagoConfig;

    public ResourceManagerImpl(TobagoConfig tobagoConfig) {
        this.tobagoConfig = tobagoConfig;
    }

    public void add(String resourceKey) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding resourceKey = '" + resourceKey + "'"));
        }
        this.resourceList.put(resourceKey, "");
    }

    public void add(String resourceKey, String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding resourceKey = '" + resourceKey + "' value='" + value + "'"));
        }
        this.resourceList.put(resourceKey, value);
    }

    public double getCacheCoverage() {
        return this.cache.found + this.cache.miss > 0 ? (double)this.cache.found / (double)(this.cache.found + this.cache.miss) : 0.0;
    }

    public String getImage(UIViewRoot viewRoot, String name) {
        return this.getImage(viewRoot, name, false);
    }

    public String getImage(UIViewRoot viewRoot, String name, boolean ignoreMissing) {
        String result = null;
        if (name != null) {
            Locale locale;
            String clientPropertyId;
            CacheKey key;
            int dot = name.lastIndexOf(46);
            if (dot == -1) {
                dot = name.length();
            }
            if ((result = (String)this.cache.get(key = new CacheKey(clientPropertyId = ClientProperties.getInstance(viewRoot).getId(), locale = viewRoot.getLocale(), name, CacheType.IMAGE))) == null) {
                try {
                    List paths = this.getPaths(clientPropertyId, locale, "", null, name.substring(0, dot), name.substring(dot), false, true, true, null, true, ignoreMissing);
                    if (paths != null) {
                        result = (String)paths.get(0);
                    }
                    this.cache.put(key, result);
                }
                catch (Exception e) {
                    LOG.error((Object)("name = '" + name + "' clientProperties = '" + clientPropertyId + "'"), (Throwable)e);
                }
            }
        }
        if (result == null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Can't find image for \"" + name + "\""));
        }
        return result;
    }

    public String getJsp(UIViewRoot viewRoot, String name) {
        String type = "jsp";
        String result = null;
        if (name != null) {
            Locale locale;
            String clientPropertyId = ClientProperties.getInstance(viewRoot).getId();
            CacheKey key = new CacheKey(clientPropertyId, locale = viewRoot.getLocale(), name, CacheType.JSP);
            result = (String)this.cache.get(key);
            if (result != null) {
                return result;
            }
            try {
                result = (String)this.getPaths(clientPropertyId, locale, "", "jsp", name, "", false, true, true, null, true, false).get(0);
                this.cache.put(key, result);
            }
            catch (Exception e) {
                LOG.error((Object)("name = '" + name + "' clientProperties = '" + clientPropertyId + "'"), (Throwable)e);
            }
        }
        return result;
    }

    public String getProperty(UIViewRoot viewRoot, String bundle, String propertyKey) {
        return this.getProperty(ClientProperties.getInstance(viewRoot), viewRoot.getLocale(), bundle, propertyKey);
    }

    public String getProperty(ClientProperties clientProperties, Locale locale, String bundle, String propertyKey) {
        String type = "property";
        String result = null;
        if (bundle != null && propertyKey != null) {
            String clientPropertyId = clientProperties.getId();
            CacheKey key = new CacheKey(clientPropertyId, locale, bundle, propertyKey);
            result = (String)this.cache.get(key);
            if (result != null) {
                return result;
            }
            List properties = this.getPaths(clientPropertyId, locale, "", type, bundle, "", false, true, false, propertyKey, true, false);
            result = properties != null ? (String)properties.get(0) : null;
            this.cache.put(key, result);
        }
        return result;
    }

    private String key(String clientProperties, Locale locale, String type, String name, String key) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(clientProperties);
        buffer.append('/');
        buffer.append(locale);
        buffer.append('/');
        buffer.append(type);
        buffer.append('/');
        buffer.append(name);
        buffer.append('/');
        buffer.append(key);
        return buffer.toString();
    }

    private List getPaths(String clientProperties, Locale locale, String prefix, String subDir, String name, String suffix, boolean reverseOrder, boolean single, boolean returnKey, String key, boolean returnStrings, boolean ignoreMissing) {
        String path;
        ArrayList<Object> matches = new ArrayList<Object>();
        StringTokenizer tokenizer = new StringTokenizer(clientProperties, "/");
        String contentType = tokenizer.nextToken();
        Theme theme = this.tobagoConfig.getTheme(tokenizer.nextToken());
        UserAgent browser = UserAgent.getInstanceForId(tokenizer.nextToken());
        List<String> locales = ClientProperties.getLocaleList(locale, false);
        for (String resourceDirectory : this.tobagoConfig.getResourceDirs()) {
            for (Theme themeName : theme.getFallbackList()) {
                for (String browserType : browser.getFallbackList()) {
                    Iterator<String> i$ = locales.iterator();
                    while (i$.hasNext()) {
                        String locale1;
                        String localeSuffix = locale1 = i$.next();
                        path = this.makePath(resourceDirectory, contentType, themeName, browserType, subDir, name, localeSuffix, suffix, key);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("testing path: " + path));
                        }
                        if (returnStrings && this.resourceList.containsKey(path)) {
                            String result = prefix;
                            result = returnKey ? result + path : result + (String)this.resourceList.get(path);
                            if (reverseOrder) {
                                matches.add(0, result);
                            } else {
                                matches.add(result);
                            }
                            if (!single) continue;
                            return matches;
                        }
                        if (returnStrings) continue;
                        try {
                            path = path.substring(1).replace('/', '.');
                            Class<?> clazz = Class.forName(path);
                            matches.add(clazz);
                            return matches;
                        }
                        catch (ClassNotFoundException e) {
                        }
                    }
                }
            }
        }
        for (String localeSuffix : locales) {
            path = this.makePath(name, localeSuffix, suffix, key);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("testing path: " + path));
            }
            if (returnStrings && this.resourceList.containsKey(path)) {
                String result = prefix;
                result = returnKey ? result + path : result + (String)this.resourceList.get(path);
                if (reverseOrder) {
                    matches.add(0, result);
                } else {
                    matches.add(result);
                }
                if (!single) continue;
                return matches;
            }
            if (returnStrings) continue;
            try {
                path = path.substring(1).replace('/', '.');
                Class<?> clazz = Class.forName(path);
                matches.add(clazz);
                return matches;
            }
            catch (ClassNotFoundException e) {
            }
        }
        if (matches.size() == 0) {
            if (!ignoreMissing) {
                LOG.error((Object)("Path not found, and no fallback. Using empty string.\nresourceDirs = '" + this.tobagoConfig.getResourceDirs() + "' contentType = '" + contentType + "' theme = '" + theme + "' browser = '" + browser + "' subDir = '" + subDir + "' name = '" + name + "' suffix = '" + suffix + "' key = '" + key + "'"));
            }
            return null;
        }
        return matches;
    }

    private String makePath(String project, String language, Theme theme, String browser, String subDir, String name, String localeSuffix, String extension, String key) {
        StringBuffer searchtext = new StringBuffer();
        searchtext.append('/');
        searchtext.append(project);
        searchtext.append('/');
        searchtext.append(language);
        searchtext.append('/');
        searchtext.append(theme.getName());
        searchtext.append('/');
        searchtext.append(browser);
        if (subDir != null) {
            searchtext.append('/');
            searchtext.append(subDir);
        }
        searchtext.append('/');
        searchtext.append(name);
        searchtext.append(localeSuffix);
        searchtext.append(extension);
        if (key != null) {
            searchtext.append('/');
            searchtext.append(key);
        }
        return searchtext.toString();
    }

    private String makePath(String name, String localeSuffix, String extension, String key) {
        StringBuffer searchtext = new StringBuffer();
        searchtext.append('/');
        searchtext.append(name);
        searchtext.append(localeSuffix);
        searchtext.append(extension);
        if (key != null) {
            searchtext.append('/');
            searchtext.append(key);
        }
        return searchtext.toString();
    }

    public Renderer getRenderer(UIViewRoot viewRoot, String name) {
        Renderer renderer = null;
        String type = "tag";
        if (name != null) {
            Locale locale;
            String clientPropertyId;
            CacheKey key;
            if (viewRoot instanceof org.apache.myfaces.tobago.component.UIViewRoot) {
                key = ((org.apache.myfaces.tobago.component.UIViewRoot)viewRoot).getRendererCacheKey();
                key.setName(name);
                renderer = (Renderer)this.cache.get(key);
                if (renderer != null) {
                    return renderer;
                }
                clientPropertyId = ClientProperties.getInstance(viewRoot).getId();
                locale = viewRoot.getLocale();
                key = new CacheKey(clientPropertyId, locale, name, CacheType.RENDERER);
            } else {
                clientPropertyId = ClientProperties.getInstance(viewRoot).getId();
                key = new CacheKey(clientPropertyId, locale = viewRoot.getLocale(), name, CacheType.RENDERER);
                renderer = (Renderer)this.cache.get(key);
                if (renderer != null) {
                    return renderer;
                }
            }
            try {
                name = this.getRendererClassName(name);
                Class clazz = (Class)this.getPaths(clientPropertyId, locale, "", "tag", name, "", false, true, true, null, false, false).get(0);
                renderer = (Renderer)clazz.newInstance();
                this.cache.put(key, renderer);
            }
            catch (Exception e) {
                LOG.error((Object)("name = '" + name + "' clientProperties = '" + clientPropertyId + "'"), (Throwable)e);
                throw new RuntimeException(name, e);
            }
        }
        return renderer;
    }

    private String getRendererClassName(String rendererType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("rendererType = '" + rendererType + "'"));
        }
        String name = "javax.faces.Text".equals(rendererType) ? "Out" : rendererType;
        if ((name = name + "Renderer").startsWith("javax.faces.")) {
            LOG.warn((Object)("patching renderer from " + name));
            name = name.substring("javax.faces.".length());
            LOG.warn((Object)("patching renderer to   " + name));
        }
        return name;
    }

    private String key(String clientProperties, Locale locale, String type, String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(clientProperties);
        buffer.append('/');
        buffer.append(locale);
        if (type != null) {
            buffer.append('/');
            buffer.append(type);
        }
        buffer.append('/');
        buffer.append(name);
        return buffer.toString();
    }

    public String[] getScripts(UIViewRoot viewRoot, String name) {
        return this.getStrings(viewRoot, name, null);
    }

    public String[] getStyles(UIViewRoot viewRoot, String name) {
        return this.getStrings(viewRoot, name, null);
    }

    private String[] getStrings(UIViewRoot viewRoot, String name, String type) {
        String[] result = null;
        if (name != null) {
            Locale locale;
            String clientPropertyId;
            CacheKey key;
            int dot = name.lastIndexOf(46);
            if (dot == -1) {
                dot = name.length();
            }
            if ((result = (String[])this.cache.get(key = new CacheKey(clientPropertyId = ClientProperties.getInstance(viewRoot).getId(), locale = viewRoot.getLocale(), name, CacheType.MISC))) != null) {
                return result;
            }
            try {
                List matches = this.getPaths(clientPropertyId, locale, "", type, name.substring(0, dot), name.substring(dot), true, false, true, null, true, false);
                result = matches.toArray(new String[matches.size()]);
                this.cache.put(key, result);
            }
            catch (Exception e) {
                LOG.error((Object)("name = '" + name + "' clientProperties = '" + clientPropertyId + "'"), (Throwable)e);
            }
        }
        return result;
    }

    public String getThemeProperty(UIViewRoot viewRoot, String bundle, String propertyKey) {
        String type = "property";
        String result = null;
        if (bundle != null && propertyKey != null) {
            Locale locale;
            String clientPropertyId = ClientProperties.getInstance(viewRoot).getId();
            CacheKey key = new CacheKey(clientPropertyId, locale = viewRoot.getLocale(), bundle, propertyKey);
            result = (String)this.cache.get(key);
            if (result != null) {
                return result;
            }
            List properties = this.getPaths(clientPropertyId, locale, "", "property", bundle, "", false, true, false, propertyKey, true, true);
            result = properties != null ? (String)properties.get(0) : null;
            this.cache.put(key, result);
        }
        return result;
    }

    public static CacheKey getRendererCacheKey(String clientPropertyId, Locale locale) {
        return new CacheKey(clientPropertyId, locale, null, CacheType.RENDERER);
    }

    public static final class CacheKey {
        private final String clientPropertyId;
        private final Locale locale;
        private String name;
        private final String key;
        private final CacheType type;
        private int hashCodeBase;
        private int hashCode;

        public CacheKey(String clientPropertyId, Locale locale, String name, String key) {
            this.clientPropertyId = clientPropertyId;
            if (locale == null) {
                LOG.warn((Object)"locale == null");
                locale = Locale.getDefault();
            }
            this.locale = locale;
            this.name = name;
            this.key = key;
            this.type = CacheType.PROPERTY;
            this.calcHashCode();
        }

        public CacheKey(String clientPropertyId, Locale locale, String name, CacheType type) {
            this.clientPropertyId = clientPropertyId;
            if (locale == null) {
                LOG.warn((Object)"locale == null");
                locale = Locale.getDefault();
            }
            this.locale = locale;
            this.name = name;
            this.key = null;
            this.type = type;
            this.calcHashCode();
        }

        public void setName(String name) {
            this.name = name;
            this.updateHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.type != cacheKey.type) {
                return false;
            }
            if (this.key != null ? !this.key.equals(cacheKey.key) : cacheKey.key != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(cacheKey.name) : cacheKey.name != null) {
                return false;
            }
            if (this.name != null ? !this.locale.equals(cacheKey.locale) : cacheKey.locale != null) {
                return false;
            }
            return this.clientPropertyId.equals(cacheKey.clientPropertyId);
        }

        private void calcHashCode() {
            this.hashCodeBase = this.clientPropertyId.hashCode();
            this.hashCodeBase = 29 * this.hashCode + (this.locale != null ? this.locale.hashCode() : 0);
            this.hashCodeBase = 29 * this.hashCode + this.type.hashCode();
            this.hashCodeBase = 29 * this.hashCode + (this.key != null ? this.key.hashCode() : 0);
            this.updateHashCode();
        }

        private void updateHashCode() {
            this.hashCode = 29 * this.hashCodeBase + (this.name != null ? this.name.hashCode() : 0);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CacheType {
        RENDERER,
        IMAGE,
        JSP,
        PROPERTY,
        MISC;

    }

    private class Cache
    extends HashMap {
        private int found;
        private int miss;

        private Cache() {
        }

        public Object get(Object key) {
            Object value = super.get(key);
            if (value != null) {
                ++this.found;
            } else {
                ++this.miss;
            }
            return value;
        }
    }
}

