/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.ThemeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThemeBuilder {
    private static final Log LOG = LogFactory.getLog(ThemeBuilder.class);
    private List<ThemeImpl> availableThemes = new ArrayList<ThemeImpl>();

    ThemeBuilder() {
    }

    public Map<String, Theme> resolveThemes() {
        HashMap<String, ThemeImpl> map = new HashMap<String, ThemeImpl>();
        for (ThemeImpl theme : this.availableThemes) {
            LOG.debug((Object)("theme from tobago-theme.xml files:" + theme.getName()));
            map.put(theme.getName(), theme);
        }
        for (ThemeImpl theme : this.availableThemes) {
            String fallbackName = theme.getFallbackName();
            ThemeImpl fallback = (ThemeImpl)map.get(fallbackName);
            theme.setFallback(fallback);
        }
        for (ThemeImpl theme : this.availableThemes) {
            theme.resolveFallbacks();
        }
        HashMap<String, ThemeImpl> result = new HashMap<String, ThemeImpl>();
        for (ThemeImpl theme : this.availableThemes) {
            result.put(theme.getName(), theme);
        }
        for (ThemeImpl theme : this.availableThemes) {
            if (theme.getDeprecatedName() == null) continue;
            result.put(theme.getDeprecatedName(), theme);
        }
        return Collections.unmodifiableMap(result);
    }

    public void addTheme(ThemeImpl theme) {
        this.availableThemes.add(theme);
    }
}

