/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAgent
implements Serializable {
    private static final long serialVersionUID = -3138810465122379395L;
    public static final String DEFAULT_NAME = "standard";
    public static final UserAgent DEFAULT = new UserAgent(null, null);
    public static final UserAgent MSIE = new UserAgent("msie", null);
    public static final UserAgent MSIE_5_0 = new UserAgent("msie", "5_0");
    public static final UserAgent MSIE_5_5 = new UserAgent("msie", "5_5");
    public static final UserAgent MSIE_6_0 = new UserAgent("msie", "6_0");
    public static final UserAgent MSIE_5_0_MAC = new UserAgent("msie", "5_0_mac");
    public static final UserAgent MSIE_6_0_MAC = new UserAgent("msie", "6_0_mac");
    public static final UserAgent OPERA = new UserAgent("opera", null);
    public static final UserAgent OPERA_5_0 = new UserAgent("opera", "5_0");
    public static final UserAgent OPERA_6_0 = new UserAgent("opera", "6_0");
    public static final UserAgent OPERA_7_11 = new UserAgent("opera", "7_11");
    public static final UserAgent MOZILLA = new UserAgent("mozilla", null);
    public static final UserAgent MOZILLA_4_7 = new UserAgent("mozilla", "4_7");
    public static final UserAgent MOZILLA_5_0 = new UserAgent("mozilla", "5_0");
    public static final UserAgent MOZILLA_5_0_R1_6 = new UserAgent("mozilla", "5_0_r1_6");
    private String name;
    private String version;

    private UserAgent(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public boolean isMsie() {
        return UserAgent.MSIE.name.equals(this.name);
    }

    public boolean isMozilla() {
        return UserAgent.MOZILLA.name.equals(this.name);
    }

    public List<String> getFallbackList() {
        return this.getFallbackList(false);
    }

    private List<String> getFallbackList(boolean reverseOrder) {
        ArrayList<String> list = new ArrayList<String>(3);
        if (this.version != null) {
            list.add(this.name + '_' + this.version);
        }
        if (this.name != null) {
            list.add(this.name);
        }
        list.add(DEFAULT_NAME);
        if (reverseOrder) {
            Collections.reverse(list);
        }
        return list;
    }

    public static UserAgent getInstance(String header) {
        if (header == null) {
            return DEFAULT;
        }
        if ((header = header.toLowerCase().replace('/', ' ')).indexOf("opera") > -1) {
            if (header.indexOf("opera 5.0") > -1) {
                return OPERA_5_0;
            }
            if (header.indexOf("opera 6.0") > -1) {
                return OPERA_6_0;
            }
            if (header.indexOf("opera 7.11") > -1) {
                return OPERA_7_11;
            }
            return OPERA;
        }
        if (header.indexOf("msie") > -1) {
            if (header.indexOf("msie 5.0") > -1) {
                if (header.indexOf("mac") > -1) {
                    return MSIE_5_0_MAC;
                }
                return MSIE_5_0;
            }
            if (header.indexOf("msie 5.5") > -1) {
                return MSIE_5_5;
            }
            if (header.indexOf("msie 6.0") > -1) {
                if (header.indexOf("mac") > -1) {
                    return MSIE_6_0_MAC;
                }
                return MSIE_6_0;
            }
            return MSIE;
        }
        if (header.indexOf("mozilla") > -1) {
            if (header.indexOf("mozilla 4.7") > -1) {
                return MOZILLA_4_7;
            }
            if (header.indexOf("mozilla 5.0") > -1) {
                if (header.indexOf("rv:1.6") > -1) {
                    return MOZILLA_5_0_R1_6;
                }
                return MOZILLA_5_0;
            }
            return MOZILLA;
        }
        return DEFAULT;
    }

    public static UserAgent getInstanceForId(String id) {
        if (id == null) {
            return DEFAULT;
        }
        if (id.indexOf("opera") == 0) {
            if (id.equals("opera_5_0")) {
                return OPERA_5_0;
            }
            if (id.equals("opera_6_0")) {
                return OPERA_6_0;
            }
            if (id.equals("opera_7_11")) {
                return OPERA_7_11;
            }
            return OPERA;
        }
        if (id.indexOf("msie") == 0) {
            if (id.equals("msie_5_0")) {
                return MSIE_5_0;
            }
            if (id.equals("msie_5_0_mac")) {
                return MSIE_5_0_MAC;
            }
            if (id.equals("msie_5_5")) {
                return MSIE_5_5;
            }
            if (id.equals("msie_6_0")) {
                return MSIE_6_0;
            }
            if (id.equals("msie_6_0_mac")) {
                return MSIE_6_0_MAC;
            }
            return MSIE;
        }
        if (id.indexOf("mozilla") == 0) {
            if (id.equals("mozilla_4_7")) {
                return MOZILLA_4_7;
            }
            if (id.equals("mozilla_5_0")) {
                return MOZILLA_5_0;
            }
            if (id.equals("mozilla_5_0_r1_6")) {
                return MOZILLA_5_0_R1_6;
            }
            return MOZILLA;
        }
        return DEFAULT;
    }

    public String toString() {
        return this.version != null ? this.name + '_' + this.version : this.name;
    }
}

