/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.convert;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DurationConverter
implements Converter {
    private static final Log LOG = LogFactory.getLog(DurationConverter.class);
    public static final String CONVERTER_ID = "org.apache.myfaces.tobago.Duration";
    private static final String NANO = "nano";
    private static final String MILLI = "milli";
    private static final String SECOND = "second";
    private static final String MINUTE = "minute";
    private static final String HOUR = "hour";
    private static final String DAY = "day";
    private static final String YEAR = "year";

    public String getAsString(FacesContext facesContext, UIComponent component, Object object) throws ConverterException {
        if (object == null || object instanceof String) {
            return (String)object;
        }
        double aDouble = ((Number)object).doubleValue();
        boolean negative = false;
        if (aDouble < 0.0) {
            negative = true;
            aDouble = -aDouble;
        }
        double factor = DurationConverter.getUnitFactor(component);
        DecimalFormat format = new DecimalFormat("00");
        long value = new Double(aDouble *= factor).longValue();
        int seconds = (int)(value % 60L);
        int minutes = (int)((value /= 60L) % 60L);
        String string = (value /= 60L) > 0L ? (negative ? "-" : "") + value + ":" + format.format(minutes) + ":" + format.format(seconds) : (negative ? "-" : "") + minutes + ":" + format.format(seconds);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("string = '" + string + "'"));
        }
        return string;
    }

    public Object getAsObject(FacesContext facesContext, UIComponent component, String string) throws ConverterException {
        int seconds;
        int minutes;
        boolean negative = string.indexOf(45) > -1;
        StringTokenizer tokenizer = new StringTokenizer(string, " :-");
        ArrayList<Object> elements = new ArrayList<Object>();
        while (tokenizer.hasMoreElements()) {
            elements.add(tokenizer.nextElement());
        }
        int hours = 0;
        switch (elements.size()) {
            case 3: {
                hours = Integer.parseInt((String)elements.get(0));
                minutes = Integer.parseInt((String)elements.get(1));
                seconds = Integer.parseInt((String)elements.get(2));
                break;
            }
            case 2: {
                minutes = Integer.parseInt((String)elements.get(0));
                seconds = Integer.parseInt((String)elements.get(1));
                break;
            }
            default: {
                throw new ConverterException("Cannot parse string='" + string + "'");
            }
        }
        double factor = DurationConverter.getUnitFactor(component);
        long value = (long)((double)(((long)hours * 60L + (long)minutes) * 60L + (long)seconds) / factor);
        if (negative) {
            return new Long(-value);
        }
        return new Long(value);
    }

    private static double getUnitFactor(UIComponent component) {
        double factor;
        String unit = null;
        if (component != null) {
            unit = (String)component.getAttributes().get("unit");
        }
        if (unit == null) {
            factor = 0.001;
        } else if (NANO.equals(unit)) {
            factor = 1.0E-9;
        } else if (MILLI.equals(unit)) {
            factor = 0.001;
        } else if (SECOND.equals(unit)) {
            factor = 1.0;
        } else if (MINUTE.equals(unit)) {
            factor = 60.0;
        } else if (HOUR.equals(unit)) {
            factor = 3600.0;
        } else if (DAY.equals(unit)) {
            factor = 86400.0;
        } else if (YEAR.equals(unit)) {
            factor = 3.1556736E7;
        } else {
            LOG.warn((Object)("Unsupported unit: '" + unit + "'"));
            factor = 0.001;
        }
        return factor;
    }
}

