/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.event;

import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import javax.faces.event.ActionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.config.ThemeConfig;

public class DatePickerController
extends MethodBinding {
    private static final Log LOG = LogFactory.getLog(DatePickerController.class);
    public static final String OPEN_POPUP = "openPopup";
    public static final String CLOSE_POPUP = "closePopup";

    public Object invoke(FacesContext facesContext, Object[] objects) throws EvaluationException {
        UIComponent popup;
        UICommand command;
        String commandId;
        if (objects[0] instanceof ActionEvent && (commandId = (command = (UICommand)((ActionEvent)objects[0]).getSource()).getClientId(facesContext)).endsWith(OPEN_POPUP) && (popup = command.getFacet("pickerPopup")) != null) {
            popup.setRendered(true);
            String dimensionParameter = commandId.substring(0, commandId.length() - OPEN_POPUP.length()) + "Dimension";
            String dimension = (String)facesContext.getExternalContext().getRequestParameterMap().get(dimensionParameter);
            StringTokenizer st = new StringTokenizer(dimension, "x:");
            int width = this.nextDimensionToken(st, ThemeConfig.getValue(facesContext, popup, "DefaultPageWidth"));
            int height = this.nextDimensionToken(st, ThemeConfig.getValue(facesContext, popup, "DefaultPageHeight"));
            int left = this.nextDimensionToken(st, -1);
            int top = this.nextDimensionToken(st, -1);
            int popupWidth = ComponentUtil.getIntAttribute(popup, "width", -1);
            int popupHeight = ComponentUtil.getIntAttribute(popup, "height", -1);
            int popupLeft = ComponentUtil.getIntAttribute(popup, "left", -1);
            int popupTop = ComponentUtil.getIntAttribute(popup, "top", -1);
            Map attributes = popup.getAttributes();
            if (popupWidth == -1) {
                popupWidth = ThemeConfig.getValue(facesContext, popup, "CalendarPopupWidth");
                attributes.put("width", String.valueOf(popupWidth));
            }
            if (popupHeight == -1) {
                popupHeight = ThemeConfig.getValue(facesContext, popup, "CalendarPopupHeight");
                attributes.put("height", String.valueOf(popupHeight));
            }
            if (popupLeft == -1) {
                int popupRight;
                popupLeft = left != -1 ? ((popupRight = left + popupWidth / 2) < width ? popupRight - popupWidth : width - popupWidth) : (width - popupWidth) / 2;
                attributes.put("left", popupLeft > 0 ? String.valueOf(popupLeft) : "0");
            }
            if (popupTop == -1) {
                int fixedHeight;
                int popupBottom;
                popupTop = top != -1 ? ((popupBottom = top + popupHeight + (fixedHeight = ThemeConfig.getValue(facesContext, (UIComponent)command, "fixedHeight"))) < height ? top + fixedHeight : height - popupHeight) : (height - popupHeight) / 2;
                attributes.put("top", popupTop > 0 ? String.valueOf(popupTop) : "0");
            }
        }
        return null;
    }

    private int nextDimensionToken(StringTokenizer st, int defaultValue) {
        if (st.hasMoreTokens()) {
            try {
                defaultValue = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException e) {
                LOG.error((Object)("Catched: " + e.getMessage()), (Throwable)e);
            }
        }
        return defaultValue;
    }

    public Class getType(FacesContext facesContext) throws MethodNotFoundException {
        return String.class;
    }
}

