/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.renderkit.RendererBase;

public abstract class CommandRendererBase
extends RendererBase {
    private static final Log LOG = LogFactory.getLog(CommandRendererBase.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        if (ComponentUtil.isOutputOnly(component)) {
            return;
        }
        String actionId = ComponentUtil.findPage(component).getActionId();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("actionId = '" + actionId + "'"));
        }
        String clientId = component.getClientId(facesContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("clientId = '" + clientId + "'"));
        }
        if (actionId != null && actionId.equals(clientId)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"queueEvent");
            }
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
    }

    public static String appendConfirmationScript(String onclick, UIComponent component, FacesContext facesContext) {
        ValueHolder confirmation = (ValueHolder)component.getFacet("confirmation");
        if (confirmation != null) {
            if (onclick != null) {
                onclick = "confirm('" + confirmation.getValue() + "') && " + onclick;
            } else if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Facet 'confirmation' is not supported for this type of button. id = '" + component.getClientId(facesContext) + "'"));
            }
        }
        return onclick;
    }
}

