/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.LongRangeValidator;
import javax.faces.validator.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlUtils {
    private static final Log LOG = LogFactory.getLog(HtmlUtils.class);
    public static final String LAYOUT_ATTRIBUTE_PREFIX = "layout.";

    public static String generateAttribute(String name, Object value) {
        String stringValue = value == null ? null : (value instanceof String ? (String)value : value.toString());
        return stringValue != null && stringValue.length() > 0 ? name + "=\"" + value + "\"" : "";
    }

    public static String appendAttribute(UIComponent component, String name, String appendValue) {
        Object attribute = component.getAttributes().get(name);
        return attribute != null ? attribute.toString() + " " + appendValue : appendValue;
    }

    public static String generateOnchange(UIInput component, FacesContext facesContext) {
        StringBuffer buffer = new StringBuffer();
        Validator[] validators = component.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            if (validators[i] instanceof LongRangeValidator) {
                String functionCall = "validateLongRange('" + component.getClientId(facesContext) + "')";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("validator functionCall: " + functionCall));
                }
                buffer.append(functionCall);
            } else {
                buffer.append("true");
            }
            if (i + 1 >= validators.length) continue;
            buffer.append(" && ");
        }
        Object onchange = component.getAttributes().get("onchange");
        if (onchange != null) {
            if (buffer.length() > 0) {
                buffer.append(" && ");
            }
            buffer.append(onchange);
        }
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    public static String generateUrl(FacesContext facesContext, String url) {
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        String result = !url.startsWith("/") ? facesContext.getExternalContext().encodeActionURL(url) : viewHandler.getActionURL(facesContext, url);
        return result;
    }
}

