/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import javax.faces.component.UIComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LabelWithAccessKey {
    private static final Log LOG = LogFactory.getLog(LabelWithAccessKey.class);
    private String text;
    private Character accessKey;
    private int pos = -1;
    public static final char INDICATOR = '_';

    public LabelWithAccessKey(UIComponent component) {
        this.text = "Label".equals(component.getRendererType()) ? (String)component.getAttributes().get("value") : (String)component.getAttributes().get("label");
        this.setup(this.text);
    }

    public void setup(String label) {
        if (label != null) {
            this.pos = label.indexOf(95);
            if (this.pos == -1) {
                this.text = label;
            } else if (this.pos == label.length() - 1) {
                LOG.warn((Object)("_ in label is last char, this is not allowedlabel='" + label + "'."));
                this.text = label.substring(0, label.length() - 1);
                this.pos = -1;
            } else {
                this.text = label.substring(0, this.pos) + label.substring(this.pos + 1);
                this.accessKey = new Character(this.text.charAt(this.pos));
            }
        } else if (this.accessKey != null && this.text != null) {
            this.pos = this.text.toLowerCase().indexOf(Character.toLowerCase(this.accessKey.charValue()));
        }
    }

    public String getText() {
        return this.text;
    }

    public Character getAccessKey() {
        return this.accessKey;
    }

    public int getPos() {
        return this.pos;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setAccessKey(Character accessKey) {
        this.accessKey = accessKey;
    }
}

