/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UILayout;
import org.apache.myfaces.tobago.renderkit.LayoutRenderer;

public class RenderUtil {
    private static final Log LOG = LogFactory.getLog(RenderUtil.class);
    public static final String COMPONENT_IN_REQUEST = "org.apache.myfaces.tobago.component";

    public static boolean contains(Object[] list, Object value) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null || !list[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public static UIComponent getComponent(HttpServletRequest request) {
        UIComponent component = (UIComponent)request.getAttribute(COMPONENT_IN_REQUEST);
        return component;
    }

    public static void encodeChildren(FacesContext facesContext, UIComponent panel) throws IOException {
        UILayout layout = UILayout.getLayout(panel);
        if (layout != null) {
            layout.encodeChildrenOfComponent(facesContext, panel);
        } else {
            for (UIComponent child : panel.getChildren()) {
                RenderUtil.encode(facesContext, child);
            }
        }
    }

    public static void encode(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.isRendered()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("rendering " + component.getRendererType() + " " + component));
            }
            LayoutRenderer layoutRenderer = (LayoutRenderer)ComponentUtil.getRenderer(facesContext, (UIComponent)UILayout.getLayout(component));
            layoutRenderer.prepareRender(facesContext, component);
            component.encodeBegin(facesContext);
            if (component.getRendersChildren()) {
                component.encodeChildren(facesContext);
            } else {
                for (UIComponent kid : component.getChildren()) {
                    RenderUtil.encode(facesContext, kid);
                }
            }
            component.encodeEnd(facesContext);
        }
    }

    public static String addMenuCheckToggle(String clientId, String onClick) {
        onClick = onClick != null ? " ; " + onClick : "";
        onClick = "menuCheckToggle('" + clientId + "')" + onClick;
        return onClick;
    }
}

