/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UICell;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.config.ThemeConfig;
import org.apache.myfaces.tobago.renderkit.TobagoRenderer;
import org.apache.myfaces.tobago.util.LayoutUtil;

public abstract class RendererBase
extends Renderer
implements TobagoRenderer {
    private static final Log LOG = LogFactory.getLog(RendererBase.class);
    public static final String BEGIN_POSTFIX = "Begin";
    public static final String CHILDREN_POSTFIX = "Children";
    public static final String END_POSTFIX = "";

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("*** begin    " + component));
        }
        try {
            this.encodeBeginTobago(facesContext, component);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error((Object)"catched RuntimeException :", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LOG.error((Object)"catched Throwable :", e);
            throw new RuntimeException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("*   begin    " + component));
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("*** children " + component));
        }
        if (component instanceof UIPage) {
            LOG.info((Object)"UUUUUUUUUUUUUUUUUUUUU UIPage XXXXXXXXXXXXXXXXXXXXXXXXXXXXxx");
        }
        this.encodeChildrenTobago(facesContext, component);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("*   children " + component));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("*** end      " + component));
        }
        try {
            this.encodeEndTobago(facesContext, component);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error((Object)("catched " + e + " :" + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LOG.error((Object)"catched Throwable :", e);
            throw new RuntimeException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("*   end      " + component));
        }
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        if (component instanceof UIInput) {
            LOG.warn((Object)("decode() should be overwritten! Renderer: " + this.getClass().getName()));
        }
    }

    public String getRendererName(String rendererType) {
        String name;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("rendererType = '" + rendererType + "'"));
        }
        if ((name = "javax.faces.Text".equals(rendererType) ? "Out" : rendererType).startsWith("javax.faces.")) {
            LOG.warn((Object)("patching renderer from " + name));
            name = name.substring("javax.faces.".length());
            LOG.warn((Object)("patching renderer to   " + name));
        }
        name = name.substring(0, 1).toLowerCase() + name.substring(1);
        return name;
    }

    public int getConfiguredValue(FacesContext facesContext, UIComponent component, String key) {
        try {
            return ThemeConfig.getValue(facesContext, component, key);
        }
        catch (Exception e) {
            LOG.error((Object)("Can't take '" + key + "' for " + this.getClass().getName() + " from config-file: " + e.getMessage()), (Throwable)e);
            return 0;
        }
    }

    public int getHeaderHeight(FacesContext facesContext, UIComponent component) {
        int height = this.getConfiguredValue(facesContext, component, "headerHeight");
        UIComponent menubar = component.getFacet("menuBar");
        if (menubar != null) {
            height += this.getConfiguredValue(facesContext, menubar, "headerHeight");
        }
        return height;
    }

    public int getPaddingWidth(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "paddingWidth");
    }

    public int getPaddingHeight(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "paddingHeight");
    }

    public int getComponentExtraWidth(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "componentExtraWidth");
    }

    public int getComponentExtraHeight(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "componentExtraHeight");
    }

    public Dimension getMinimumSize(FacesContext facesContext, UIComponent component) {
        int height;
        int width = this.getConfiguredValue(facesContext, component, "minimumWidth");
        if (width == -1) {
            width = this.getConfiguredValue(facesContext, component, "fixedWidth");
        }
        if ((height = this.getConfiguredValue(facesContext, component, "minimumHeight")) == -1) {
            height = this.getConfiguredValue(facesContext, component, "fixedHeight");
        }
        return new Dimension(width, height);
    }

    public int getFixedWidth(FacesContext facesContext, UIComponent component) {
        return this.getFixedSpace(facesContext, component, true);
    }

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        return this.getFixedSpace(facesContext, component, false);
    }

    public int getFixedSpace(FacesContext facesContext, UIComponent component, boolean width) {
        int fixedSpace = 0;
        if (component instanceof UICell) {
            List<UIComponent> children = LayoutUtil.addChildren(new ArrayList<UIComponent>(), component);
            for (UIComponent child : children) {
                RendererBase renderer = ComponentUtil.getRenderer(facesContext, child);
                if (renderer == null) continue;
                if (width) {
                    fixedSpace = Math.max(fixedSpace, renderer.getFixedWidth(facesContext, child));
                    continue;
                }
                fixedSpace = Math.max(fixedSpace, renderer.getFixedHeight(facesContext, child));
            }
        } else {
            fixedSpace = width ? this.getFixedSpace(facesContext, component, "width", "fixedWidth") : this.getFixedSpace(facesContext, component, "height", "fixedHeight");
        }
        return fixedSpace;
    }

    private int getFixedSpace(FacesContext facesContext, UIComponent component, String attr, String attrFixed) {
        int intSpace = -1;
        String space = null;
        if (component != null) {
            space = ComponentUtil.getStringAttribute(component, attr);
        }
        if (space != null) {
            try {
                intSpace = Integer.parseInt(space.replaceAll("\\D", END_POSTFIX));
            }
            catch (NumberFormatException e) {
                LOG.error((Object)("Catched: " + e.getMessage()), (Throwable)e);
            }
        }
        if (intSpace == -1) {
            return this.getConfiguredValue(facesContext, component, attrFixed);
        }
        return intSpace;
    }

    public void encodeBeginTobago(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public void encodeChildrenTobago(FacesContext facesContext, UIComponent component) throws IOException {
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            child.encodeBegin(facesContext);
            if (child.getRendersChildren()) {
                child.encodeChildren(facesContext);
            }
            child.encodeEnd(facesContext);
        }
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent component) throws IOException {
    }

    protected String getCurrentValue(FacesContext facesContext, UIComponent component) {
        Object submittedValue;
        if (component instanceof UIInput && (submittedValue = ((UIInput)component).getSubmittedValue()) != null) {
            return (String)submittedValue;
        }
        String currentValue = null;
        Object currentObj = this.getValue(component);
        if (currentObj != null) {
            currentValue = RendererBase.getFormattedValue(facesContext, component, currentObj);
        }
        return currentValue;
    }

    protected Object getValue(UIComponent component) {
        if (component instanceof ValueHolder) {
            Object value = ((ValueHolder)component).getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("component.getValue() returned " + value));
            }
            return value;
        }
        return null;
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        ValueBinding valueBinding = component.getValueBinding("value");
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (null == converter && null != valueBinding) {
            Class converterType = valueBinding.getType(context);
            if (converterType == null || converterType == String.class || converterType == Object.class) {
                return submittedValue;
            }
            Application application = context.getApplication();
            converter = application.createConverter(converterType);
        } else if (converter == null) {
            return submittedValue;
        }
        if (converter != null && submittedValue instanceof String) {
            Object result = converter.getAsObject(context, component, (String)submittedValue);
            return result;
        }
        throw new ConverterException("type conversion error: submittedValue='" + submittedValue + "'");
    }

    protected static String getFormattedValue(FacesContext facesContext, UIComponent component) {
        Object value = null;
        if (component instanceof ValueHolder && (value = ((ValueHolder)component).getLocalValue()) == null) {
            value = ((ValueHolder)component).getValue();
        }
        return RendererBase.getFormattedValue(facesContext, component, value);
    }

    protected static String getFormattedValue(FacesContext context, UIComponent component, Object currentValue) throws ConverterException {
        if (currentValue == null) {
            return END_POSTFIX;
        }
        if (!(component instanceof ValueHolder)) {
            return currentValue.toString();
        }
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter == null) {
            if (currentValue instanceof String) {
                return (String)currentValue;
            }
            Class<?> converterType = currentValue.getClass();
            converter = context.getApplication().createConverter(converterType);
        }
        if (converter == null) {
            return currentValue.toString();
        }
        return converter.getAsString(context, component, currentValue);
    }
}

