/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.renderkit.RendererBase;

public class SelectManyRendererBase
extends RendererBase {
    private static final Log LOG = LogFactory.getLog(SelectManyRendererBase.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        if (ComponentUtil.isOutputOnly(component)) {
            return;
        }
        UISelectMany uiSelectMany = (UISelectMany)component;
        String[] newValues = (String[])facesContext.getExternalContext().getRequestParameterValuesMap().get(uiSelectMany.getClientId(facesContext));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("decode: key='" + component.getClientId(facesContext) + "' value='" + newValues + "'"));
            LOG.debug((Object)("size ... '" + (newValues != null ? newValues.length : -1) + "'"));
            if (newValues != null) {
                for (String newValue : newValues) {
                    LOG.debug((Object)("newValues[i] = '" + newValue + "'"));
                }
            }
        }
        if (newValues == null) {
            newValues = new String[]{};
        }
        uiSelectMany.setSubmittedValue((Object)newValues);
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        if (submittedValue == null) {
            return null;
        }
        if (!(submittedValue instanceof String[])) {
            throw new ConverterException("Submitted value of type String[] for component : " + component.getClientId(facesContext) + "expected");
        }
        return this.getConvertedUISelectManyValue(facesContext, (UISelectMany)component, (String[])submittedValue);
    }

    private Object getConvertedUISelectManyValue(FacesContext facesContext, UISelectMany component, String[] submittedValue) throws ConverterException {
        Converter converter;
        if (submittedValue == null) {
            throw new NullPointerException("submittedValue");
        }
        ValueBinding vb = component.getValueBinding("value");
        Class valueType = null;
        Class<?> arrayComponentType = null;
        if (vb != null && (valueType = vb.getType(facesContext)) != null && valueType.isArray()) {
            arrayComponentType = valueType.getComponentType();
        }
        if ((converter = component.getConverter()) == null) {
            if (valueType == null) {
                return submittedValue;
            }
            if (List.class.isAssignableFrom(valueType)) {
                int len = submittedValue.length;
                ArrayList<String> lst = new ArrayList<String>(len);
                for (int i = 0; i < len; ++i) {
                    lst.add(submittedValue[i]);
                }
                return lst;
            }
            if (arrayComponentType == null) {
                throw new IllegalArgumentException("ValueBinding for UISelectMany must be of type List or Array");
            }
            if (String.class.equals(arrayComponentType)) {
                return submittedValue;
            }
            if (Object.class.equals(arrayComponentType)) {
                return submittedValue;
            }
            try {
                converter = facesContext.getApplication().createConverter(arrayComponentType);
            }
            catch (FacesException e) {
                LOG.error((Object)("No Converter for type " + arrayComponentType.getName() + " found"), (Throwable)e);
                return submittedValue;
            }
        }
        if (vb != null && (valueType = vb.getType(facesContext)) != null && valueType.isArray() && submittedValue.length > 0) {
            arrayComponentType = converter.getAsObject(facesContext, (UIComponent)component, submittedValue[0]).getClass();
        }
        if (valueType == null) {
            int len = submittedValue.length;
            Object[] convertedValues = (Object[])Array.newInstance(arrayComponentType == null ? Object.class : arrayComponentType, len);
            for (int i = 0; i < len; ++i) {
                convertedValues[i] = converter.getAsObject(facesContext, (UIComponent)component, submittedValue[i]);
            }
            return convertedValues;
        }
        if (List.class.isAssignableFrom(valueType)) {
            int len = submittedValue.length;
            ArrayList<Object> lst = new ArrayList<Object>(len);
            for (int i = 0; i < len; ++i) {
                lst.add(converter.getAsObject(facesContext, (UIComponent)component, submittedValue[i]));
            }
            return lst;
        }
        if (arrayComponentType == null) {
            throw new IllegalArgumentException("ValueBinding for UISelectMany must be of type List or Array");
        }
        if (arrayComponentType.isPrimitive()) {
            int len = submittedValue.length;
            Object convertedValues = Array.newInstance(arrayComponentType, len);
            for (int i = 0; i < len; ++i) {
                Array.set(convertedValues, i, converter.getAsObject(facesContext, (UIComponent)component, submittedValue[i]));
            }
            return convertedValues;
        }
        int len = submittedValue.length;
        ArrayList<Object> convertedValues = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            convertedValues.add(i, converter.getAsObject(facesContext, (UIComponent)component, submittedValue[i]));
        }
        return convertedValues.toArray((Object[])Array.newInstance(arrayComponentType, len));
    }
}

