/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIData;
import org.apache.myfaces.tobago.event.PageAction;
import org.apache.myfaces.tobago.event.PageActionEvent;
import org.apache.myfaces.tobago.event.PageActionUtil;

public class SheetUtils {
    private static final Log LOG = LogFactory.getLog(SheetUtils.class);

    public static void decode(FacesContext facesContext, UIComponent component) {
        String actionId = ComponentUtil.findPage(component).getActionId();
        String clientId = component.getClientId(facesContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("actionId = '" + actionId + "'"));
            LOG.debug((Object)("clientId = '" + clientId + "'"));
        }
        if (actionId != null && actionId.equals(clientId)) {
            PageAction action;
            try {
                action = PageActionUtil.parse(component.getId());
                if (action == null) {
                    LOG.error((Object)("Illegal value for PageAction :" + component.getId()));
                    return;
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Illegal value for PageAction :" + component.getId()));
                return;
            }
            PageActionEvent event = new PageActionEvent((UIData)component.getParent(), action);
            switch (action) {
                case TO_PAGE: 
                case TO_ROW: {
                    Map map = facesContext.getExternalContext().getRequestParameterMap();
                    Object value = map.get(clientId + "::" + "value");
                    try {
                        event.setValue(Integer.parseInt((String)value));
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Can't parse value for action " + action.name() + ": " + value));
                    }
                    break;
                }
            }
            component.queueEvent((FacesEvent)event);
        }
    }
}

