/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.io.OutputStream;
import java.io.Writer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.context.ResourceManager;
import org.apache.myfaces.tobago.context.ResourceManagerFactory;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TobagoRenderKit
extends RenderKit {
    private static final Log LOG = LogFactory.getLog(TobagoRenderKit.class);
    public static final String RENDER_KIT_ID = "tobago";
    private ResourceManager resources;

    public Renderer getRenderer(String family, String rendererType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("family = '" + family + "'"));
        }
        Renderer renderer = null;
        if (rendererType != null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (this.resources == null) {
                this.resources = ResourceManagerFactory.getResourceManager(facesContext);
            }
            renderer = this.resources.getRenderer(facesContext.getViewRoot(), rendererType);
        }
        if (renderer == null) {
            LOG.error((Object)("The class witch was found by the ResourceManager can't be found, or instanciated: classname='" + rendererType + "'"));
        }
        return renderer;
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String characterEncoding) {
        String contentType;
        if (contentTypeList == null) {
            contentType = "text/html";
        } else if (contentTypeList.indexOf("text/html") > -1) {
            contentType = "text/html";
            LOG.warn((Object)("patching content type from " + contentTypeList + " to " + contentType + "'"));
        } else if (contentTypeList.indexOf("text/fo") > -1) {
            contentType = "text/fo";
            LOG.warn((Object)("patching content type from " + contentTypeList + " to " + contentType + "'"));
        } else {
            contentType = "text/html";
            LOG.warn((Object)("Content-Type '" + contentTypeList + "' not supported!" + " Using text/html"), (Throwable)new Exception());
        }
        return new TobagoResponseWriter(writer, contentType, characterEncoding);
    }

    public void addRenderer(String family, String rendererType, Renderer renderer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addRenderer family='" + family + "' rendererType='" + rendererType + "'"));
        }
        LOG.error((Object)("This method isn't implemented yet, and should not be called: " + new Exception().getStackTrace()[0].getMethodName()));
    }

    public ResponseStateManager getResponseStateManager() {
        LOG.error((Object)("This method isn't implemented yet, and should not be called: " + new Exception().getStackTrace()[0].getMethodName()));
        return null;
    }

    public ResponseStream createResponseStream(OutputStream outputstream) {
        LOG.error((Object)("This method isn't implemented yet, and should not be called: " + new Exception().getStackTrace()[0].getMethodName()));
        return null;
    }
}

