/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html;

import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.util.LayoutUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public final class HtmlRendererUtil {
    private static final Log LOG = LogFactory.getLog(HtmlRendererUtil.class);

    private HtmlRendererUtil() {
    }

    public static void renderFocusId(FacesContext facesContext, UIComponent component) throws IOException {
        if (ComponentUtil.getBooleanAttribute(component, "focus")) {
            UIPage page = ComponentUtil.findPage(component);
            String id = component.getClientId(facesContext);
            if (page.getFocusId() != null && !page.getFocusId().equals(id)) {
                LOG.warn((Object)("page focusId = \"" + page.getFocusId() + "\" ignoring new value \"" + id + "\""));
            } else {
                ResponseWriter writer = facesContext.getResponseWriter();
                HtmlRendererUtil.startJavascript(writer);
                writer.write("Tobago.focusId = '" + id + "';");
                HtmlRendererUtil.endJavascript(writer);
            }
        }
    }

    public static void prepareRender(FacesContext facesContext, UIComponent component) {
        HtmlRendererUtil.createCssClass(facesContext, component);
        HtmlRendererUtil.layoutWidth(facesContext, component);
        HtmlRendererUtil.layoutHeight(facesContext, component);
    }

    public static void prepareInnerStyle(UIComponent component) {
        String innerStyle = "";
        Integer innerSpaceInteger = (Integer)component.getAttributes().get("innerWidth");
        if (innerSpaceInteger != null && innerSpaceInteger != -1) {
            innerStyle = "width: " + innerSpaceInteger + "px;";
        }
        if ((innerSpaceInteger = (Integer)component.getAttributes().get("innerHeight")) != null && innerSpaceInteger != -1) {
            innerStyle = innerStyle + " height: " + innerSpaceInteger + "px;";
        }
        component.getAttributes().put("style_inner", innerStyle);
    }

    public static void createCssClass(FacesContext facesContext, UIComponent component) {
        String rendererType = component.getRendererType();
        if (rendererType != null) {
            String rendererName = ComponentUtil.getRenderer(facesContext, component).getRendererName(rendererType);
            HtmlRendererUtil.createClassAttribute(component, rendererName);
        }
    }

    public static void writeLabelWithAccessKey(ResponseWriter writer, LabelWithAccessKey label) throws IOException {
        int pos = label.getPos();
        String text = label.getText();
        if (pos == -1) {
            writer.writeText((Object)text, null);
        } else {
            writer.writeText((Object)text.substring(0, pos), null);
            writer.write("<u>");
            writer.writeText((Object)Character.valueOf(text.charAt(pos)), null);
            writer.write("</u>");
            writer.writeText((Object)text.substring(pos + 1), null);
        }
    }

    public static void addClickAcceleratorKey(FacesContext facesContext, String clientId, char key) throws IOException {
        HtmlRendererUtil.addClickAcceleratorKey(facesContext, clientId, key, null);
    }

    public static void addClickAcceleratorKey(FacesContext facesContext, String clientId, char key, String modifier) throws IOException {
        StringBuffer buffer = HtmlRendererUtil.createOnclickAcceleratorKeyJsStatement(clientId, key, modifier);
        HtmlRendererUtil.writeScriptLoader(facesContext, null, new String[]{buffer.toString()});
    }

    public static void addAcceleratorKey(FacesContext facesContext, String func, char key) throws IOException {
        HtmlRendererUtil.addAcceleratorKey(facesContext, func, key, null);
    }

    public static void addAcceleratorKey(FacesContext facesContext, String func, char key, String modifier) throws IOException {
        StringBuffer buffer = HtmlRendererUtil.createAcceleratorKeyJsStatement(func, key, modifier);
        HtmlRendererUtil.writeScriptLoader(facesContext, null, new String[]{buffer.toString()});
    }

    public static StringBuffer createOnclickAcceleratorKeyJsStatement(String clientId, char key, String modifier) {
        String func = "Tobago.clickOnElement('" + clientId + "');";
        return HtmlRendererUtil.createAcceleratorKeyJsStatement(func, key, modifier);
    }

    public static StringBuffer createAcceleratorKeyJsStatement(String func, char key, String modifier) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("new Tobago.AcceleratorKey(function() {");
        buffer.append(func);
        if (!func.endsWith(";")) {
            buffer.append(';');
        }
        buffer.append("}, \"");
        buffer.append(key);
        if (modifier != null) {
            buffer.append("\", \"");
            buffer.append(modifier);
        }
        buffer.append("\");");
        return buffer;
    }

    public static String getLayoutSpaceStyle(UIComponent component) {
        StringBuffer sb = new StringBuffer();
        Integer space = LayoutUtil.getLayoutSpace(component, "layoutWidth", "layoutWidth");
        if (space != null) {
            sb.append(" width: ");
            sb.append(space);
            sb.append("px;");
        }
        if ((space = LayoutUtil.getLayoutSpace(component, "layoutHeight", "layoutHeight")) != null) {
            sb.append(" height: ");
            sb.append(space);
            sb.append("px;");
        }
        return sb.toString();
    }

    public static String getStyleAttributeValue(String style, String name) {
        if (style == null) {
            return null;
        }
        String value = null;
        StringTokenizer st = new StringTokenizer(style, ";");
        while (st.hasMoreTokens()) {
            String attribute = st.nextToken().trim();
            if (!attribute.startsWith(name)) continue;
            value = attribute.substring(attribute.indexOf(58) + 1).trim();
        }
        return value;
    }

    public static void replaceStyleAttribute(UIComponent component, String styleAttribute, String value) {
        Map attributes = component.getAttributes();
        String style = (String)attributes.get("style");
        style = HtmlRendererUtil.replaceStyleAttribute(style, styleAttribute, value);
        attributes.put("style", style);
    }

    public static String replaceStyleAttribute(String style, String name, String value) {
        style = HtmlRendererUtil.removeStyleAttribute(style != null ? style : "", name);
        return style + " " + name + ": " + value + ";";
    }

    public static String removeStyleAttribute(String style, String name) {
        if (style == null) {
            return null;
        }
        String pattern = name + "\\s*?:[^;]*?;";
        return style.replaceAll(pattern, "").trim();
    }

    public static void addCssClass(UIComponent component, String newClass) {
        Map attributes = component.getAttributes();
        String cssClass = (String)attributes.get("styleClass");
        if (cssClass == null) {
            attributes.put("styleClass", newClass);
        } else if (cssClass.indexOf(newClass + " ") == -1 || !cssClass.equals(newClass) || !cssClass.endsWith(newClass)) {
            cssClass = cssClass + " " + newClass;
            attributes.put("styleClass", cssClass);
        }
    }

    public static void layoutWidth(FacesContext facesContext, UIComponent component) {
        HtmlRendererUtil.layoutSpace(facesContext, component, true);
    }

    public static void layoutHeight(FacesContext facesContext, UIComponent component) {
        HtmlRendererUtil.layoutSpace(facesContext, component, false);
    }

    public static void layoutSpace(FacesContext facesContext, UIComponent component, boolean width) {
        UIComponent parent;
        String styleAttribute;
        String layoutAttribute;
        Integer layoutSpace;
        if (width) {
            layoutSpace = LayoutUtil.getLayoutWidth(component);
            layoutAttribute = "layoutWidth";
            styleAttribute = "width";
        } else {
            layoutSpace = LayoutUtil.getLayoutHeight(component);
            layoutAttribute = "layoutHeight";
            styleAttribute = "height";
        }
        int space = -1;
        if (layoutSpace != null) {
            space = layoutSpace;
        }
        if (space == -1 && !"Out".equals(component.getRendererType()) && (space = LayoutUtil.getInnerSpace(facesContext, parent = component.getParent(), width)) > 0 && !ComponentUtil.isFacetOf(component, parent)) {
            component.getAttributes().put(layoutAttribute, new Integer(space));
            if (width) {
                component.getAttributes().remove("innerWidth");
            } else {
                component.getAttributes().remove("innerHeight");
            }
        }
        if (space > 0) {
            int layoutSpace2;
            UIComponent layout;
            RendererBase renderer = ComponentUtil.getRenderer(facesContext, component);
            if (layoutSpace != null || !ComponentUtil.getBooleanAttribute(component, "inline")) {
                int styleSpace = space;
                if (renderer != null) {
                    styleSpace = width ? (styleSpace -= renderer.getComponentExtraWidth(facesContext, component)) : (styleSpace -= renderer.getComponentExtraHeight(facesContext, component));
                }
                HtmlRendererUtil.replaceStyleAttribute(component, styleAttribute, styleSpace + "px");
            }
            if ((layout = component.getFacet("layout")) != null && (layoutSpace2 = LayoutUtil.getInnerSpace(facesContext, component, width)) > 0) {
                layout.getAttributes().put(layoutAttribute, new Integer(layoutSpace2));
            }
        }
    }

    public static void createHeaderAndBodyStyles(FacesContext facesContext, UIComponent component) {
        HtmlRendererUtil.createHeaderAndBodyStyles(facesContext, component, true);
        HtmlRendererUtil.createHeaderAndBodyStyles(facesContext, component, false);
    }

    public static void createHeaderAndBodyStyles(FacesContext facesContext, UIComponent component, boolean width) {
        RendererBase renderer = ComponentUtil.getRenderer(facesContext, component);
        String style = (String)component.getAttributes().get("style");
        int styleSpace = -1;
        try {
            styleSpace = Integer.parseInt(HtmlRendererUtil.getStyleAttributeValue(style, width ? "width" : "height").replaceAll("\\D", ""));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (styleSpace != -1) {
            String bodyStyle;
            String headerStyle;
            int bodySpace = 0;
            int headerSpace = 0;
            if (!width) {
                if (renderer != null) {
                    headerSpace = renderer.getHeaderHeight(facesContext, component);
                }
                bodySpace = styleSpace - headerSpace;
            }
            if (width) {
                headerStyle = "width: " + styleSpace + "px;";
                bodyStyle = "width: " + styleSpace + "px;";
            } else {
                headerStyle = (String)component.getAttributes().get("style_header");
                if (headerStyle == null) {
                    LOG.warn((Object)"headerStyle attribute == null, set to empty String");
                    headerStyle = "";
                }
                headerStyle = headerStyle.replaceAll("height:\\s\\d+px;", "").trim();
                headerStyle = headerStyle + " height: " + headerSpace + "px;";
                bodyStyle = (String)component.getAttributes().get("style_body");
                if (bodyStyle == null) {
                    LOG.warn((Object)"bodyStyle attribute == null, set to empty String");
                    bodyStyle = "";
                }
                bodyStyle = bodyStyle.replaceAll("height:\\s\\d+px;", "").trim();
                bodyStyle = bodyStyle + " height: " + bodySpace + "px;";
            }
            component.getAttributes().put("style_header", headerStyle);
            component.getAttributes().put("style_body", bodyStyle);
        }
    }

    public static void createClassAttribute(UIComponent component, String name) {
        String rendererType = component.getRendererType();
        if (rendererType != null) {
            Object styleClassO = component.getAttributes().get("styleClass");
            if (styleClassO != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("styleClassO = '" + styleClassO.getClass().getName() + "'"));
            }
            String styleClass = (String)component.getAttributes().get("styleClass");
            styleClass = HtmlRendererUtil.updateClassAttribute(styleClass, name, component);
            component.getAttributes().put("styleClass", styleClass);
        }
    }

    private static String removeTobagoClasses(String s, String rendererName) {
        int length = s.length();
        if (length == 0) {
            return s;
        }
        StringBuffer newS = new StringBuffer(length);
        String toFind = "tobago-" + rendererName;
        int lastSpace = 0;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c != ' ' && i != length - 1) continue;
            String part = s.substring(lastSpace == 0 ? 0 : lastSpace + 1, i + 1);
            if (!part.startsWith(toFind)) {
                newS.append(part);
            }
            lastSpace = i;
        }
        return newS.toString();
    }

    public static String updateClassAttribute(String cssClass, String rendererName, UIComponent component) {
        String markup;
        cssClass = cssClass != null ? HtmlRendererUtil.removeTobagoClasses(cssClass, rendererName).trim() : "";
        StringBuffer prefix = new StringBuffer("tobago-").append(rendererName);
        StringBuffer tobagoClass = new StringBuffer(64).append(prefix).append("-default ");
        if (ComponentUtil.getBooleanAttribute(component, "disabled")) {
            tobagoClass.append(prefix).append("-disabled ");
        }
        if (ComponentUtil.getBooleanAttribute(component, "readonly")) {
            tobagoClass.append(prefix).append("-readonly ");
        }
        if (ComponentUtil.getBooleanAttribute(component, "inline")) {
            tobagoClass.append(prefix).append("-inline ");
        }
        if (ComponentUtil.isError(component)) {
            tobagoClass.append(prefix).append("-error ");
        }
        if (StringUtils.isNotEmpty((String)(markup = ComponentUtil.getStringAttribute(component, "markup")))) {
            if (markup.equals("strong") || markup.equals("deleted")) {
                tobagoClass.append(prefix).append("-markup-").append(markup).append(" ");
            } else {
                LOG.warn((Object)("Unknown markup='" + markup + "'"));
            }
        }
        return tobagoClass.append(cssClass).toString();
    }

    public static void addImageSources(FacesContext facesContext, ResponseWriter writer, String src, String id) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("new Tobago.Image('");
        buffer.append(id);
        buffer.append("','");
        buffer.append(ResourceManagerUtil.getImageWithPath(facesContext, src, false));
        buffer.append("','");
        buffer.append(ResourceManagerUtil.getImageWithPath(facesContext, HtmlRendererUtil.createSrc(src, "Disabled"), true));
        buffer.append("','");
        buffer.append(ResourceManagerUtil.getImageWithPath(facesContext, HtmlRendererUtil.createSrc(src, "Hover"), true));
        buffer.append("');");
        HtmlRendererUtil.writeJavascript(writer, buffer.toString());
    }

    public static String createSrc(String src, String ext) {
        int dot = src.lastIndexOf(46);
        if (dot == -1) {
            LOG.warn((Object)("Image src without extension: '" + src + "'"));
            return src;
        }
        return src.substring(0, dot) + ext + src.substring(dot);
    }

    public static void writeJavascript(ResponseWriter writer, String script) throws IOException {
        HtmlRendererUtil.startJavascript(writer);
        writer.writeText((Object)script, null);
        HtmlRendererUtil.endJavascript(writer);
    }

    public static void startJavascript(ResponseWriter writer) throws IOException {
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)"\n<!--\n", null);
    }

    public static void endJavascript(ResponseWriter writer) throws IOException {
        writer.writeText((Object)"\n// -->\n", null);
        writer.endElement("script");
    }

    public static void writeScriptLoader(FacesContext facesContext, String sctipt) throws IOException {
        HtmlRendererUtil.writeScriptLoader(facesContext, new String[]{sctipt}, null);
    }

    public static void writeScriptLoader(FacesContext facesContext, String[] scripts, String[] afterLoadCmds) throws IOException {
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        HtmlRendererUtil.startJavascript(writer);
        String allScripts = "[]";
        if (scripts != null) {
            allScripts = ResourceManagerUtil.getScriptsAsJSArray(facesContext, scripts);
        }
        writer.writeText("new Tobago.ScriptLoader(\n    ", null);
        writer.writeText(allScripts, null);
        if (afterLoadCmds != null && afterLoadCmds.length > 0) {
            writer.writeText(", \n", null);
            for (int i = 0; i < afterLoadCmds.length; ++i) {
                String cmd = StringUtils.replace((String)afterLoadCmds[i], (String)"\\", (String)"\\\\");
                cmd = StringUtils.replace((String)cmd, (String)"\"", (String)"\\\"");
                writer.writeText(i == 0 ? "          " : "        + ", null);
                writer.writeText("\"" + cmd + "\"\n", null);
            }
        }
        writer.writeText(");", null);
        HtmlRendererUtil.endJavascript(writer);
    }

    public static void writeStyleLoader(FacesContext facesContext, String[] styles) throws IOException {
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        HtmlRendererUtil.startJavascript(writer);
        String allStyles = ResourceManagerUtil.getStylesAsJSArray(facesContext, styles);
        writer.writeText("Tobago.ensureStyleFiles(\n    ", null);
        writer.writeText(allStyles, null);
        writer.writeText(");", null);
        HtmlRendererUtil.endJavascript(writer);
    }

    public static String addTip(String title, String tip) {
        if (tip != null) {
            title = title != null && title.length() > 0 ? title + " :: " : "";
            title = title + tip;
        }
        return title;
    }

    public static void main(String[] args) {
        System.out.println(HtmlRendererUtil.removeTobagoClasses("bla bla bla tobago-test-inline bla bla", "test"));
        System.out.println(HtmlRendererUtil.removeTobagoClasses("tobago-test-inline blablubber bla", "test"));
        System.out.println(HtmlRendererUtil.removeTobagoClasses("bla bla bla tobago-2test-inline bla tobago-test-blubber bla blubb", "test"));
        System.out.println(HtmlRendererUtil.removeTobagoClasses("bla bla bla tobago-testXXX", "test"));
        System.out.println(HtmlRendererUtil.removeTobagoClasses("tobago-test", "test"));
        System.out.println(HtmlRendererUtil.removeTobagoClasses(" x x ", "test"));
        System.out.println(HtmlRendererUtil.removeTobagoClasses("", "test"));
        System.out.println(HtmlRendererUtil.removeTobagoClasses("hallo", "test"));
    }
}

